import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#name DataAzurermLocalNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#resource_group_name DataAzurermLocalNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#timeouts DataAzurermLocalNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurermLocalNetworkGatewayTimeouts;
}
export interface DataAzurermLocalNetworkGatewayBgpSettings {
}
export declare function dataAzurermLocalNetworkGatewayBgpSettingsToTerraform(struct?: DataAzurermLocalNetworkGatewayBgpSettings): any;
export declare class DataAzurermLocalNetworkGatewayBgpSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermLocalNetworkGatewayBgpSettings | undefined;
    set internalValue(value: DataAzurermLocalNetworkGatewayBgpSettings | undefined);
    get asn(): number;
    get bgpPeeringAddress(): string;
    get peerWeight(): number;
}
export declare class DataAzurermLocalNetworkGatewayBgpSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermLocalNetworkGatewayBgpSettingsOutputReference;
}
export interface DataAzurermLocalNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#read DataAzurermLocalNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLocalNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermLocalNetworkGatewayTimeoutsOutputReference | DataAzurermLocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermLocalNetworkGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway}
*/
export declare class DataAzurermLocalNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_local_network_gateway";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLocalNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLocalNetworkGatewayConfig);
    get addressSpace(): string[];
    private _bgpSettings;
    get bgpSettings(): DataAzurermLocalNetworkGatewayBgpSettingsList;
    get gatewayAddress(): string;
    get gatewayFqdn(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLocalNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLocalNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
