import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSignalrServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service#name DataAzurermSignalrService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service#resource_group_name DataAzurermSignalrService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service#timeouts DataAzurermSignalrService#timeouts}
    */
    readonly timeouts?: DataAzurermSignalrServiceTimeouts;
}
export interface DataAzurermSignalrServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service#read DataAzurermSignalrService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSignalrServiceTimeoutsToTerraform(struct?: DataAzurermSignalrServiceTimeoutsOutputReference | DataAzurermSignalrServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSignalrServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSignalrServiceTimeouts | undefined;
    set internalValue(value: DataAzurermSignalrServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service azurerm_signalr_service}
*/
export declare class DataAzurermSignalrService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_signalr_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/signalr_service azurerm_signalr_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSignalrServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSignalrServiceConfig);
    get hostname(): string;
    get id(): string;
    get ipAddress(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermSignalrServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSignalrServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSignalrServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
