import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermStorageShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#metadata DataAzurermStorageShare#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#name DataAzurermStorageShare#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#storage_account_name DataAzurermStorageShare#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * acl block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#acl DataAzurermStorageShare#acl}
    */
    readonly acl?: DataAzurermStorageShareAcl[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#timeouts DataAzurermStorageShare#timeouts}
    */
    readonly timeouts?: DataAzurermStorageShareTimeouts;
}
export interface DataAzurermStorageShareAclAccessPolicy {
}
export declare function dataAzurermStorageShareAclAccessPolicyToTerraform(struct?: DataAzurermStorageShareAclAccessPolicy): any;
export declare class DataAzurermStorageShareAclAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermStorageShareAclAccessPolicy | undefined;
    set internalValue(value: DataAzurermStorageShareAclAccessPolicy | undefined);
    get expiry(): string;
    get permissions(): string;
    get start(): string;
}
export declare class DataAzurermStorageShareAclAccessPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermStorageShareAclAccessPolicyOutputReference;
}
export interface DataAzurermStorageShareAcl {
}
export declare function dataAzurermStorageShareAclToTerraform(struct?: DataAzurermStorageShareAcl | cdktf.IResolvable): any;
export interface DataAzurermStorageShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share#read DataAzurermStorageShare#read}
    */
    readonly read?: string;
}
export declare function dataAzurermStorageShareTimeoutsToTerraform(struct?: DataAzurermStorageShareTimeoutsOutputReference | DataAzurermStorageShareTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermStorageShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermStorageShareTimeouts | undefined;
    set internalValue(value: DataAzurermStorageShareTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share azurerm_storage_share}
*/
export declare class DataAzurermStorageShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_storage_share";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_share azurerm_storage_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermStorageShareConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermStorageShareConfig);
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get quota(): number;
    get resourceManagerId(): string;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _acl?;
    get acl(): DataAzurermStorageShareAcl[] | cdktf.IResolvable;
    set acl(value: DataAzurermStorageShareAcl[] | cdktf.IResolvable);
    resetAcl(): void;
    get aclInput(): cdktf.IResolvable | DataAzurermStorageShareAcl[] | undefined;
    private _timeouts;
    get timeouts(): DataAzurermStorageShareTimeoutsOutputReference;
    putTimeouts(value: DataAzurermStorageShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermStorageShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
