import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallApplicationRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#action FirewallApplicationRuleCollection#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#azure_firewall_name FirewallApplicationRuleCollection#azure_firewall_name}
    */
    readonly azureFirewallName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#name FirewallApplicationRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#priority FirewallApplicationRuleCollection#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#resource_group_name FirewallApplicationRuleCollection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#rule FirewallApplicationRuleCollection#rule}
    */
    readonly rule: FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#timeouts FirewallApplicationRuleCollection#timeouts}
    */
    readonly timeouts?: FirewallApplicationRuleCollectionTimeouts;
}
export interface FirewallApplicationRuleCollectionRuleProtocol {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#port FirewallApplicationRuleCollection#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#type FirewallApplicationRuleCollection#type}
    */
    readonly type: string;
}
export declare function firewallApplicationRuleCollectionRuleProtocolToTerraform(struct?: FirewallApplicationRuleCollectionRuleProtocol | cdktf.IResolvable): any;
export interface FirewallApplicationRuleCollectionRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#description FirewallApplicationRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#fqdn_tags FirewallApplicationRuleCollection#fqdn_tags}
    */
    readonly fqdnTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#name FirewallApplicationRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#source_addresses FirewallApplicationRuleCollection#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#source_ip_groups FirewallApplicationRuleCollection#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#target_fqdns FirewallApplicationRuleCollection#target_fqdns}
    */
    readonly targetFqdns?: string[];
    /**
    * protocol block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#protocol FirewallApplicationRuleCollection#protocol}
    */
    readonly protocol?: FirewallApplicationRuleCollectionRuleProtocol[] | cdktf.IResolvable;
}
export declare function firewallApplicationRuleCollectionRuleToTerraform(struct?: FirewallApplicationRuleCollectionRule | cdktf.IResolvable): any;
export interface FirewallApplicationRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#create FirewallApplicationRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#delete FirewallApplicationRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#read FirewallApplicationRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection#update FirewallApplicationRuleCollection#update}
    */
    readonly update?: string;
}
export declare function firewallApplicationRuleCollectionTimeoutsToTerraform(struct?: FirewallApplicationRuleCollectionTimeoutsOutputReference | FirewallApplicationRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class FirewallApplicationRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallApplicationRuleCollectionTimeouts | undefined;
    set internalValue(value: FirewallApplicationRuleCollectionTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection azurerm_firewall_application_rule_collection}
*/
export declare class FirewallApplicationRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall_application_rule_collection";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall_application_rule_collection azurerm_firewall_application_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallApplicationRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: FirewallApplicationRuleCollectionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _azureFirewallName?;
    get azureFirewallName(): string;
    set azureFirewallName(value: string);
    get azureFirewallNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule?;
    get rule(): FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable;
    set rule(value: FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable);
    get ruleInput(): cdktf.IResolvable | FirewallApplicationRuleCollectionRule[] | undefined;
    private _timeouts;
    get timeouts(): FirewallApplicationRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: FirewallApplicationRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirewallApplicationRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
