import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogAnalyticsClusterCustomerManagedKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#key_vault_key_id LogAnalyticsClusterCustomerManagedKey#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#log_analytics_cluster_id LogAnalyticsClusterCustomerManagedKey#log_analytics_cluster_id}
    */
    readonly logAnalyticsClusterId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#timeouts LogAnalyticsClusterCustomerManagedKey#timeouts}
    */
    readonly timeouts?: LogAnalyticsClusterCustomerManagedKeyTimeouts;
}
export interface LogAnalyticsClusterCustomerManagedKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#create LogAnalyticsClusterCustomerManagedKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#delete LogAnalyticsClusterCustomerManagedKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#read LogAnalyticsClusterCustomerManagedKey#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key#update LogAnalyticsClusterCustomerManagedKey#update}
    */
    readonly update?: string;
}
export declare function logAnalyticsClusterCustomerManagedKeyTimeoutsToTerraform(struct?: LogAnalyticsClusterCustomerManagedKeyTimeoutsOutputReference | LogAnalyticsClusterCustomerManagedKeyTimeouts | cdktf.IResolvable): any;
export declare class LogAnalyticsClusterCustomerManagedKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogAnalyticsClusterCustomerManagedKeyTimeouts | undefined;
    set internalValue(value: LogAnalyticsClusterCustomerManagedKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key azurerm_log_analytics_cluster_customer_managed_key}
*/
export declare class LogAnalyticsClusterCustomerManagedKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_log_analytics_cluster_customer_managed_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/log_analytics_cluster_customer_managed_key azurerm_log_analytics_cluster_customer_managed_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogAnalyticsClusterCustomerManagedKeyConfig
    */
    constructor(scope: Construct, id: string, config: LogAnalyticsClusterCustomerManagedKeyConfig);
    get id(): string;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    private _logAnalyticsClusterId?;
    get logAnalyticsClusterId(): string;
    set logAnalyticsClusterId(value: string);
    get logAnalyticsClusterIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogAnalyticsClusterCustomerManagedKeyTimeoutsOutputReference;
    putTimeouts(value: LogAnalyticsClusterCustomerManagedKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogAnalyticsClusterCustomerManagedKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
