import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkConnectionMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#auto_start NetworkConnectionMonitor#auto_start}
    */
    readonly autoStart?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#interval_in_seconds NetworkConnectionMonitor#interval_in_seconds}
    */
    readonly intervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#location NetworkConnectionMonitor#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#name NetworkConnectionMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#network_watcher_id NetworkConnectionMonitor#network_watcher_id}
    */
    readonly networkWatcherId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#notes NetworkConnectionMonitor#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#output_workspace_resource_ids NetworkConnectionMonitor#output_workspace_resource_ids}
    */
    readonly outputWorkspaceResourceIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#tags NetworkConnectionMonitor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * destination block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#destination NetworkConnectionMonitor#destination}
    */
    readonly destination?: NetworkConnectionMonitorDestination;
    /**
    * endpoint block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#endpoint NetworkConnectionMonitor#endpoint}
    */
    readonly endpoint: NetworkConnectionMonitorEndpoint[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#source NetworkConnectionMonitor#source}
    */
    readonly source?: NetworkConnectionMonitorSource;
    /**
    * test_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#test_configuration NetworkConnectionMonitor#test_configuration}
    */
    readonly testConfiguration: NetworkConnectionMonitorTestConfiguration[] | cdktf.IResolvable;
    /**
    * test_group block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#test_group NetworkConnectionMonitor#test_group}
    */
    readonly testGroup: NetworkConnectionMonitorTestGroup[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#timeouts NetworkConnectionMonitor#timeouts}
    */
    readonly timeouts?: NetworkConnectionMonitorTimeouts;
}
export interface NetworkConnectionMonitorDestination {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#address NetworkConnectionMonitor#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#port NetworkConnectionMonitor#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}
    */
    readonly virtualMachineId?: string;
}
export declare function networkConnectionMonitorDestinationToTerraform(struct?: NetworkConnectionMonitorDestinationOutputReference | NetworkConnectionMonitorDestination): any;
export declare class NetworkConnectionMonitorDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorDestination | undefined;
    set internalValue(value: NetworkConnectionMonitorDestination | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    resetVirtualMachineId(): void;
    get virtualMachineIdInput(): string | undefined;
}
export interface NetworkConnectionMonitorEndpointFilterItem {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#address NetworkConnectionMonitor#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#type NetworkConnectionMonitor#type}
    */
    readonly type?: string;
}
export declare function networkConnectionMonitorEndpointFilterItemToTerraform(struct?: NetworkConnectionMonitorEndpointFilterItem | cdktf.IResolvable): any;
export interface NetworkConnectionMonitorEndpointFilter {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#type NetworkConnectionMonitor#type}
    */
    readonly type?: string;
    /**
    * item block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#item NetworkConnectionMonitor#item}
    */
    readonly item?: NetworkConnectionMonitorEndpointFilterItem[] | cdktf.IResolvable;
}
export declare function networkConnectionMonitorEndpointFilterToTerraform(struct?: NetworkConnectionMonitorEndpointFilterOutputReference | NetworkConnectionMonitorEndpointFilter): any;
export declare class NetworkConnectionMonitorEndpointFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorEndpointFilter | undefined;
    set internalValue(value: NetworkConnectionMonitorEndpointFilter | undefined);
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _item?;
    get item(): NetworkConnectionMonitorEndpointFilterItem[] | cdktf.IResolvable;
    set item(value: NetworkConnectionMonitorEndpointFilterItem[] | cdktf.IResolvable);
    resetItem(): void;
    get itemInput(): cdktf.IResolvable | NetworkConnectionMonitorEndpointFilterItem[] | undefined;
}
export interface NetworkConnectionMonitorEndpoint {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#address NetworkConnectionMonitor#address}
    */
    readonly address?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#coverage_level NetworkConnectionMonitor#coverage_level}
    */
    readonly coverageLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#excluded_ip_addresses NetworkConnectionMonitor#excluded_ip_addresses}
    */
    readonly excludedIpAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#included_ip_addresses NetworkConnectionMonitor#included_ip_addresses}
    */
    readonly includedIpAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#name NetworkConnectionMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#target_resource_id NetworkConnectionMonitor#target_resource_id}
    */
    readonly targetResourceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#target_resource_type NetworkConnectionMonitor#target_resource_type}
    */
    readonly targetResourceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}
    */
    readonly virtualMachineId?: string;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#filter NetworkConnectionMonitor#filter}
    */
    readonly filter?: NetworkConnectionMonitorEndpointFilter;
}
export declare function networkConnectionMonitorEndpointToTerraform(struct?: NetworkConnectionMonitorEndpoint | cdktf.IResolvable): any;
export interface NetworkConnectionMonitorSource {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#port NetworkConnectionMonitor#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#virtual_machine_id NetworkConnectionMonitor#virtual_machine_id}
    */
    readonly virtualMachineId?: string;
}
export declare function networkConnectionMonitorSourceToTerraform(struct?: NetworkConnectionMonitorSourceOutputReference | NetworkConnectionMonitorSource): any;
export declare class NetworkConnectionMonitorSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorSource | undefined;
    set internalValue(value: NetworkConnectionMonitorSource | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _virtualMachineId?;
    get virtualMachineId(): string;
    set virtualMachineId(value: string);
    resetVirtualMachineId(): void;
    get virtualMachineIdInput(): string | undefined;
}
export interface NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#name NetworkConnectionMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#value NetworkConnectionMonitor#value}
    */
    readonly value: string;
}
export declare function networkConnectionMonitorTestConfigurationHttpConfigurationRequestHeaderToTerraform(struct?: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader | cdktf.IResolvable): any;
export interface NetworkConnectionMonitorTestConfigurationHttpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#method NetworkConnectionMonitor#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#path NetworkConnectionMonitor#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#port NetworkConnectionMonitor#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#prefer_https NetworkConnectionMonitor#prefer_https}
    */
    readonly preferHttps?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#valid_status_code_ranges NetworkConnectionMonitor#valid_status_code_ranges}
    */
    readonly validStatusCodeRanges?: string[];
    /**
    * request_header block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#request_header NetworkConnectionMonitor#request_header}
    */
    readonly requestHeader?: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[] | cdktf.IResolvable;
}
export declare function networkConnectionMonitorTestConfigurationHttpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationHttpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationHttpConfiguration): any;
export declare class NetworkConnectionMonitorTestConfigurationHttpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorTestConfigurationHttpConfiguration | undefined;
    set internalValue(value: NetworkConnectionMonitorTestConfigurationHttpConfiguration | undefined);
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _preferHttps?;
    get preferHttps(): boolean | cdktf.IResolvable;
    set preferHttps(value: boolean | cdktf.IResolvable);
    resetPreferHttps(): void;
    get preferHttpsInput(): boolean | cdktf.IResolvable | undefined;
    private _validStatusCodeRanges?;
    get validStatusCodeRanges(): string[];
    set validStatusCodeRanges(value: string[]);
    resetValidStatusCodeRanges(): void;
    get validStatusCodeRangesInput(): string[] | undefined;
    private _requestHeader?;
    get requestHeader(): NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[] | cdktf.IResolvable;
    set requestHeader(value: NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[] | cdktf.IResolvable);
    resetRequestHeader(): void;
    get requestHeaderInput(): cdktf.IResolvable | NetworkConnectionMonitorTestConfigurationHttpConfigurationRequestHeader[] | undefined;
}
export interface NetworkConnectionMonitorTestConfigurationIcmpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#trace_route_enabled NetworkConnectionMonitor#trace_route_enabled}
    */
    readonly traceRouteEnabled?: boolean | cdktf.IResolvable;
}
export declare function networkConnectionMonitorTestConfigurationIcmpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationIcmpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationIcmpConfiguration): any;
export declare class NetworkConnectionMonitorTestConfigurationIcmpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorTestConfigurationIcmpConfiguration | undefined;
    set internalValue(value: NetworkConnectionMonitorTestConfigurationIcmpConfiguration | undefined);
    private _traceRouteEnabled?;
    get traceRouteEnabled(): boolean | cdktf.IResolvable;
    set traceRouteEnabled(value: boolean | cdktf.IResolvable);
    resetTraceRouteEnabled(): void;
    get traceRouteEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetworkConnectionMonitorTestConfigurationSuccessThreshold {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#checks_failed_percent NetworkConnectionMonitor#checks_failed_percent}
    */
    readonly checksFailedPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#round_trip_time_ms NetworkConnectionMonitor#round_trip_time_ms}
    */
    readonly roundTripTimeMs?: number;
}
export declare function networkConnectionMonitorTestConfigurationSuccessThresholdToTerraform(struct?: NetworkConnectionMonitorTestConfigurationSuccessThresholdOutputReference | NetworkConnectionMonitorTestConfigurationSuccessThreshold): any;
export declare class NetworkConnectionMonitorTestConfigurationSuccessThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorTestConfigurationSuccessThreshold | undefined;
    set internalValue(value: NetworkConnectionMonitorTestConfigurationSuccessThreshold | undefined);
    private _checksFailedPercent?;
    get checksFailedPercent(): number;
    set checksFailedPercent(value: number);
    resetChecksFailedPercent(): void;
    get checksFailedPercentInput(): number | undefined;
    private _roundTripTimeMs?;
    get roundTripTimeMs(): number;
    set roundTripTimeMs(value: number);
    resetRoundTripTimeMs(): void;
    get roundTripTimeMsInput(): number | undefined;
}
export interface NetworkConnectionMonitorTestConfigurationTcpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#destination_port_behavior NetworkConnectionMonitor#destination_port_behavior}
    */
    readonly destinationPortBehavior?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#port NetworkConnectionMonitor#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#trace_route_enabled NetworkConnectionMonitor#trace_route_enabled}
    */
    readonly traceRouteEnabled?: boolean | cdktf.IResolvable;
}
export declare function networkConnectionMonitorTestConfigurationTcpConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfigurationTcpConfigurationOutputReference | NetworkConnectionMonitorTestConfigurationTcpConfiguration): any;
export declare class NetworkConnectionMonitorTestConfigurationTcpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorTestConfigurationTcpConfiguration | undefined;
    set internalValue(value: NetworkConnectionMonitorTestConfigurationTcpConfiguration | undefined);
    private _destinationPortBehavior?;
    get destinationPortBehavior(): string;
    set destinationPortBehavior(value: string);
    resetDestinationPortBehavior(): void;
    get destinationPortBehaviorInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _traceRouteEnabled?;
    get traceRouteEnabled(): boolean | cdktf.IResolvable;
    set traceRouteEnabled(value: boolean | cdktf.IResolvable);
    resetTraceRouteEnabled(): void;
    get traceRouteEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetworkConnectionMonitorTestConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#name NetworkConnectionMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#preferred_ip_version NetworkConnectionMonitor#preferred_ip_version}
    */
    readonly preferredIpVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#protocol NetworkConnectionMonitor#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#test_frequency_in_seconds NetworkConnectionMonitor#test_frequency_in_seconds}
    */
    readonly testFrequencyInSeconds?: number;
    /**
    * http_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#http_configuration NetworkConnectionMonitor#http_configuration}
    */
    readonly httpConfiguration?: NetworkConnectionMonitorTestConfigurationHttpConfiguration;
    /**
    * icmp_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#icmp_configuration NetworkConnectionMonitor#icmp_configuration}
    */
    readonly icmpConfiguration?: NetworkConnectionMonitorTestConfigurationIcmpConfiguration;
    /**
    * success_threshold block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#success_threshold NetworkConnectionMonitor#success_threshold}
    */
    readonly successThreshold?: NetworkConnectionMonitorTestConfigurationSuccessThreshold;
    /**
    * tcp_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#tcp_configuration NetworkConnectionMonitor#tcp_configuration}
    */
    readonly tcpConfiguration?: NetworkConnectionMonitorTestConfigurationTcpConfiguration;
}
export declare function networkConnectionMonitorTestConfigurationToTerraform(struct?: NetworkConnectionMonitorTestConfiguration | cdktf.IResolvable): any;
export interface NetworkConnectionMonitorTestGroup {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#destination_endpoints NetworkConnectionMonitor#destination_endpoints}
    */
    readonly destinationEndpoints: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#enabled NetworkConnectionMonitor#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#name NetworkConnectionMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#source_endpoints NetworkConnectionMonitor#source_endpoints}
    */
    readonly sourceEndpoints: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#test_configuration_names NetworkConnectionMonitor#test_configuration_names}
    */
    readonly testConfigurationNames: string[];
}
export declare function networkConnectionMonitorTestGroupToTerraform(struct?: NetworkConnectionMonitorTestGroup | cdktf.IResolvable): any;
export interface NetworkConnectionMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#create NetworkConnectionMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#delete NetworkConnectionMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#read NetworkConnectionMonitor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor#update NetworkConnectionMonitor#update}
    */
    readonly update?: string;
}
export declare function networkConnectionMonitorTimeoutsToTerraform(struct?: NetworkConnectionMonitorTimeoutsOutputReference | NetworkConnectionMonitorTimeouts | cdktf.IResolvable): any;
export declare class NetworkConnectionMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectionMonitorTimeouts | undefined;
    set internalValue(value: NetworkConnectionMonitorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor azurerm_network_connection_monitor}
*/
export declare class NetworkConnectionMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_connection_monitor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_connection_monitor azurerm_network_connection_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkConnectionMonitorConfig
    */
    constructor(scope: Construct, id: string, config: NetworkConnectionMonitorConfig);
    private _autoStart?;
    get autoStart(): boolean | cdktf.IResolvable;
    set autoStart(value: boolean | cdktf.IResolvable);
    resetAutoStart(): void;
    get autoStartInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _intervalInSeconds?;
    get intervalInSeconds(): number;
    set intervalInSeconds(value: number);
    resetIntervalInSeconds(): void;
    get intervalInSecondsInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkWatcherId?;
    get networkWatcherId(): string;
    set networkWatcherId(value: string);
    get networkWatcherIdInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _outputWorkspaceResourceIds?;
    get outputWorkspaceResourceIds(): string[];
    set outputWorkspaceResourceIds(value: string[]);
    resetOutputWorkspaceResourceIds(): void;
    get outputWorkspaceResourceIdsInput(): string[] | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _destination;
    get destination(): NetworkConnectionMonitorDestinationOutputReference;
    putDestination(value: NetworkConnectionMonitorDestination): void;
    resetDestination(): void;
    get destinationInput(): NetworkConnectionMonitorDestination | undefined;
    private _endpoint?;
    get endpoint(): NetworkConnectionMonitorEndpoint[] | cdktf.IResolvable;
    set endpoint(value: NetworkConnectionMonitorEndpoint[] | cdktf.IResolvable);
    get endpointInput(): cdktf.IResolvable | NetworkConnectionMonitorEndpoint[] | undefined;
    private _source;
    get source(): NetworkConnectionMonitorSourceOutputReference;
    putSource(value: NetworkConnectionMonitorSource): void;
    resetSource(): void;
    get sourceInput(): NetworkConnectionMonitorSource | undefined;
    private _testConfiguration?;
    get testConfiguration(): NetworkConnectionMonitorTestConfiguration[] | cdktf.IResolvable;
    set testConfiguration(value: NetworkConnectionMonitorTestConfiguration[] | cdktf.IResolvable);
    get testConfigurationInput(): cdktf.IResolvable | NetworkConnectionMonitorTestConfiguration[] | undefined;
    private _testGroup?;
    get testGroup(): NetworkConnectionMonitorTestGroup[] | cdktf.IResolvable;
    set testGroup(value: NetworkConnectionMonitorTestGroup[] | cdktf.IResolvable);
    get testGroupInput(): cdktf.IResolvable | NetworkConnectionMonitorTestGroup[] | undefined;
    private _timeouts;
    get timeouts(): NetworkConnectionMonitorTimeoutsOutputReference;
    putTimeouts(value: NetworkConnectionMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkConnectionMonitorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
