import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PostgresqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#charset PostgresqlDatabase#charset}
    */
    readonly charset: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#collation PostgresqlDatabase#collation}
    */
    readonly collation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#name PostgresqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#resource_group_name PostgresqlDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#server_name PostgresqlDatabase#server_name}
    */
    readonly serverName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#timeouts PostgresqlDatabase#timeouts}
    */
    readonly timeouts?: PostgresqlDatabaseTimeouts;
}
export interface PostgresqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#create PostgresqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#delete PostgresqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#read PostgresqlDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database#update PostgresqlDatabase#update}
    */
    readonly update?: string;
}
export declare function postgresqlDatabaseTimeoutsToTerraform(struct?: PostgresqlDatabaseTimeoutsOutputReference | PostgresqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class PostgresqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PostgresqlDatabaseTimeouts | undefined;
    set internalValue(value: PostgresqlDatabaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database azurerm_postgresql_database}
*/
export declare class PostgresqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_postgresql_database";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/postgresql_database azurerm_postgresql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PostgresqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: PostgresqlDatabaseConfig);
    private _charset?;
    get charset(): string;
    set charset(value: string);
    get charsetInput(): string | undefined;
    private _collation?;
    get collation(): string;
    set collation(value: string);
    get collationInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): PostgresqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: PostgresqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PostgresqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
