import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceGroupTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#debug_level ResourceGroupTemplateDeployment#debug_level}
    */
    readonly debugLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#deployment_mode ResourceGroupTemplateDeployment#deployment_mode}
    */
    readonly deploymentMode: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#name ResourceGroupTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#parameters_content ResourceGroupTemplateDeployment#parameters_content}
    */
    readonly parametersContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#resource_group_name ResourceGroupTemplateDeployment#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#tags ResourceGroupTemplateDeployment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#template_content ResourceGroupTemplateDeployment#template_content}
    */
    readonly templateContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#template_spec_version_id ResourceGroupTemplateDeployment#template_spec_version_id}
    */
    readonly templateSpecVersionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#timeouts ResourceGroupTemplateDeployment#timeouts}
    */
    readonly timeouts?: ResourceGroupTemplateDeploymentTimeouts;
}
export interface ResourceGroupTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#create ResourceGroupTemplateDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#delete ResourceGroupTemplateDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#read ResourceGroupTemplateDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment#update ResourceGroupTemplateDeployment#update}
    */
    readonly update?: string;
}
export declare function resourceGroupTemplateDeploymentTimeoutsToTerraform(struct?: ResourceGroupTemplateDeploymentTimeoutsOutputReference | ResourceGroupTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class ResourceGroupTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceGroupTemplateDeploymentTimeouts | undefined;
    set internalValue(value: ResourceGroupTemplateDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment azurerm_resource_group_template_deployment}
*/
export declare class ResourceGroupTemplateDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_resource_group_template_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/resource_group_template_deployment azurerm_resource_group_template_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceGroupTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: ResourceGroupTemplateDeploymentConfig);
    private _debugLevel?;
    get debugLevel(): string;
    set debugLevel(value: string);
    resetDebugLevel(): void;
    get debugLevelInput(): string | undefined;
    private _deploymentMode?;
    get deploymentMode(): string;
    set deploymentMode(value: string);
    get deploymentModeInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _parametersContent?;
    get parametersContent(): string;
    set parametersContent(value: string);
    resetParametersContent(): void;
    get parametersContentInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _templateContent?;
    get templateContent(): string;
    set templateContent(value: string);
    resetTemplateContent(): void;
    get templateContentInput(): string | undefined;
    private _templateSpecVersionId?;
    get templateSpecVersionId(): string;
    set templateSpecVersionId(value: string);
    resetTemplateSpecVersionId(): void;
    get templateSpecVersionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ResourceGroupTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: ResourceGroupTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ResourceGroupTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
