import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubscriptionTemplateDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#debug_level SubscriptionTemplateDeployment#debug_level}
    */
    readonly debugLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#location SubscriptionTemplateDeployment#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#name SubscriptionTemplateDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#parameters_content SubscriptionTemplateDeployment#parameters_content}
    */
    readonly parametersContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#tags SubscriptionTemplateDeployment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#template_content SubscriptionTemplateDeployment#template_content}
    */
    readonly templateContent?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#template_spec_version_id SubscriptionTemplateDeployment#template_spec_version_id}
    */
    readonly templateSpecVersionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#timeouts SubscriptionTemplateDeployment#timeouts}
    */
    readonly timeouts?: SubscriptionTemplateDeploymentTimeouts;
}
export interface SubscriptionTemplateDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#create SubscriptionTemplateDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#delete SubscriptionTemplateDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#read SubscriptionTemplateDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment#update SubscriptionTemplateDeployment#update}
    */
    readonly update?: string;
}
export declare function subscriptionTemplateDeploymentTimeoutsToTerraform(struct?: SubscriptionTemplateDeploymentTimeoutsOutputReference | SubscriptionTemplateDeploymentTimeouts | cdktf.IResolvable): any;
export declare class SubscriptionTemplateDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubscriptionTemplateDeploymentTimeouts | undefined;
    set internalValue(value: SubscriptionTemplateDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment azurerm_subscription_template_deployment}
*/
export declare class SubscriptionTemplateDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subscription_template_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/subscription_template_deployment azurerm_subscription_template_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubscriptionTemplateDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: SubscriptionTemplateDeploymentConfig);
    private _debugLevel?;
    get debugLevel(): string;
    set debugLevel(value: string);
    resetDebugLevel(): void;
    get debugLevelInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputContent(): string;
    private _parametersContent?;
    get parametersContent(): string;
    set parametersContent(value: string);
    resetParametersContent(): void;
    get parametersContentInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _templateContent?;
    get templateContent(): string;
    set templateContent(value: string);
    resetTemplateContent(): void;
    get templateContentInput(): string | undefined;
    private _templateSpecVersionId?;
    get templateSpecVersionId(): string;
    set templateSpecVersionId(value: string);
    resetTemplateSpecVersionId(): void;
    get templateSpecVersionIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SubscriptionTemplateDeploymentTimeoutsOutputReference;
    putTimeouts(value: SubscriptionTemplateDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SubscriptionTemplateDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
