generate_yaml_macro = """
{% macro dbt_yamer_generate_column_yaml(column, model_yaml, column_desc_dict, include_data_types, parent_column_name="") %}
  {{ return(default__dbt_yamer_generate_column_yaml(column, model_yaml, column_desc_dict, include_data_types, parent_column_name)) }}
{% endmacro %}

{% macro default__dbt_yamer_generate_column_yaml(column, model_yaml, column_desc_dict, include_data_types, parent_column_name) %}
    {% if parent_column_name %}
        {% set column_name = parent_column_name ~ "." ~ column.name %}
    {% else %}
        {% set column_name = column.name %}
    {% endif %}

    {% do model_yaml.append('      - name: ' ~ column_name  | lower ) %}
    {% if include_data_types %}
        {% do model_yaml.append(dbt_yamer_data_type_format_model(column)) %}
    {% endif %}
    {% do model_yaml.append('        description: "' ~ column_desc_dict.get(column.name | lower,'') ~ '"') %}
    {% do model_yaml.append('') %}

    {% if column.fields|length > 0 %}
        {% for child_column in column.fields %}
            {% set model_yaml = default__dbt_yamer_generate_column_yaml(child_column, model_yaml, column_desc_dict, include_data_types, parent_column_name=column_name) %}
        {% endfor %}
    {% endif %}
    {% do return(model_yaml) %}
{% endmacro %}

{% macro dbt_yamer_generate_contract_yaml(model_names=[], upstream_descriptions=False, include_data_types=True) -%}
  {{ return(default__dbt_yamer_generate_model_yaml(model_names, upstream_descriptions, include_data_types)) }}
{%- endmacro %}

{% macro default__dbt_yamer_generate_model_yaml(model_names, upstream_descriptions, include_data_types) %}

    {% set model_yaml=[] %}

    {% do model_yaml.append('version: 2') %}
    {% do model_yaml.append('') %}
    {% do model_yaml.append('models:') %}

    {% if model_names is string %}
        {{ exceptions.raise_compiler_error("The `model_names` argument must always be a list, even if there is only one model.") }}
    {% else %}
        {% for model in model_names %}
            {% do model_yaml.append('  - name: ' ~ model | lower) %}
            {% do model_yaml.append('    description: ""') %}
            {% do model_yaml.append('    config:
      contract:
        enforced: true') %}
            {% do model_yaml.append('    columns:') %}

            {% set relation = ref(model) %}
            {%- set columns = adapter.get_columns_in_relation(relation) -%}
            {% set column_desc_dict =  dbt_yamer_build_dict_column_descriptions(model) if upstream_descriptions else {} %}

            {% for column in columns %}
                {% set model_yaml = default__dbt_yamer_generate_column_yaml(column, model_yaml, column_desc_dict, include_data_types) %}
            {% endfor %}
        {% endfor %}
    {% endif %}

{% if execute %}

    {% set joined = model_yaml | join ('\n') %}
    {{ print(joined) }}
    {% do return(joined) %}

{% endif %}

{% endmacro %}

{% macro dbt_yamer_data_type_format_model(column) %}
    {% if 'ARRAY<STRUCT<' in column.data_type %}
        {{ return('        data_type: ARRAY\n        type: RECORD REPEATED') }}
    {% else %}
        {{ return('        data_type: ' ~ column.data_type) }}
    {% endif %}
{% endmacro %}

{% macro dbt_yamer_build_dict_column_descriptions(model) %}
    {% set descriptions = {} %}
    {{ return(descriptions) }}
{% endmacro %}

"""
