import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementNotificationRecipientEmailConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#api_management_id ApiManagementNotificationRecipientEmail#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#email ApiManagementNotificationRecipientEmail#email}.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#notification_type ApiManagementNotificationRecipientEmail#notification_type}.
     *
     * @stability stable
     */
    readonly notificationType: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#timeouts ApiManagementNotificationRecipientEmail#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementNotificationRecipientEmailTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementNotificationRecipientEmailTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#create ApiManagementNotificationRecipientEmail#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#delete ApiManagementNotificationRecipientEmail#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email#read ApiManagementNotificationRecipientEmail#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function apiManagementNotificationRecipientEmailTimeoutsToTerraform(struct?: ApiManagementNotificationRecipientEmailTimeoutsOutputReference | ApiManagementNotificationRecipientEmailTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ApiManagementNotificationRecipientEmailTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementNotificationRecipientEmailTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementNotificationRecipientEmailTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email azurerm_api_management_notification_recipient_email}.
 *
 * @stability stable
 */
export declare class ApiManagementNotificationRecipientEmail extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_email azurerm_api_management_notification_recipient_email} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementNotificationRecipientEmailConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _notificationType?;
    /**
     * @stability stable
     */
    get notificationType(): string;
    /**
     * @stability stable
     */
    set notificationType(value: string);
    /**
     * @stability stable
     */
    get notificationTypeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementNotificationRecipientEmailTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementNotificationRecipientEmailTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementNotificationRecipientEmailTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
