import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BastionHostConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#copy_paste_enabled BastionHost#copy_paste_enabled}.
     *
     * @stability stable
     */
    readonly copyPasteEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#file_copy_enabled BastionHost#file_copy_enabled}.
     *
     * @stability stable
     */
    readonly fileCopyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#ip_connect_enabled BastionHost#ip_connect_enabled}.
     *
     * @stability stable
     */
    readonly ipConnectEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#location BastionHost#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#name BastionHost#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#resource_group_name BastionHost#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#scale_units BastionHost#scale_units}.
     *
     * @stability stable
     */
    readonly scaleUnits?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#shareable_link_enabled BastionHost#shareable_link_enabled}.
     *
     * @stability stable
     */
    readonly shareableLinkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#sku BastionHost#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#tags BastionHost#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#tunneling_enabled BastionHost#tunneling_enabled}.
     *
     * @stability stable
     */
    readonly tunnelingEnabled?: boolean | cdktf.IResolvable;
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#ip_configuration BastionHost#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: BastionHostIpConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#timeouts BastionHost#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BastionHostTimeouts;
}
/**
 * @stability stable
 */
export interface BastionHostIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#name BastionHost#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#public_ip_address_id BastionHost#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#subnet_id BastionHost#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function bastionHostIpConfigurationToTerraform(struct?: BastionHostIpConfigurationOutputReference | BastionHostIpConfiguration): any;
/**
 * @stability stable
 */
export declare class BastionHostIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BastionHostIpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BastionHostIpConfiguration | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicIpAddressId?;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    set publicIpAddressId(value: string);
    /**
     * @stability stable
     */
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BastionHostTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#create BastionHost#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#delete BastionHost#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#read BastionHost#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host#update BastionHost#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function bastionHostTimeoutsToTerraform(struct?: BastionHostTimeoutsOutputReference | BastionHostTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class BastionHostTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BastionHostTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BastionHostTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host azurerm_bastion_host}.
 *
 * @stability stable
 */
export declare class BastionHost extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bastion_host azurerm_bastion_host} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BastionHostConfig);
    private _copyPasteEnabled?;
    /**
     * @stability stable
     */
    get copyPasteEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set copyPasteEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCopyPasteEnabled(): void;
    /**
     * @stability stable
     */
    get copyPasteEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get dnsName(): string;
    private _fileCopyEnabled?;
    /**
     * @stability stable
     */
    get fileCopyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set fileCopyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFileCopyEnabled(): void;
    /**
     * @stability stable
     */
    get fileCopyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _ipConnectEnabled?;
    /**
     * @stability stable
     */
    get ipConnectEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ipConnectEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIpConnectEnabled(): void;
    /**
     * @stability stable
     */
    get ipConnectEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _scaleUnits?;
    /**
     * @stability stable
     */
    get scaleUnits(): number;
    /**
     * @stability stable
     */
    set scaleUnits(value: number);
    /**
     * @stability stable
     */
    resetScaleUnits(): void;
    /**
     * @stability stable
     */
    get scaleUnitsInput(): number | undefined;
    private _shareableLinkEnabled?;
    /**
     * @stability stable
     */
    get shareableLinkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set shareableLinkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShareableLinkEnabled(): void;
    /**
     * @stability stable
     */
    get shareableLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tunnelingEnabled?;
    /**
     * @stability stable
     */
    get tunnelingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tunnelingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTunnelingEnabled(): void;
    /**
     * @stability stable
     */
    get tunnelingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipConfiguration;
    /**
     * @stability stable
     */
    get ipConfiguration(): BastionHostIpConfigurationOutputReference;
    /**
     * @stability stable
     */
    putIpConfiguration(value: BastionHostIpConfiguration): void;
    /**
     * @stability stable
     */
    resetIpConfiguration(): void;
    /**
     * @stability stable
     */
    get ipConfigurationInput(): BastionHostIpConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BastionHostTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BastionHostTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BastionHostTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
