import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermActiveDirectoryDomainServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#name DataAzurermActiveDirectoryDomainService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#resource_group_name DataAzurermActiveDirectoryDomainService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#timeouts DataAzurermActiveDirectoryDomainService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermActiveDirectoryDomainServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainServiceNotifications extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get additionalRecipients(): string[];
    /**
     * @stability stable
     */
    get notifyDcAdmins(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get notifyGlobalAdmins(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainServiceReplicaSets extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get domainControllerIpAddresses(): string[];
    /**
     * @stability stable
     */
    get externalAccessIpAddress(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get serviceStatus(): string;
    /**
     * @stability stable
     */
    get subnetId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainServiceSecureLdap extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get certificateExpiry(): string;
    /**
     * @stability stable
     */
    get certificateThumbprint(): string;
    /**
     * @stability stable
     */
    get enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get externalAccessEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get publicCertificate(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainServiceSecurity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ntlmV1Enabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get syncKerberosPasswords(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get syncNtlmPasswords(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get syncOnPremPasswords(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tlsV1Enabled(): cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface DataAzurermActiveDirectoryDomainServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#read DataAzurermActiveDirectoryDomainService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermActiveDirectoryDomainServiceTimeoutsToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference | DataAzurermActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermActiveDirectoryDomainServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service azurerm_active_directory_domain_service}.
 *
 * @stability stable
 */
export declare class DataAzurermActiveDirectoryDomainService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service azurerm_active_directory_domain_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermActiveDirectoryDomainServiceConfig);
    /**
     * @stability stable
     */
    get deploymentId(): string;
    /**
     * @stability stable
     */
    get domainConfigurationType(): string;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    get filteredSyncEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    notifications(index: string): DataAzurermActiveDirectoryDomainServiceNotifications;
    /**
     * @stability stable
     */
    replicaSets(index: string): DataAzurermActiveDirectoryDomainServiceReplicaSets;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    secureLdap(index: string): DataAzurermActiveDirectoryDomainServiceSecureLdap;
    /**
     * @stability stable
     */
    security(index: string): DataAzurermActiveDirectoryDomainServiceSecurity;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    get syncOwner(): string;
    /**
     * @stability stable
     */
    tags(key: string): string | cdktf.IResolvable;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get version(): number;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermActiveDirectoryDomainServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermActiveDirectoryDomainServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
