import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDiskAccessConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#name DataAzurermDiskAccess#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#resource_group_name DataAzurermDiskAccess#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#tags DataAzurermDiskAccess#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#timeouts DataAzurermDiskAccess#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDiskAccessTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDiskAccessTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access#read DataAzurermDiskAccess#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDiskAccessTimeoutsToTerraform(struct?: DataAzurermDiskAccessTimeoutsOutputReference | DataAzurermDiskAccessTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermDiskAccessTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDiskAccessTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDiskAccessTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access azurerm_disk_access}.
 *
 * @stability stable
 */
export declare class DataAzurermDiskAccess extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/disk_access azurerm_disk_access} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDiskAccessConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDiskAccessTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDiskAccessTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDiskAccessTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
