import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermExpressRouteCircuitConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#name DataAzurermExpressRouteCircuit#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#resource_group_name DataAzurermExpressRouteCircuit#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#timeouts DataAzurermExpressRouteCircuit#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermExpressRouteCircuitTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermExpressRouteCircuitPeerings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get azureAsn(): number;
    /**
     * @stability stable
     */
    get peerAsn(): number;
    /**
     * @stability stable
     */
    get peeringType(): string;
    /**
     * @stability stable
     */
    get primaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    get secondaryPeerAddressPrefix(): string;
    /**
     * @stability stable
     */
    get sharedKey(): string;
    /**
     * @stability stable
     */
    get vlanId(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermExpressRouteCircuitServiceProviderProperties extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get bandwidthInMbps(): number;
    /**
     * @stability stable
     */
    get peeringLocation(): string;
    /**
     * @stability stable
     */
    get serviceProviderName(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermExpressRouteCircuitSku extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get family(): string;
    /**
     * @stability stable
     */
    get tier(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermExpressRouteCircuitTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#read DataAzurermExpressRouteCircuit#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermExpressRouteCircuitTimeoutsToTerraform(struct?: DataAzurermExpressRouteCircuitTimeoutsOutputReference | DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermExpressRouteCircuitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermExpressRouteCircuitTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermExpressRouteCircuitTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit azurerm_express_route_circuit}.
 *
 * @stability stable
 */
export declare class DataAzurermExpressRouteCircuit extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit azurerm_express_route_circuit} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermExpressRouteCircuitConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    peerings(index: string): DataAzurermExpressRouteCircuitPeerings;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceKey(): string;
    /**
     * @stability stable
     */
    serviceProviderProperties(index: string): DataAzurermExpressRouteCircuitServiceProviderProperties;
    /**
     * @stability stable
     */
    get serviceProviderProvisioningState(): string;
    /**
     * @stability stable
     */
    sku(index: string): DataAzurermExpressRouteCircuitSku;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermExpressRouteCircuitTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermExpressRouteCircuitTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermExpressRouteCircuitTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
