import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetappVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#account_name DataAzurermNetappVolume#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#name DataAzurermNetappVolume#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#pool_name DataAzurermNetappVolume#pool_name}.
     *
     * @stability stable
     */
    readonly poolName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#resource_group_name DataAzurermNetappVolume#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#security_style DataAzurermNetappVolume#security_style}.
     *
     * @stability stable
     */
    readonly securityStyle?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#timeouts DataAzurermNetappVolume#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetappVolumeTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermNetappVolumeDataProtectionReplication extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endpointType(): string;
    /**
     * @stability stable
     */
    get remoteVolumeLocation(): string;
    /**
     * @stability stable
     */
    get remoteVolumeResourceId(): string;
    /**
     * @stability stable
     */
    get replicationFrequency(): string;
    /**
     * @stability stable
     */
    get replicationSchedule(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermNetappVolumeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume#read DataAzurermNetappVolume#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetappVolumeTimeoutsToTerraform(struct?: DataAzurermNetappVolumeTimeoutsOutputReference | DataAzurermNetappVolumeTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetappVolumeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetappVolumeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetappVolumeTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume azurerm_netapp_volume}.
 *
 * @stability stable
 */
export declare class DataAzurermNetappVolume extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_volume azurerm_netapp_volume} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetappVolumeConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    dataProtectionReplication(index: string): DataAzurermNetappVolumeDataProtectionReplication;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get mountIpAddresses(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _poolName?;
    /**
     * @stability stable
     */
    get poolName(): string;
    /**
     * @stability stable
     */
    set poolName(value: string);
    /**
     * @stability stable
     */
    get poolNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get protocols(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _securityStyle?;
    /**
     * @stability stable
     */
    get securityStyle(): string;
    /**
     * @stability stable
     */
    set securityStyle(value: string);
    /**
     * @stability stable
     */
    resetSecurityStyle(): void;
    /**
     * @stability stable
     */
    get securityStyleInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceLevel(): string;
    /**
     * @stability stable
     */
    get storageQuotaInGb(): number;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    get volumePath(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetappVolumeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetappVolumeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetappVolumeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
