import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#name DataAzurermRoleDefinition#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#role_definition_id DataAzurermRoleDefinition#role_definition_id}.
     *
     * @stability stable
     */
    readonly roleDefinitionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#scope DataAzurermRoleDefinition#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#timeouts DataAzurermRoleDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermRoleDefinitionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermRoleDefinitionPermissions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actions(): string[];
    /**
     * @stability stable
     */
    get dataActions(): string[];
    /**
     * @stability stable
     */
    get notActions(): string[];
    /**
     * @stability stable
     */
    get notDataActions(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermRoleDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition#read DataAzurermRoleDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermRoleDefinitionTimeoutsToTerraform(struct?: DataAzurermRoleDefinitionTimeoutsOutputReference | DataAzurermRoleDefinitionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataAzurermRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermRoleDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermRoleDefinitionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition azurerm_role_definition}.
 *
 * @stability stable
 */
export declare class DataAzurermRoleDefinition extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/role_definition azurerm_role_definition} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataAzurermRoleDefinitionConfig);
    /**
     * @stability stable
     */
    get assignableScopes(): string[];
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    permissions(index: string): DataAzurermRoleDefinitionPermissions;
    private _roleDefinitionId?;
    /**
     * @stability stable
     */
    get roleDefinitionId(): string;
    /**
     * @stability stable
     */
    set roleDefinitionId(value: string);
    /**
     * @stability stable
     */
    resetRoleDefinitionId(): void;
    /**
     * @stability stable
     */
    get roleDefinitionIdInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermRoleDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermRoleDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermRoleDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
