import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryTriggerScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#activated DataFactoryTriggerSchedule#activated}.
     *
     * @stability stable
     */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#annotations DataFactoryTriggerSchedule#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#data_factory_id DataFactoryTriggerSchedule#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#data_factory_name DataFactoryTriggerSchedule#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#description DataFactoryTriggerSchedule#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#end_time DataFactoryTriggerSchedule#end_time}.
     *
     * @stability stable
     */
    readonly endTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#frequency DataFactoryTriggerSchedule#frequency}.
     *
     * @stability stable
     */
    readonly frequency?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#interval DataFactoryTriggerSchedule#interval}.
     *
     * @stability stable
     */
    readonly interval?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#name DataFactoryTriggerSchedule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#pipeline_name DataFactoryTriggerSchedule#pipeline_name}.
     *
     * @stability stable
     */
    readonly pipelineName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#pipeline_parameters DataFactoryTriggerSchedule#pipeline_parameters}.
     *
     * @stability stable
     */
    readonly pipelineParameters?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#resource_group_name DataFactoryTriggerSchedule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#start_time DataFactoryTriggerSchedule#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#schedule DataFactoryTriggerSchedule#schedule}
     *
     * @stability stable
     */
    readonly schedule?: DataFactoryTriggerScheduleSchedule;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#timeouts DataFactoryTriggerSchedule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryTriggerScheduleTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerScheduleScheduleMonthly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#week DataFactoryTriggerSchedule#week}.
     *
     * @stability stable
     */
    readonly week?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#weekday DataFactoryTriggerSchedule#weekday}.
     *
     * @stability stable
     */
    readonly weekday: string;
}
export declare function dataFactoryTriggerScheduleScheduleMonthlyToTerraform(struct?: DataFactoryTriggerScheduleScheduleMonthly | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface DataFactoryTriggerScheduleSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#days_of_month DataFactoryTriggerSchedule#days_of_month}.
     *
     * @stability stable
     */
    readonly daysOfMonth?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#days_of_week DataFactoryTriggerSchedule#days_of_week}.
     *
     * @stability stable
     */
    readonly daysOfWeek?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#hours DataFactoryTriggerSchedule#hours}.
     *
     * @stability stable
     */
    readonly hours?: number[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#minutes DataFactoryTriggerSchedule#minutes}.
     *
     * @stability stable
     */
    readonly minutes?: number[];
    /**
     * monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#monthly DataFactoryTriggerSchedule#monthly}
     *
     * @stability stable
     */
    readonly monthly?: DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable;
}
export declare function dataFactoryTriggerScheduleScheduleToTerraform(struct?: DataFactoryTriggerScheduleScheduleOutputReference | DataFactoryTriggerScheduleSchedule): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerScheduleScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerScheduleSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerScheduleSchedule | undefined);
    private _daysOfMonth?;
    /**
     * @stability stable
     */
    get daysOfMonth(): number[];
    /**
     * @stability stable
     */
    set daysOfMonth(value: number[]);
    /**
     * @stability stable
     */
    resetDaysOfMonth(): void;
    /**
     * @stability stable
     */
    get daysOfMonthInput(): number[] | undefined;
    private _daysOfWeek?;
    /**
     * @stability stable
     */
    get daysOfWeek(): string[];
    /**
     * @stability stable
     */
    set daysOfWeek(value: string[]);
    /**
     * @stability stable
     */
    resetDaysOfWeek(): void;
    /**
     * @stability stable
     */
    get daysOfWeekInput(): string[] | undefined;
    private _hours?;
    /**
     * @stability stable
     */
    get hours(): number[];
    /**
     * @stability stable
     */
    set hours(value: number[]);
    /**
     * @stability stable
     */
    resetHours(): void;
    /**
     * @stability stable
     */
    get hoursInput(): number[] | undefined;
    private _minutes?;
    /**
     * @stability stable
     */
    get minutes(): number[];
    /**
     * @stability stable
     */
    set minutes(value: number[]);
    /**
     * @stability stable
     */
    resetMinutes(): void;
    /**
     * @stability stable
     */
    get minutesInput(): number[] | undefined;
    private _monthly?;
    /**
     * @stability stable
     */
    get monthly(): DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set monthly(value: DataFactoryTriggerScheduleScheduleMonthly[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMonthly(): void;
    /**
     * @stability stable
     */
    get monthlyInput(): cdktf.IResolvable | DataFactoryTriggerScheduleScheduleMonthly[] | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryTriggerScheduleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#create DataFactoryTriggerSchedule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#delete DataFactoryTriggerSchedule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#read DataFactoryTriggerSchedule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule#update DataFactoryTriggerSchedule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryTriggerScheduleTimeoutsToTerraform(struct?: DataFactoryTriggerScheduleTimeoutsOutputReference | DataFactoryTriggerScheduleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DataFactoryTriggerScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTriggerScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTriggerScheduleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule}.
 *
 * @stability stable
 */
export declare class DataFactoryTriggerSchedule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_trigger_schedule azurerm_data_factory_trigger_schedule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerScheduleConfig);
    private _activated?;
    /**
     * @stability stable
     */
    get activated(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set activated(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetActivated(): void;
    /**
     * @stability stable
     */
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    resetEndTime(): void;
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    resetFrequency(): void;
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _interval?;
    /**
     * @stability stable
     */
    get interval(): number;
    /**
     * @stability stable
     */
    set interval(value: number);
    /**
     * @stability stable
     */
    resetInterval(): void;
    /**
     * @stability stable
     */
    get intervalInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pipelineName?;
    /**
     * @stability stable
     */
    get pipelineName(): string;
    /**
     * @stability stable
     */
    set pipelineName(value: string);
    /**
     * @stability stable
     */
    get pipelineNameInput(): string | undefined;
    private _pipelineParameters?;
    /**
     * @stability stable
     */
    get pipelineParameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set pipelineParameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetPipelineParameters(): void;
    /**
     * @stability stable
     */
    get pipelineParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): DataFactoryTriggerScheduleScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: DataFactoryTriggerScheduleSchedule): void;
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): DataFactoryTriggerScheduleSchedule | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryTriggerScheduleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryTriggerScheduleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryTriggerScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
