import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointEventhubConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#dead_letter_storage_secret DigitalTwinsEndpointEventhub#dead_letter_storage_secret}.
     *
     * @stability stable
     */
    readonly deadLetterStorageSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#digital_twins_id DigitalTwinsEndpointEventhub#digital_twins_id}.
     *
     * @stability stable
     */
    readonly digitalTwinsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#eventhub_primary_connection_string DigitalTwinsEndpointEventhub#eventhub_primary_connection_string}.
     *
     * @stability stable
     */
    readonly eventhubPrimaryConnectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#eventhub_secondary_connection_string DigitalTwinsEndpointEventhub#eventhub_secondary_connection_string}.
     *
     * @stability stable
     */
    readonly eventhubSecondaryConnectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#name DigitalTwinsEndpointEventhub#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#timeouts DigitalTwinsEndpointEventhub#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DigitalTwinsEndpointEventhubTimeouts;
}
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointEventhubTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#create DigitalTwinsEndpointEventhub#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#delete DigitalTwinsEndpointEventhub#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#read DigitalTwinsEndpointEventhub#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub#update DigitalTwinsEndpointEventhub#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function digitalTwinsEndpointEventhubTimeoutsToTerraform(struct?: DigitalTwinsEndpointEventhubTimeoutsOutputReference | DigitalTwinsEndpointEventhubTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class DigitalTwinsEndpointEventhubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DigitalTwinsEndpointEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DigitalTwinsEndpointEventhubTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub azurerm_digital_twins_endpoint_eventhub}.
 *
 * @stability stable
 */
export declare class DigitalTwinsEndpointEventhub extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventhub azurerm_digital_twins_endpoint_eventhub} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DigitalTwinsEndpointEventhubConfig);
    private _deadLetterStorageSecret?;
    /**
     * @stability stable
     */
    get deadLetterStorageSecret(): string;
    /**
     * @stability stable
     */
    set deadLetterStorageSecret(value: string);
    /**
     * @stability stable
     */
    resetDeadLetterStorageSecret(): void;
    /**
     * @stability stable
     */
    get deadLetterStorageSecretInput(): string | undefined;
    private _digitalTwinsId?;
    /**
     * @stability stable
     */
    get digitalTwinsId(): string;
    /**
     * @stability stable
     */
    set digitalTwinsId(value: string);
    /**
     * @stability stable
     */
    get digitalTwinsIdInput(): string | undefined;
    private _eventhubPrimaryConnectionString?;
    /**
     * @stability stable
     */
    get eventhubPrimaryConnectionString(): string;
    /**
     * @stability stable
     */
    set eventhubPrimaryConnectionString(value: string);
    /**
     * @stability stable
     */
    get eventhubPrimaryConnectionStringInput(): string | undefined;
    private _eventhubSecondaryConnectionString?;
    /**
     * @stability stable
     */
    get eventhubSecondaryConnectionString(): string;
    /**
     * @stability stable
     */
    set eventhubSecondaryConnectionString(value: string);
    /**
     * @stability stable
     */
    get eventhubSecondaryConnectionStringInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DigitalTwinsEndpointEventhubTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DigitalTwinsEndpointEventhubTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DigitalTwinsEndpointEventhubTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
