import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExpressRouteConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#authorization_key ExpressRouteConnection#authorization_key}.
     *
     * @stability stable
     */
    readonly authorizationKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#enable_internet_security ExpressRouteConnection#enable_internet_security}.
     *
     * @stability stable
     */
    readonly enableInternetSecurity?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#express_route_circuit_peering_id ExpressRouteConnection#express_route_circuit_peering_id}.
     *
     * @stability stable
     */
    readonly expressRouteCircuitPeeringId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#express_route_gateway_id ExpressRouteConnection#express_route_gateway_id}.
     *
     * @stability stable
     */
    readonly expressRouteGatewayId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#name ExpressRouteConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#routing_weight ExpressRouteConnection#routing_weight}.
     *
     * @stability stable
     */
    readonly routingWeight?: number;
    /**
     * routing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#routing ExpressRouteConnection#routing}
     *
     * @stability stable
     */
    readonly routing?: ExpressRouteConnectionRouting;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#timeouts ExpressRouteConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ExpressRouteConnectionTimeouts;
}
/**
 * @stability stable
 */
export interface ExpressRouteConnectionRoutingPropagatedRouteTable {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#labels ExpressRouteConnection#labels}.
     *
     * @stability stable
     */
    readonly labels?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#route_table_ids ExpressRouteConnection#route_table_ids}.
     *
     * @stability stable
     */
    readonly routeTableIds?: string[];
}
export declare function expressRouteConnectionRoutingPropagatedRouteTableToTerraform(struct?: ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference | ExpressRouteConnectionRoutingPropagatedRouteTable): any;
/**
 * @stability stable
 */
export declare class ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteConnectionRoutingPropagatedRouteTable | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteConnectionRoutingPropagatedRouteTable | undefined);
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): string[];
    /**
     * @stability stable
     */
    set labels(value: string[]);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): string[] | undefined;
    private _routeTableIds?;
    /**
     * @stability stable
     */
    get routeTableIds(): string[];
    /**
     * @stability stable
     */
    set routeTableIds(value: string[]);
    /**
     * @stability stable
     */
    resetRouteTableIds(): void;
    /**
     * @stability stable
     */
    get routeTableIdsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteConnectionRouting {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#associated_route_table_id ExpressRouteConnection#associated_route_table_id}.
     *
     * @stability stable
     */
    readonly associatedRouteTableId?: string;
    /**
     * propagated_route_table block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#propagated_route_table ExpressRouteConnection#propagated_route_table}
     *
     * @stability stable
     */
    readonly propagatedRouteTable?: ExpressRouteConnectionRoutingPropagatedRouteTable;
}
export declare function expressRouteConnectionRoutingToTerraform(struct?: ExpressRouteConnectionRoutingOutputReference | ExpressRouteConnectionRouting): any;
/**
 * @stability stable
 */
export declare class ExpressRouteConnectionRoutingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteConnectionRouting | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteConnectionRouting | undefined);
    private _associatedRouteTableId?;
    /**
     * @stability stable
     */
    get associatedRouteTableId(): string;
    /**
     * @stability stable
     */
    set associatedRouteTableId(value: string);
    /**
     * @stability stable
     */
    resetAssociatedRouteTableId(): void;
    /**
     * @stability stable
     */
    get associatedRouteTableIdInput(): string | undefined;
    private _propagatedRouteTable;
    /**
     * @stability stable
     */
    get propagatedRouteTable(): ExpressRouteConnectionRoutingPropagatedRouteTableOutputReference;
    /**
     * @stability stable
     */
    putPropagatedRouteTable(value: ExpressRouteConnectionRoutingPropagatedRouteTable): void;
    /**
     * @stability stable
     */
    resetPropagatedRouteTable(): void;
    /**
     * @stability stable
     */
    get propagatedRouteTableInput(): ExpressRouteConnectionRoutingPropagatedRouteTable | undefined;
}
/**
 * @stability stable
 */
export interface ExpressRouteConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#create ExpressRouteConnection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#delete ExpressRouteConnection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#read ExpressRouteConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection#update ExpressRouteConnection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function expressRouteConnectionTimeoutsToTerraform(struct?: ExpressRouteConnectionTimeoutsOutputReference | ExpressRouteConnectionTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ExpressRouteConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ExpressRouteConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ExpressRouteConnectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection azurerm_express_route_connection}.
 *
 * @stability stable
 */
export declare class ExpressRouteConnection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/express_route_connection azurerm_express_route_connection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExpressRouteConnectionConfig);
    private _authorizationKey?;
    /**
     * @stability stable
     */
    get authorizationKey(): string;
    /**
     * @stability stable
     */
    set authorizationKey(value: string);
    /**
     * @stability stable
     */
    resetAuthorizationKey(): void;
    /**
     * @stability stable
     */
    get authorizationKeyInput(): string | undefined;
    private _enableInternetSecurity?;
    /**
     * @stability stable
     */
    get enableInternetSecurity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableInternetSecurity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableInternetSecurity(): void;
    /**
     * @stability stable
     */
    get enableInternetSecurityInput(): boolean | cdktf.IResolvable | undefined;
    private _expressRouteCircuitPeeringId?;
    /**
     * @stability stable
     */
    get expressRouteCircuitPeeringId(): string;
    /**
     * @stability stable
     */
    set expressRouteCircuitPeeringId(value: string);
    /**
     * @stability stable
     */
    get expressRouteCircuitPeeringIdInput(): string | undefined;
    private _expressRouteGatewayId?;
    /**
     * @stability stable
     */
    get expressRouteGatewayId(): string;
    /**
     * @stability stable
     */
    set expressRouteGatewayId(value: string);
    /**
     * @stability stable
     */
    get expressRouteGatewayIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _routingWeight?;
    /**
     * @stability stable
     */
    get routingWeight(): number;
    /**
     * @stability stable
     */
    set routingWeight(value: number);
    /**
     * @stability stable
     */
    resetRoutingWeight(): void;
    /**
     * @stability stable
     */
    get routingWeightInput(): number | undefined;
    private _routing;
    /**
     * @stability stable
     */
    get routing(): ExpressRouteConnectionRoutingOutputReference;
    /**
     * @stability stable
     */
    putRouting(value: ExpressRouteConnectionRouting): void;
    /**
     * @stability stable
     */
    resetRouting(): void;
    /**
     * @stability stable
     */
    get routingInput(): ExpressRouteConnectionRouting | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ExpressRouteConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ExpressRouteConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ExpressRouteConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
