import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#cluster_version HdinsightHadoopCluster#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#location HdinsightHadoopCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#name HdinsightHadoopCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#resource_group_name HdinsightHadoopCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tags HdinsightHadoopCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tier HdinsightHadoopCluster#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#tls_min_version HdinsightHadoopCluster#tls_min_version}.
     *
     * @stability stable
     */
    readonly tlsMinVersion?: string;
    /**
     * component_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#component_version HdinsightHadoopCluster#component_version}
     *
     * @stability stable
     */
    readonly componentVersion: HdinsightHadoopClusterComponentVersion;
    /**
     * gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#gateway HdinsightHadoopCluster#gateway}
     *
     * @stability stable
     */
    readonly gateway: HdinsightHadoopClusterGateway;
    /**
     * metastores block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#metastores HdinsightHadoopCluster#metastores}
     *
     * @stability stable
     */
    readonly metastores?: HdinsightHadoopClusterMetastores;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#monitor HdinsightHadoopCluster#monitor}
     *
     * @stability stable
     */
    readonly monitor?: HdinsightHadoopClusterMonitor;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#network HdinsightHadoopCluster#network}
     *
     * @stability stable
     */
    readonly network?: HdinsightHadoopClusterNetwork;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#roles HdinsightHadoopCluster#roles}
     *
     * @stability stable
     */
    readonly roles: HdinsightHadoopClusterRoles;
    /**
     * security_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#security_profile HdinsightHadoopCluster#security_profile}
     *
     * @stability stable
     */
    readonly securityProfile?: HdinsightHadoopClusterSecurityProfile;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account HdinsightHadoopCluster#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * storage_account_gen2 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account_gen2 HdinsightHadoopCluster#storage_account_gen2}
     *
     * @stability stable
     */
    readonly storageAccountGen2?: HdinsightHadoopClusterStorageAccountGen2;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#timeouts HdinsightHadoopCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HdinsightHadoopClusterTimeouts;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterComponentVersion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#hadoop HdinsightHadoopCluster#hadoop}.
     *
     * @stability stable
     */
    readonly hadoop: string;
}
export declare function hdinsightHadoopClusterComponentVersionToTerraform(struct?: HdinsightHadoopClusterComponentVersionOutputReference | HdinsightHadoopClusterComponentVersion): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterComponentVersion | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterComponentVersion | undefined);
    private _hadoop?;
    /**
     * @stability stable
     */
    get hadoop(): string;
    /**
     * @stability stable
     */
    set hadoop(value: string);
    /**
     * @stability stable
     */
    get hadoopInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#enabled HdinsightHadoopCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightHadoopClusterGatewayToTerraform(struct?: HdinsightHadoopClusterGatewayOutputReference | HdinsightHadoopClusterGateway): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterGatewayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterMetastoresAmbari {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresAmbariToTerraform(struct?: HdinsightHadoopClusterMetastoresAmbariOutputReference | HdinsightHadoopClusterMetastoresAmbari): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterMetastoresAmbari | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterMetastoresAmbari | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterMetastoresHive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresHiveToTerraform(struct?: HdinsightHadoopClusterMetastoresHiveOutputReference | HdinsightHadoopClusterMetastoresHive): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterMetastoresHive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterMetastoresHive | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterMetastoresOozie {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#database_name HdinsightHadoopCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#server HdinsightHadoopCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightHadoopClusterMetastoresOozieToTerraform(struct?: HdinsightHadoopClusterMetastoresOozieOutputReference | HdinsightHadoopClusterMetastoresOozie): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterMetastoresOozie | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterMetastoresOozie | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterMetastores {
    /**
     * ambari block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ambari HdinsightHadoopCluster#ambari}
     *
     * @stability stable
     */
    readonly ambari?: HdinsightHadoopClusterMetastoresAmbari;
    /**
     * hive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#hive HdinsightHadoopCluster#hive}
     *
     * @stability stable
     */
    readonly hive?: HdinsightHadoopClusterMetastoresHive;
    /**
     * oozie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#oozie HdinsightHadoopCluster#oozie}
     *
     * @stability stable
     */
    readonly oozie?: HdinsightHadoopClusterMetastoresOozie;
}
export declare function hdinsightHadoopClusterMetastoresToTerraform(struct?: HdinsightHadoopClusterMetastoresOutputReference | HdinsightHadoopClusterMetastores): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterMetastoresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterMetastores | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterMetastores | undefined);
    private _ambari;
    /**
     * @stability stable
     */
    get ambari(): HdinsightHadoopClusterMetastoresAmbariOutputReference;
    /**
     * @stability stable
     */
    putAmbari(value: HdinsightHadoopClusterMetastoresAmbari): void;
    /**
     * @stability stable
     */
    resetAmbari(): void;
    /**
     * @stability stable
     */
    get ambariInput(): HdinsightHadoopClusterMetastoresAmbari | undefined;
    private _hive;
    /**
     * @stability stable
     */
    get hive(): HdinsightHadoopClusterMetastoresHiveOutputReference;
    /**
     * @stability stable
     */
    putHive(value: HdinsightHadoopClusterMetastoresHive): void;
    /**
     * @stability stable
     */
    resetHive(): void;
    /**
     * @stability stable
     */
    get hiveInput(): HdinsightHadoopClusterMetastoresHive | undefined;
    private _oozie;
    /**
     * @stability stable
     */
    get oozie(): HdinsightHadoopClusterMetastoresOozieOutputReference;
    /**
     * @stability stable
     */
    putOozie(value: HdinsightHadoopClusterMetastoresOozie): void;
    /**
     * @stability stable
     */
    resetOozie(): void;
    /**
     * @stability stable
     */
    get oozieInput(): HdinsightHadoopClusterMetastoresOozie | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#log_analytics_workspace_id HdinsightHadoopCluster#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#primary_key HdinsightHadoopCluster#primary_key}.
     *
     * @stability stable
     */
    readonly primaryKey: string;
}
export declare function hdinsightHadoopClusterMonitorToTerraform(struct?: HdinsightHadoopClusterMonitorOutputReference | HdinsightHadoopClusterMonitor): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    set primaryKey(value: string);
    /**
     * @stability stable
     */
    get primaryKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#connection_direction HdinsightHadoopCluster#connection_direction}.
     *
     * @stability stable
     */
    readonly connectionDirection?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#private_link_enabled HdinsightHadoopCluster#private_link_enabled}.
     *
     * @stability stable
     */
    readonly privateLinkEnabled?: boolean | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterNetworkToTerraform(struct?: HdinsightHadoopClusterNetworkOutputReference | HdinsightHadoopClusterNetwork): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterNetwork | undefined);
    private _connectionDirection?;
    /**
     * @stability stable
     */
    get connectionDirection(): string;
    /**
     * @stability stable
     */
    set connectionDirection(value: string);
    /**
     * @stability stable
     */
    resetConnectionDirection(): void;
    /**
     * @stability stable
     */
    get connectionDirectionInput(): string | undefined;
    private _privateLinkEnabled?;
    /**
     * @stability stable
     */
    get privateLinkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set privateLinkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPrivateLinkEnabled(): void;
    /**
     * @stability stable
     */
    get privateLinkEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#name HdinsightHadoopCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#uri HdinsightHadoopCluster#uri}.
     *
     * @stability stable
     */
    readonly uri: string;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeInstallScriptActionToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesEdgeNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * install_script_action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#install_script_action HdinsightHadoopCluster#install_script_action}
     *
     * @stability stable
     */
    readonly installScriptAction: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterRolesEdgeNodeToTerraform(struct?: HdinsightHadoopClusterRolesEdgeNodeOutputReference | HdinsightHadoopClusterRolesEdgeNode): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesEdgeNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesEdgeNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesEdgeNode | undefined);
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _installScriptAction?;
    /**
     * @stability stable
     */
    get installScriptAction(): HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set installScriptAction(value: HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get installScriptActionInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesEdgeNodeInstallScriptAction[] | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesHeadNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightHadoopClusterRolesHeadNodeToTerraform(struct?: HdinsightHadoopClusterRolesHeadNodeOutputReference | HdinsightHadoopClusterRolesHeadNode): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesHeadNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesHeadNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#max_instance_count HdinsightHadoopCluster#max_instance_count}.
     *
     * @stability stable
     */
    readonly maxInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#min_instance_count HdinsightHadoopCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount: number;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined);
    private _maxInstanceCount?;
    /**
     * @stability stable
     */
    get maxInstanceCount(): number;
    /**
     * @stability stable
     */
    set maxInstanceCount(value: number);
    /**
     * @stability stable
     */
    get maxInstanceCountInput(): number | undefined;
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#days HdinsightHadoopCluster#days}.
     *
     * @stability stable
     */
    readonly days: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#time HdinsightHadoopCluster#time}.
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceScheduleToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#timezone HdinsightHadoopCluster#timezone}.
     *
     * @stability stable
     */
    readonly timezone: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#schedule HdinsightHadoopCluster#schedule}
     *
     * @stability stable
     */
    readonly schedule: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined);
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set schedule(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get scheduleInput(): cdktf.IResolvable | HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceSchedule[] | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesWorkerNodeAutoscale {
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#capacity HdinsightHadoopCluster#capacity}
     *
     * @stability stable
     */
    readonly capacity?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity;
    /**
     * recurrence block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#recurrence HdinsightHadoopCluster#recurrence}
     *
     * @stability stable
     */
    readonly recurrence?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeAutoscaleToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference | HdinsightHadoopClusterRolesWorkerNodeAutoscale): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined);
    private _capacity;
    /**
     * @stability stable
     */
    get capacity(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacityOutputReference;
    /**
     * @stability stable
     */
    putCapacity(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity): void;
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleCapacity | undefined;
    private _recurrence;
    /**
     * @stability stable
     */
    get recurrence(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrenceOutputReference;
    /**
     * @stability stable
     */
    putRecurrence(value: HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence): void;
    /**
     * @stability stable
     */
    resetRecurrence(): void;
    /**
     * @stability stable
     */
    get recurrenceInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleRecurrence | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesWorkerNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#min_instance_count HdinsightHadoopCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#target_instance_count HdinsightHadoopCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
    /**
     * autoscale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#autoscale HdinsightHadoopCluster#autoscale}
     *
     * @stability stable
     */
    readonly autoscale?: HdinsightHadoopClusterRolesWorkerNodeAutoscale;
}
export declare function hdinsightHadoopClusterRolesWorkerNodeToTerraform(struct?: HdinsightHadoopClusterRolesWorkerNodeOutputReference | HdinsightHadoopClusterRolesWorkerNode): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesWorkerNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetMinInstanceCount(): void;
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
    private _autoscale;
    /**
     * @stability stable
     */
    get autoscale(): HdinsightHadoopClusterRolesWorkerNodeAutoscaleOutputReference;
    /**
     * @stability stable
     */
    putAutoscale(value: HdinsightHadoopClusterRolesWorkerNodeAutoscale): void;
    /**
     * @stability stable
     */
    resetAutoscale(): void;
    /**
     * @stability stable
     */
    get autoscaleInput(): HdinsightHadoopClusterRolesWorkerNodeAutoscale | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRolesZookeeperNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#password HdinsightHadoopCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ssh_keys HdinsightHadoopCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#subnet_id HdinsightHadoopCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#username HdinsightHadoopCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#virtual_network_id HdinsightHadoopCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#vm_size HdinsightHadoopCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightHadoopClusterRolesZookeeperNodeToTerraform(struct?: HdinsightHadoopClusterRolesZookeeperNodeOutputReference | HdinsightHadoopClusterRolesZookeeperNode): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRolesZookeeperNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRolesZookeeperNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterRoles {
    /**
     * edge_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#edge_node HdinsightHadoopCluster#edge_node}
     *
     * @stability stable
     */
    readonly edgeNode?: HdinsightHadoopClusterRolesEdgeNode;
    /**
     * head_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#head_node HdinsightHadoopCluster#head_node}
     *
     * @stability stable
     */
    readonly headNode: HdinsightHadoopClusterRolesHeadNode;
    /**
     * worker_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#worker_node HdinsightHadoopCluster#worker_node}
     *
     * @stability stable
     */
    readonly workerNode: HdinsightHadoopClusterRolesWorkerNode;
    /**
     * zookeeper_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#zookeeper_node HdinsightHadoopCluster#zookeeper_node}
     *
     * @stability stable
     */
    readonly zookeeperNode: HdinsightHadoopClusterRolesZookeeperNode;
}
export declare function hdinsightHadoopClusterRolesToTerraform(struct?: HdinsightHadoopClusterRolesOutputReference | HdinsightHadoopClusterRoles): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterRoles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterRoles | undefined);
    private _edgeNode;
    /**
     * @stability stable
     */
    get edgeNode(): HdinsightHadoopClusterRolesEdgeNodeOutputReference;
    /**
     * @stability stable
     */
    putEdgeNode(value: HdinsightHadoopClusterRolesEdgeNode): void;
    /**
     * @stability stable
     */
    resetEdgeNode(): void;
    /**
     * @stability stable
     */
    get edgeNodeInput(): HdinsightHadoopClusterRolesEdgeNode | undefined;
    private _headNode;
    /**
     * @stability stable
     */
    get headNode(): HdinsightHadoopClusterRolesHeadNodeOutputReference;
    /**
     * @stability stable
     */
    putHeadNode(value: HdinsightHadoopClusterRolesHeadNode): void;
    /**
     * @stability stable
     */
    get headNodeInput(): HdinsightHadoopClusterRolesHeadNode | undefined;
    private _workerNode;
    /**
     * @stability stable
     */
    get workerNode(): HdinsightHadoopClusterRolesWorkerNodeOutputReference;
    /**
     * @stability stable
     */
    putWorkerNode(value: HdinsightHadoopClusterRolesWorkerNode): void;
    /**
     * @stability stable
     */
    get workerNodeInput(): HdinsightHadoopClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    /**
     * @stability stable
     */
    get zookeeperNode(): HdinsightHadoopClusterRolesZookeeperNodeOutputReference;
    /**
     * @stability stable
     */
    putZookeeperNode(value: HdinsightHadoopClusterRolesZookeeperNode): void;
    /**
     * @stability stable
     */
    get zookeeperNodeInput(): HdinsightHadoopClusterRolesZookeeperNode | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterSecurityProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#aadds_resource_id HdinsightHadoopCluster#aadds_resource_id}.
     *
     * @stability stable
     */
    readonly aaddsResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#cluster_users_group_dns HdinsightHadoopCluster#cluster_users_group_dns}.
     *
     * @stability stable
     */
    readonly clusterUsersGroupDns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_name HdinsightHadoopCluster#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_user_password HdinsightHadoopCluster#domain_user_password}.
     *
     * @stability stable
     */
    readonly domainUserPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#domain_username HdinsightHadoopCluster#domain_username}.
     *
     * @stability stable
     */
    readonly domainUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#ldaps_urls HdinsightHadoopCluster#ldaps_urls}.
     *
     * @stability stable
     */
    readonly ldapsUrls: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#msi_resource_id HdinsightHadoopCluster#msi_resource_id}.
     *
     * @stability stable
     */
    readonly msiResourceId: string;
}
export declare function hdinsightHadoopClusterSecurityProfileToTerraform(struct?: HdinsightHadoopClusterSecurityProfileOutputReference | HdinsightHadoopClusterSecurityProfile): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterSecurityProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    /**
     * @stability stable
     */
    get aaddsResourceId(): string;
    /**
     * @stability stable
     */
    set aaddsResourceId(value: string);
    /**
     * @stability stable
     */
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    /**
     * @stability stable
     */
    get clusterUsersGroupDns(): string[];
    /**
     * @stability stable
     */
    set clusterUsersGroupDns(value: string[]);
    /**
     * @stability stable
     */
    resetClusterUsersGroupDns(): void;
    /**
     * @stability stable
     */
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    /**
     * @stability stable
     */
    get domainUserPassword(): string;
    /**
     * @stability stable
     */
    set domainUserPassword(value: string);
    /**
     * @stability stable
     */
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    /**
     * @stability stable
     */
    get domainUsername(): string;
    /**
     * @stability stable
     */
    set domainUsername(value: string);
    /**
     * @stability stable
     */
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    /**
     * @stability stable
     */
    get ldapsUrls(): string[];
    /**
     * @stability stable
     */
    set ldapsUrls(value: string[]);
    /**
     * @stability stable
     */
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    /**
     * @stability stable
     */
    get msiResourceId(): string;
    /**
     * @stability stable
     */
    set msiResourceId(value: string);
    /**
     * @stability stable
     */
    get msiResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#is_default HdinsightHadoopCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_account_key HdinsightHadoopCluster#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_container_id HdinsightHadoopCluster#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_resource_id HdinsightHadoopCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId?: string;
}
export declare function hdinsightHadoopClusterStorageAccountToTerraform(struct?: HdinsightHadoopClusterStorageAccount | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterStorageAccountGen2 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#filesystem_id HdinsightHadoopCluster#filesystem_id}.
     *
     * @stability stable
     */
    readonly filesystemId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#is_default HdinsightHadoopCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#managed_identity_resource_id HdinsightHadoopCluster#managed_identity_resource_id}.
     *
     * @stability stable
     */
    readonly managedIdentityResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#storage_resource_id HdinsightHadoopCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId: string;
}
export declare function hdinsightHadoopClusterStorageAccountGen2ToTerraform(struct?: HdinsightHadoopClusterStorageAccountGen2OutputReference | HdinsightHadoopClusterStorageAccountGen2): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterStorageAccountGen2 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    /**
     * @stability stable
     */
    get filesystemId(): string;
    /**
     * @stability stable
     */
    set filesystemId(value: string);
    /**
     * @stability stable
     */
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    /**
     * @stability stable
     */
    get isDefault(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isDefault(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    /**
     * @stability stable
     */
    get managedIdentityResourceId(): string;
    /**
     * @stability stable
     */
    set managedIdentityResourceId(value: string);
    /**
     * @stability stable
     */
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    /**
     * @stability stable
     */
    get storageResourceId(): string;
    /**
     * @stability stable
     */
    set storageResourceId(value: string);
    /**
     * @stability stable
     */
    get storageResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightHadoopClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#create HdinsightHadoopCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#delete HdinsightHadoopCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#read HdinsightHadoopCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster#update HdinsightHadoopCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hdinsightHadoopClusterTimeoutsToTerraform(struct?: HdinsightHadoopClusterTimeoutsOutputReference | HdinsightHadoopClusterTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class HdinsightHadoopClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightHadoopClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightHadoopClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster azurerm_hdinsight_hadoop_cluster}.
 *
 * @stability stable
 */
export declare class HdinsightHadoopCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_hadoop_cluster azurerm_hdinsight_hadoop_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HdinsightHadoopClusterConfig);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get httpsEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sshEndpoint(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    /**
     * @stability stable
     */
    get tlsMinVersion(): string;
    /**
     * @stability stable
     */
    set tlsMinVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsMinVersion(): void;
    /**
     * @stability stable
     */
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    /**
     * @stability stable
     */
    get componentVersion(): HdinsightHadoopClusterComponentVersionOutputReference;
    /**
     * @stability stable
     */
    putComponentVersion(value: HdinsightHadoopClusterComponentVersion): void;
    /**
     * @stability stable
     */
    get componentVersionInput(): HdinsightHadoopClusterComponentVersion | undefined;
    private _gateway;
    /**
     * @stability stable
     */
    get gateway(): HdinsightHadoopClusterGatewayOutputReference;
    /**
     * @stability stable
     */
    putGateway(value: HdinsightHadoopClusterGateway): void;
    /**
     * @stability stable
     */
    get gatewayInput(): HdinsightHadoopClusterGateway | undefined;
    private _metastores;
    /**
     * @stability stable
     */
    get metastores(): HdinsightHadoopClusterMetastoresOutputReference;
    /**
     * @stability stable
     */
    putMetastores(value: HdinsightHadoopClusterMetastores): void;
    /**
     * @stability stable
     */
    resetMetastores(): void;
    /**
     * @stability stable
     */
    get metastoresInput(): HdinsightHadoopClusterMetastores | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): HdinsightHadoopClusterMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: HdinsightHadoopClusterMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): HdinsightHadoopClusterMonitor | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): HdinsightHadoopClusterNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: HdinsightHadoopClusterNetwork): void;
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): HdinsightHadoopClusterNetwork | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): HdinsightHadoopClusterRolesOutputReference;
    /**
     * @stability stable
     */
    putRoles(value: HdinsightHadoopClusterRoles): void;
    /**
     * @stability stable
     */
    get rolesInput(): HdinsightHadoopClusterRoles | undefined;
    private _securityProfile;
    /**
     * @stability stable
     */
    get securityProfile(): HdinsightHadoopClusterSecurityProfileOutputReference;
    /**
     * @stability stable
     */
    putSecurityProfile(value: HdinsightHadoopClusterSecurityProfile): void;
    /**
     * @stability stable
     */
    resetSecurityProfile(): void;
    /**
     * @stability stable
     */
    get securityProfileInput(): HdinsightHadoopClusterSecurityProfile | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set storageAccount(value: HdinsightHadoopClusterStorageAccount[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): cdktf.IResolvable | HdinsightHadoopClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    /**
     * @stability stable
     */
    get storageAccountGen2(): HdinsightHadoopClusterStorageAccountGen2OutputReference;
    /**
     * @stability stable
     */
    putStorageAccountGen2(value: HdinsightHadoopClusterStorageAccountGen2): void;
    /**
     * @stability stable
     */
    resetStorageAccountGen2(): void;
    /**
     * @stability stable
     */
    get storageAccountGen2Input(): HdinsightHadoopClusterStorageAccountGen2 | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HdinsightHadoopClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HdinsightHadoopClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HdinsightHadoopClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
