import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#auto_pause_delay_in_minutes MssqlDatabase#auto_pause_delay_in_minutes}.
     *
     * @stability stable
     */
    readonly autoPauseDelayInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#collation MssqlDatabase#collation}.
     *
     * @stability stable
     */
    readonly collation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#create_mode MssqlDatabase#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#creation_source_database_id MssqlDatabase#creation_source_database_id}.
     *
     * @stability stable
     */
    readonly creationSourceDatabaseId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#elastic_pool_id MssqlDatabase#elastic_pool_id}.
     *
     * @stability stable
     */
    readonly elasticPoolId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#extended_auditing_policy MssqlDatabase#extended_auditing_policy}.
     *
     * @stability stable
     */
    readonly extendedAuditingPolicy?: MssqlDatabaseExtendedAuditingPolicy[] | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#geo_backup_enabled MssqlDatabase#geo_backup_enabled}.
     *
     * @stability stable
     */
    readonly geoBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#license_type MssqlDatabase#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#max_size_gb MssqlDatabase#max_size_gb}.
     *
     * @stability stable
     */
    readonly maxSizeGb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#min_capacity MssqlDatabase#min_capacity}.
     *
     * @stability stable
     */
    readonly minCapacity?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#name MssqlDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#read_replica_count MssqlDatabase#read_replica_count}.
     *
     * @stability stable
     */
    readonly readReplicaCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#read_scale MssqlDatabase#read_scale}.
     *
     * @stability stable
     */
    readonly readScale?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#recover_database_id MssqlDatabase#recover_database_id}.
     *
     * @stability stable
     */
    readonly recoverDatabaseId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#restore_dropped_database_id MssqlDatabase#restore_dropped_database_id}.
     *
     * @stability stable
     */
    readonly restoreDroppedDatabaseId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#restore_point_in_time MssqlDatabase#restore_point_in_time}.
     *
     * @stability stable
     */
    readonly restorePointInTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#sample_name MssqlDatabase#sample_name}.
     *
     * @stability stable
     */
    readonly sampleName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#server_id MssqlDatabase#server_id}.
     *
     * @stability stable
     */
    readonly serverId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#sku_name MssqlDatabase#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_account_type MssqlDatabase#storage_account_type}.
     *
     * @stability stable
     */
    readonly storageAccountType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#tags MssqlDatabase#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#zone_redundant MssqlDatabase#zone_redundant}.
     *
     * @stability stable
     */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
     * long_term_retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#long_term_retention_policy MssqlDatabase#long_term_retention_policy}
     *
     * @stability stable
     */
    readonly longTermRetentionPolicy?: MssqlDatabaseLongTermRetentionPolicy;
    /**
     * short_term_retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#short_term_retention_policy MssqlDatabase#short_term_retention_policy}
     *
     * @stability stable
     */
    readonly shortTermRetentionPolicy?: MssqlDatabaseShortTermRetentionPolicy;
    /**
     * threat_detection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#threat_detection_policy MssqlDatabase#threat_detection_policy}
     *
     * @stability stable
     */
    readonly threatDetectionPolicy?: MssqlDatabaseThreatDetectionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#timeouts MssqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlDatabaseExtendedAuditingPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#log_monitoring_enabled MssqlDatabase#log_monitoring_enabled}.
     *
     * @stability stable
     */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#retention_in_days MssqlDatabase#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_account_access_key MssqlDatabase#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_account_access_key_is_secondary MssqlDatabase#storage_account_access_key_is_secondary}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_account_subscription_id MssqlDatabase#storage_account_subscription_id}.
     *
     * @stability stable
     */
    readonly storageAccountSubscriptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_endpoint MssqlDatabase#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
}
export declare function mssqlDatabaseExtendedAuditingPolicyToTerraform(struct?: MssqlDatabaseExtendedAuditingPolicy | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface MssqlDatabaseLongTermRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#monthly_retention MssqlDatabase#monthly_retention}.
     *
     * @stability stable
     */
    readonly monthlyRetention?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#week_of_year MssqlDatabase#week_of_year}.
     *
     * @stability stable
     */
    readonly weekOfYear?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#weekly_retention MssqlDatabase#weekly_retention}.
     *
     * @stability stable
     */
    readonly weeklyRetention?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#yearly_retention MssqlDatabase#yearly_retention}.
     *
     * @stability stable
     */
    readonly yearlyRetention?: string;
}
export declare function mssqlDatabaseLongTermRetentionPolicyToTerraform(struct?: MssqlDatabaseLongTermRetentionPolicyOutputReference | MssqlDatabaseLongTermRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MssqlDatabaseLongTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlDatabaseLongTermRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlDatabaseLongTermRetentionPolicy | undefined);
    private _monthlyRetention?;
    /**
     * @stability stable
     */
    get monthlyRetention(): string;
    /**
     * @stability stable
     */
    set monthlyRetention(value: string);
    /**
     * @stability stable
     */
    resetMonthlyRetention(): void;
    /**
     * @stability stable
     */
    get monthlyRetentionInput(): string | undefined;
    private _weekOfYear?;
    /**
     * @stability stable
     */
    get weekOfYear(): number;
    /**
     * @stability stable
     */
    set weekOfYear(value: number);
    /**
     * @stability stable
     */
    resetWeekOfYear(): void;
    /**
     * @stability stable
     */
    get weekOfYearInput(): number | undefined;
    private _weeklyRetention?;
    /**
     * @stability stable
     */
    get weeklyRetention(): string;
    /**
     * @stability stable
     */
    set weeklyRetention(value: string);
    /**
     * @stability stable
     */
    resetWeeklyRetention(): void;
    /**
     * @stability stable
     */
    get weeklyRetentionInput(): string | undefined;
    private _yearlyRetention?;
    /**
     * @stability stable
     */
    get yearlyRetention(): string;
    /**
     * @stability stable
     */
    set yearlyRetention(value: string);
    /**
     * @stability stable
     */
    resetYearlyRetention(): void;
    /**
     * @stability stable
     */
    get yearlyRetentionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlDatabaseShortTermRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#retention_days MssqlDatabase#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays: number;
}
export declare function mssqlDatabaseShortTermRetentionPolicyToTerraform(struct?: MssqlDatabaseShortTermRetentionPolicyOutputReference | MssqlDatabaseShortTermRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class MssqlDatabaseShortTermRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlDatabaseShortTermRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlDatabaseShortTermRetentionPolicy | undefined);
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MssqlDatabaseThreatDetectionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#disabled_alerts MssqlDatabase#disabled_alerts}.
     *
     * @stability stable
     */
    readonly disabledAlerts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#email_account_admins MssqlDatabase#email_account_admins}.
     *
     * @stability stable
     */
    readonly emailAccountAdmins?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#email_addresses MssqlDatabase#email_addresses}.
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#retention_days MssqlDatabase#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#state MssqlDatabase#state}.
     *
     * @stability stable
     */
    readonly state?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_account_access_key MssqlDatabase#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#storage_endpoint MssqlDatabase#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#use_server_default MssqlDatabase#use_server_default}.
     *
     * @stability stable
     */
    readonly useServerDefault?: string;
}
export declare function mssqlDatabaseThreatDetectionPolicyToTerraform(struct?: MssqlDatabaseThreatDetectionPolicyOutputReference | MssqlDatabaseThreatDetectionPolicy): any;
/**
 * @stability stable
 */
export declare class MssqlDatabaseThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlDatabaseThreatDetectionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlDatabaseThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    set disabledAlerts(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledAlerts(): void;
    /**
     * @stability stable
     */
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    /**
     * @stability stable
     */
    get emailAccountAdmins(): string;
    /**
     * @stability stable
     */
    set emailAccountAdmins(value: string);
    /**
     * @stability stable
     */
    resetEmailAccountAdmins(): void;
    /**
     * @stability stable
     */
    get emailAccountAdminsInput(): string | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    resetState(): void;
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
    private _useServerDefault?;
    /**
     * @stability stable
     */
    get useServerDefault(): string;
    /**
     * @stability stable
     */
    set useServerDefault(value: string);
    /**
     * @stability stable
     */
    resetUseServerDefault(): void;
    /**
     * @stability stable
     */
    get useServerDefaultInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#create MssqlDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#delete MssqlDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#read MssqlDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database#update MssqlDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlDatabaseTimeoutsToTerraform(struct?: MssqlDatabaseTimeoutsOutputReference | MssqlDatabaseTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MssqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database azurerm_mssql_database}.
 *
 * @stability stable
 */
export declare class MssqlDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database azurerm_mssql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlDatabaseConfig);
    private _autoPauseDelayInMinutes?;
    /**
     * @stability stable
     */
    get autoPauseDelayInMinutes(): number;
    /**
     * @stability stable
     */
    set autoPauseDelayInMinutes(value: number);
    /**
     * @stability stable
     */
    resetAutoPauseDelayInMinutes(): void;
    /**
     * @stability stable
     */
    get autoPauseDelayInMinutesInput(): number | undefined;
    private _collation?;
    /**
     * @stability stable
     */
    get collation(): string;
    /**
     * @stability stable
     */
    set collation(value: string);
    /**
     * @stability stable
     */
    resetCollation(): void;
    /**
     * @stability stable
     */
    get collationInput(): string | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _creationSourceDatabaseId?;
    /**
     * @stability stable
     */
    get creationSourceDatabaseId(): string;
    /**
     * @stability stable
     */
    set creationSourceDatabaseId(value: string);
    /**
     * @stability stable
     */
    resetCreationSourceDatabaseId(): void;
    /**
     * @stability stable
     */
    get creationSourceDatabaseIdInput(): string | undefined;
    private _elasticPoolId?;
    /**
     * @stability stable
     */
    get elasticPoolId(): string;
    /**
     * @stability stable
     */
    set elasticPoolId(value: string);
    /**
     * @stability stable
     */
    resetElasticPoolId(): void;
    /**
     * @stability stable
     */
    get elasticPoolIdInput(): string | undefined;
    private _extendedAuditingPolicy?;
    /**
     * @stability stable
     */
    get extendedAuditingPolicy(): MssqlDatabaseExtendedAuditingPolicy[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set extendedAuditingPolicy(value: MssqlDatabaseExtendedAuditingPolicy[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExtendedAuditingPolicy(): void;
    /**
     * @stability stable
     */
    get extendedAuditingPolicyInput(): cdktf.IResolvable | MssqlDatabaseExtendedAuditingPolicy[] | undefined;
    private _geoBackupEnabled?;
    /**
     * @stability stable
     */
    get geoBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set geoBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGeoBackupEnabled(): void;
    /**
     * @stability stable
     */
    get geoBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _maxSizeGb?;
    /**
     * @stability stable
     */
    get maxSizeGb(): number;
    /**
     * @stability stable
     */
    set maxSizeGb(value: number);
    /**
     * @stability stable
     */
    resetMaxSizeGb(): void;
    /**
     * @stability stable
     */
    get maxSizeGbInput(): number | undefined;
    private _minCapacity?;
    /**
     * @stability stable
     */
    get minCapacity(): number;
    /**
     * @stability stable
     */
    set minCapacity(value: number);
    /**
     * @stability stable
     */
    resetMinCapacity(): void;
    /**
     * @stability stable
     */
    get minCapacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _readReplicaCount?;
    /**
     * @stability stable
     */
    get readReplicaCount(): number;
    /**
     * @stability stable
     */
    set readReplicaCount(value: number);
    /**
     * @stability stable
     */
    resetReadReplicaCount(): void;
    /**
     * @stability stable
     */
    get readReplicaCountInput(): number | undefined;
    private _readScale?;
    /**
     * @stability stable
     */
    get readScale(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set readScale(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetReadScale(): void;
    /**
     * @stability stable
     */
    get readScaleInput(): boolean | cdktf.IResolvable | undefined;
    private _recoverDatabaseId?;
    /**
     * @stability stable
     */
    get recoverDatabaseId(): string;
    /**
     * @stability stable
     */
    set recoverDatabaseId(value: string);
    /**
     * @stability stable
     */
    resetRecoverDatabaseId(): void;
    /**
     * @stability stable
     */
    get recoverDatabaseIdInput(): string | undefined;
    private _restoreDroppedDatabaseId?;
    /**
     * @stability stable
     */
    get restoreDroppedDatabaseId(): string;
    /**
     * @stability stable
     */
    set restoreDroppedDatabaseId(value: string);
    /**
     * @stability stable
     */
    resetRestoreDroppedDatabaseId(): void;
    /**
     * @stability stable
     */
    get restoreDroppedDatabaseIdInput(): string | undefined;
    private _restorePointInTime?;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    set restorePointInTime(value: string);
    /**
     * @stability stable
     */
    resetRestorePointInTime(): void;
    /**
     * @stability stable
     */
    get restorePointInTimeInput(): string | undefined;
    private _sampleName?;
    /**
     * @stability stable
     */
    get sampleName(): string;
    /**
     * @stability stable
     */
    set sampleName(value: string);
    /**
     * @stability stable
     */
    resetSampleName(): void;
    /**
     * @stability stable
     */
    get sampleNameInput(): string | undefined;
    private _serverId?;
    /**
     * @stability stable
     */
    get serverId(): string;
    /**
     * @stability stable
     */
    set serverId(value: string);
    /**
     * @stability stable
     */
    get serverIdInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _storageAccountType?;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
    /**
     * @stability stable
     */
    set storageAccountType(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountType(): void;
    /**
     * @stability stable
     */
    get storageAccountTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    /**
     * @stability stable
     */
    get zoneRedundant(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundant(): void;
    /**
     * @stability stable
     */
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _longTermRetentionPolicy;
    /**
     * @stability stable
     */
    get longTermRetentionPolicy(): MssqlDatabaseLongTermRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putLongTermRetentionPolicy(value: MssqlDatabaseLongTermRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetLongTermRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get longTermRetentionPolicyInput(): MssqlDatabaseLongTermRetentionPolicy | undefined;
    private _shortTermRetentionPolicy;
    /**
     * @stability stable
     */
    get shortTermRetentionPolicy(): MssqlDatabaseShortTermRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putShortTermRetentionPolicy(value: MssqlDatabaseShortTermRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetShortTermRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get shortTermRetentionPolicyInput(): MssqlDatabaseShortTermRetentionPolicy | undefined;
    private _threatDetectionPolicy;
    /**
     * @stability stable
     */
    get threatDetectionPolicy(): MssqlDatabaseThreatDetectionPolicyOutputReference;
    /**
     * @stability stable
     */
    putThreatDetectionPolicy(value: MssqlDatabaseThreatDetectionPolicy): void;
    /**
     * @stability stable
     */
    resetThreatDetectionPolicy(): void;
    /**
     * @stability stable
     */
    get threatDetectionPolicyInput(): MssqlDatabaseThreatDetectionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
