import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#administrator_login MysqlFlexibleServer#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#administrator_password MysqlFlexibleServer#administrator_password}.
     *
     * @stability stable
     */
    readonly administratorPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#backup_retention_days MysqlFlexibleServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#create_mode MysqlFlexibleServer#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#delegated_subnet_id MysqlFlexibleServer#delegated_subnet_id}.
     *
     * @stability stable
     */
    readonly delegatedSubnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#geo_redundant_backup_enabled MysqlFlexibleServer#geo_redundant_backup_enabled}.
     *
     * @stability stable
     */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#location MysqlFlexibleServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#name MysqlFlexibleServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#point_in_time_restore_time_in_utc MysqlFlexibleServer#point_in_time_restore_time_in_utc}.
     *
     * @stability stable
     */
    readonly pointInTimeRestoreTimeInUtc?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#private_dns_zone_id MysqlFlexibleServer#private_dns_zone_id}.
     *
     * @stability stable
     */
    readonly privateDnsZoneId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#replication_role MysqlFlexibleServer#replication_role}.
     *
     * @stability stable
     */
    readonly replicationRole?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#resource_group_name MysqlFlexibleServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#sku_name MysqlFlexibleServer#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#source_server_id MysqlFlexibleServer#source_server_id}.
     *
     * @stability stable
     */
    readonly sourceServerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#tags MysqlFlexibleServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#version MysqlFlexibleServer#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#zone MysqlFlexibleServer#zone}.
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * high_availability block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#high_availability MysqlFlexibleServer#high_availability}
     *
     * @stability stable
     */
    readonly highAvailability?: MysqlFlexibleServerHighAvailability;
    /**
     * maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#maintenance_window MysqlFlexibleServer#maintenance_window}
     *
     * @stability stable
     */
    readonly maintenanceWindow?: MysqlFlexibleServerMaintenanceWindow;
    /**
     * storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#storage MysqlFlexibleServer#storage}
     *
     * @stability stable
     */
    readonly storage?: MysqlFlexibleServerStorage;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#timeouts MysqlFlexibleServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MysqlFlexibleServerTimeouts;
}
/**
 * @stability stable
 */
export interface MysqlFlexibleServerHighAvailability {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#mode MysqlFlexibleServer#mode}.
     *
     * @stability stable
     */
    readonly mode: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#standby_availability_zone MysqlFlexibleServer#standby_availability_zone}.
     *
     * @stability stable
     */
    readonly standbyAvailabilityZone?: string;
}
export declare function mysqlFlexibleServerHighAvailabilityToTerraform(struct?: MysqlFlexibleServerHighAvailabilityOutputReference | MysqlFlexibleServerHighAvailability): any;
/**
 * @stability stable
 */
export declare class MysqlFlexibleServerHighAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlFlexibleServerHighAvailability | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlFlexibleServerHighAvailability | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _standbyAvailabilityZone?;
    /**
     * @stability stable
     */
    get standbyAvailabilityZone(): string;
    /**
     * @stability stable
     */
    set standbyAvailabilityZone(value: string);
    /**
     * @stability stable
     */
    resetStandbyAvailabilityZone(): void;
    /**
     * @stability stable
     */
    get standbyAvailabilityZoneInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MysqlFlexibleServerMaintenanceWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#day_of_week MysqlFlexibleServer#day_of_week}.
     *
     * @stability stable
     */
    readonly dayOfWeek?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#start_hour MysqlFlexibleServer#start_hour}.
     *
     * @stability stable
     */
    readonly startHour?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#start_minute MysqlFlexibleServer#start_minute}.
     *
     * @stability stable
     */
    readonly startMinute?: number;
}
export declare function mysqlFlexibleServerMaintenanceWindowToTerraform(struct?: MysqlFlexibleServerMaintenanceWindowOutputReference | MysqlFlexibleServerMaintenanceWindow): any;
/**
 * @stability stable
 */
export declare class MysqlFlexibleServerMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlFlexibleServerMaintenanceWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlFlexibleServerMaintenanceWindow | undefined);
    private _dayOfWeek?;
    /**
     * @stability stable
     */
    get dayOfWeek(): number;
    /**
     * @stability stable
     */
    set dayOfWeek(value: number);
    /**
     * @stability stable
     */
    resetDayOfWeek(): void;
    /**
     * @stability stable
     */
    get dayOfWeekInput(): number | undefined;
    private _startHour?;
    /**
     * @stability stable
     */
    get startHour(): number;
    /**
     * @stability stable
     */
    set startHour(value: number);
    /**
     * @stability stable
     */
    resetStartHour(): void;
    /**
     * @stability stable
     */
    get startHourInput(): number | undefined;
    private _startMinute?;
    /**
     * @stability stable
     */
    get startMinute(): number;
    /**
     * @stability stable
     */
    set startMinute(value: number);
    /**
     * @stability stable
     */
    resetStartMinute(): void;
    /**
     * @stability stable
     */
    get startMinuteInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MysqlFlexibleServerStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#auto_grow_enabled MysqlFlexibleServer#auto_grow_enabled}.
     *
     * @stability stable
     */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#iops MysqlFlexibleServer#iops}.
     *
     * @stability stable
     */
    readonly iops?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#size_gb MysqlFlexibleServer#size_gb}.
     *
     * @stability stable
     */
    readonly sizeGb?: number;
}
export declare function mysqlFlexibleServerStorageToTerraform(struct?: MysqlFlexibleServerStorageOutputReference | MysqlFlexibleServerStorage): any;
/**
 * @stability stable
 */
export declare class MysqlFlexibleServerStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlFlexibleServerStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlFlexibleServerStorage | undefined);
    private _autoGrowEnabled?;
    /**
     * @stability stable
     */
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoGrowEnabled(): void;
    /**
     * @stability stable
     */
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _iops?;
    /**
     * @stability stable
     */
    get iops(): number;
    /**
     * @stability stable
     */
    set iops(value: number);
    /**
     * @stability stable
     */
    resetIops(): void;
    /**
     * @stability stable
     */
    get iopsInput(): number | undefined;
    private _sizeGb?;
    /**
     * @stability stable
     */
    get sizeGb(): number;
    /**
     * @stability stable
     */
    set sizeGb(value: number);
    /**
     * @stability stable
     */
    resetSizeGb(): void;
    /**
     * @stability stable
     */
    get sizeGbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MysqlFlexibleServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#create MysqlFlexibleServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#delete MysqlFlexibleServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#read MysqlFlexibleServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server#update MysqlFlexibleServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mysqlFlexibleServerTimeoutsToTerraform(struct?: MysqlFlexibleServerTimeoutsOutputReference | MysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class MysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlFlexibleServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server azurerm_mysql_flexible_server}.
 *
 * @stability stable
 */
export declare class MysqlFlexibleServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_flexible_server azurerm_mysql_flexible_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MysqlFlexibleServerConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    /**
     * @stability stable
     */
    get administratorPassword(): string;
    /**
     * @stability stable
     */
    set administratorPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorPassword(): void;
    /**
     * @stability stable
     */
    get administratorPasswordInput(): string | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _delegatedSubnetId?;
    /**
     * @stability stable
     */
    get delegatedSubnetId(): string;
    /**
     * @stability stable
     */
    set delegatedSubnetId(value: string);
    /**
     * @stability stable
     */
    resetDelegatedSubnetId(): void;
    /**
     * @stability stable
     */
    get delegatedSubnetIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGeoRedundantBackupEnabled(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _pointInTimeRestoreTimeInUtc?;
    /**
     * @stability stable
     */
    get pointInTimeRestoreTimeInUtc(): string;
    /**
     * @stability stable
     */
    set pointInTimeRestoreTimeInUtc(value: string);
    /**
     * @stability stable
     */
    resetPointInTimeRestoreTimeInUtc(): void;
    /**
     * @stability stable
     */
    get pointInTimeRestoreTimeInUtcInput(): string | undefined;
    private _privateDnsZoneId?;
    /**
     * @stability stable
     */
    get privateDnsZoneId(): string;
    /**
     * @stability stable
     */
    set privateDnsZoneId(value: string);
    /**
     * @stability stable
     */
    resetPrivateDnsZoneId(): void;
    /**
     * @stability stable
     */
    get privateDnsZoneIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get replicaCapacity(): number;
    private _replicationRole?;
    /**
     * @stability stable
     */
    get replicationRole(): string;
    /**
     * @stability stable
     */
    set replicationRole(value: string);
    /**
     * @stability stable
     */
    resetReplicationRole(): void;
    /**
     * @stability stable
     */
    get replicationRoleInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _sourceServerId?;
    /**
     * @stability stable
     */
    get sourceServerId(): string;
    /**
     * @stability stable
     */
    set sourceServerId(value: string);
    /**
     * @stability stable
     */
    resetSourceServerId(): void;
    /**
     * @stability stable
     */
    get sourceServerIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _highAvailability;
    /**
     * @stability stable
     */
    get highAvailability(): MysqlFlexibleServerHighAvailabilityOutputReference;
    /**
     * @stability stable
     */
    putHighAvailability(value: MysqlFlexibleServerHighAvailability): void;
    /**
     * @stability stable
     */
    resetHighAvailability(): void;
    /**
     * @stability stable
     */
    get highAvailabilityInput(): MysqlFlexibleServerHighAvailability | undefined;
    private _maintenanceWindow;
    /**
     * @stability stable
     */
    get maintenanceWindow(): MysqlFlexibleServerMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putMaintenanceWindow(value: MysqlFlexibleServerMaintenanceWindow): void;
    /**
     * @stability stable
     */
    resetMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get maintenanceWindowInput(): MysqlFlexibleServerMaintenanceWindow | undefined;
    private _storage;
    /**
     * @stability stable
     */
    get storage(): MysqlFlexibleServerStorageOutputReference;
    /**
     * @stability stable
     */
    putStorage(value: MysqlFlexibleServerStorage): void;
    /**
     * @stability stable
     */
    resetStorage(): void;
    /**
     * @stability stable
     */
    get storageInput(): MysqlFlexibleServerStorage | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MysqlFlexibleServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MysqlFlexibleServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MysqlFlexibleServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
