import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SecurityCenterContactConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#alert_notifications SecurityCenterContact#alert_notifications}.
     *
     * @stability stable
     */
    readonly alertNotifications: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#alerts_to_admins SecurityCenterContact#alerts_to_admins}.
     *
     * @stability stable
     */
    readonly alertsToAdmins: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#email SecurityCenterContact#email}.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#phone SecurityCenterContact#phone}.
     *
     * @stability stable
     */
    readonly phone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#timeouts SecurityCenterContact#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SecurityCenterContactTimeouts;
}
/**
 * @stability stable
 */
export interface SecurityCenterContactTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#create SecurityCenterContact#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#delete SecurityCenterContact#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#read SecurityCenterContact#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact#update SecurityCenterContact#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function securityCenterContactTimeoutsToTerraform(struct?: SecurityCenterContactTimeoutsOutputReference | SecurityCenterContactTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SecurityCenterContactTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SecurityCenterContactTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SecurityCenterContactTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact azurerm_security_center_contact}.
 *
 * @stability stable
 */
export declare class SecurityCenterContact extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/security_center_contact azurerm_security_center_contact} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SecurityCenterContactConfig);
    private _alertNotifications?;
    /**
     * @stability stable
     */
    get alertNotifications(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alertNotifications(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get alertNotificationsInput(): boolean | cdktf.IResolvable | undefined;
    private _alertsToAdmins?;
    /**
     * @stability stable
     */
    get alertsToAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alertsToAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get alertsToAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _phone?;
    /**
     * @stability stable
     */
    get phone(): string;
    /**
     * @stability stable
     */
    set phone(value: string);
    /**
     * @stability stable
     */
    resetPhone(): void;
    /**
     * @stability stable
     */
    get phoneInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SecurityCenterContactTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SecurityCenterContactTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SecurityCenterContactTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
