import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServicebusSubscriptionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#action ServicebusSubscriptionRule#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#filter_type ServicebusSubscriptionRule#filter_type}.
     *
     * @stability stable
     */
    readonly filterType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#name ServicebusSubscriptionRule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#namespace_name ServicebusSubscriptionRule#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#resource_group_name ServicebusSubscriptionRule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#sql_filter ServicebusSubscriptionRule#sql_filter}.
     *
     * @stability stable
     */
    readonly sqlFilter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#subscription_id ServicebusSubscriptionRule#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#subscription_name ServicebusSubscriptionRule#subscription_name}.
     *
     * @stability stable
     */
    readonly subscriptionName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#topic_name ServicebusSubscriptionRule#topic_name}.
     *
     * @stability stable
     */
    readonly topicName?: string;
    /**
     * correlation_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#correlation_filter ServicebusSubscriptionRule#correlation_filter}
     *
     * @stability stable
     */
    readonly correlationFilter?: ServicebusSubscriptionRuleCorrelationFilter;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#timeouts ServicebusSubscriptionRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ServicebusSubscriptionRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ServicebusSubscriptionRuleCorrelationFilter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#content_type ServicebusSubscriptionRule#content_type}.
     *
     * @stability stable
     */
    readonly contentType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#correlation_id ServicebusSubscriptionRule#correlation_id}.
     *
     * @stability stable
     */
    readonly correlationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#label ServicebusSubscriptionRule#label}.
     *
     * @stability stable
     */
    readonly label?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#message_id ServicebusSubscriptionRule#message_id}.
     *
     * @stability stable
     */
    readonly messageId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#properties ServicebusSubscriptionRule#properties}.
     *
     * @stability stable
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#reply_to ServicebusSubscriptionRule#reply_to}.
     *
     * @stability stable
     */
    readonly replyTo?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#reply_to_session_id ServicebusSubscriptionRule#reply_to_session_id}.
     *
     * @stability stable
     */
    readonly replyToSessionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#session_id ServicebusSubscriptionRule#session_id}.
     *
     * @stability stable
     */
    readonly sessionId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#to ServicebusSubscriptionRule#to}.
     *
     * @stability stable
     */
    readonly to?: string;
}
export declare function servicebusSubscriptionRuleCorrelationFilterToTerraform(struct?: ServicebusSubscriptionRuleCorrelationFilterOutputReference | ServicebusSubscriptionRuleCorrelationFilter): any;
/**
 * @stability stable
 */
export declare class ServicebusSubscriptionRuleCorrelationFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusSubscriptionRuleCorrelationFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusSubscriptionRuleCorrelationFilter | undefined);
    private _contentType?;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    set contentType(value: string);
    /**
     * @stability stable
     */
    resetContentType(): void;
    /**
     * @stability stable
     */
    get contentTypeInput(): string | undefined;
    private _correlationId?;
    /**
     * @stability stable
     */
    get correlationId(): string;
    /**
     * @stability stable
     */
    set correlationId(value: string);
    /**
     * @stability stable
     */
    resetCorrelationId(): void;
    /**
     * @stability stable
     */
    get correlationIdInput(): string | undefined;
    private _label?;
    /**
     * @stability stable
     */
    get label(): string;
    /**
     * @stability stable
     */
    set label(value: string);
    /**
     * @stability stable
     */
    resetLabel(): void;
    /**
     * @stability stable
     */
    get labelInput(): string | undefined;
    private _messageId?;
    /**
     * @stability stable
     */
    get messageId(): string;
    /**
     * @stability stable
     */
    set messageId(value: string);
    /**
     * @stability stable
     */
    resetMessageId(): void;
    /**
     * @stability stable
     */
    get messageIdInput(): string | undefined;
    private _properties?;
    /**
     * @stability stable
     */
    get properties(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set properties(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetProperties(): void;
    /**
     * @stability stable
     */
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _replyTo?;
    /**
     * @stability stable
     */
    get replyTo(): string;
    /**
     * @stability stable
     */
    set replyTo(value: string);
    /**
     * @stability stable
     */
    resetReplyTo(): void;
    /**
     * @stability stable
     */
    get replyToInput(): string | undefined;
    private _replyToSessionId?;
    /**
     * @stability stable
     */
    get replyToSessionId(): string;
    /**
     * @stability stable
     */
    set replyToSessionId(value: string);
    /**
     * @stability stable
     */
    resetReplyToSessionId(): void;
    /**
     * @stability stable
     */
    get replyToSessionIdInput(): string | undefined;
    private _sessionId?;
    /**
     * @stability stable
     */
    get sessionId(): string;
    /**
     * @stability stable
     */
    set sessionId(value: string);
    /**
     * @stability stable
     */
    resetSessionId(): void;
    /**
     * @stability stable
     */
    get sessionIdInput(): string | undefined;
    private _to?;
    /**
     * @stability stable
     */
    get to(): string;
    /**
     * @stability stable
     */
    set to(value: string);
    /**
     * @stability stable
     */
    resetTo(): void;
    /**
     * @stability stable
     */
    get toInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ServicebusSubscriptionRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#create ServicebusSubscriptionRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#delete ServicebusSubscriptionRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#read ServicebusSubscriptionRule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule#update ServicebusSubscriptionRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function servicebusSubscriptionRuleTimeoutsToTerraform(struct?: ServicebusSubscriptionRuleTimeoutsOutputReference | ServicebusSubscriptionRuleTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class ServicebusSubscriptionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ServicebusSubscriptionRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ServicebusSubscriptionRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule azurerm_servicebus_subscription_rule}.
 *
 * @stability stable
 */
export declare class ServicebusSubscriptionRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/servicebus_subscription_rule azurerm_servicebus_subscription_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServicebusSubscriptionRuleConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    resetAction(): void;
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _filterType?;
    /**
     * @stability stable
     */
    get filterType(): string;
    /**
     * @stability stable
     */
    set filterType(value: string);
    /**
     * @stability stable
     */
    get filterTypeInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    resetNamespaceName(): void;
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    resetResourceGroupName(): void;
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sqlFilter?;
    /**
     * @stability stable
     */
    get sqlFilter(): string;
    /**
     * @stability stable
     */
    set sqlFilter(value: string);
    /**
     * @stability stable
     */
    resetSqlFilter(): void;
    /**
     * @stability stable
     */
    get sqlFilterInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    resetSubscriptionId(): void;
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _subscriptionName?;
    /**
     * @stability stable
     */
    get subscriptionName(): string;
    /**
     * @stability stable
     */
    set subscriptionName(value: string);
    /**
     * @stability stable
     */
    resetSubscriptionName(): void;
    /**
     * @stability stable
     */
    get subscriptionNameInput(): string | undefined;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    resetTopicName(): void;
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
    private _correlationFilter;
    /**
     * @stability stable
     */
    get correlationFilter(): ServicebusSubscriptionRuleCorrelationFilterOutputReference;
    /**
     * @stability stable
     */
    putCorrelationFilter(value: ServicebusSubscriptionRuleCorrelationFilter): void;
    /**
     * @stability stable
     */
    resetCorrelationFilter(): void;
    /**
     * @stability stable
     */
    get correlationFilterInput(): ServicebusSubscriptionRuleCorrelationFilter | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ServicebusSubscriptionRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ServicebusSubscriptionRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ServicebusSubscriptionRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
