import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SynapseSparkPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#cache_size SynapseSparkPool#cache_size}.
     *
     * @stability stable
     */
    readonly cacheSize?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#compute_isolation_enabled SynapseSparkPool#compute_isolation_enabled}.
     *
     * @stability stable
     */
    readonly computeIsolationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#dynamic_executor_allocation_enabled SynapseSparkPool#dynamic_executor_allocation_enabled}.
     *
     * @stability stable
     */
    readonly dynamicExecutorAllocationEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#name SynapseSparkPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#node_count SynapseSparkPool#node_count}.
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#node_size SynapseSparkPool#node_size}.
     *
     * @stability stable
     */
    readonly nodeSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#node_size_family SynapseSparkPool#node_size_family}.
     *
     * @stability stable
     */
    readonly nodeSizeFamily: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#session_level_packages_enabled SynapseSparkPool#session_level_packages_enabled}.
     *
     * @stability stable
     */
    readonly sessionLevelPackagesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#spark_events_folder SynapseSparkPool#spark_events_folder}.
     *
     * @stability stable
     */
    readonly sparkEventsFolder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#spark_log_folder SynapseSparkPool#spark_log_folder}.
     *
     * @stability stable
     */
    readonly sparkLogFolder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#spark_version SynapseSparkPool#spark_version}.
     *
     * @stability stable
     */
    readonly sparkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#synapse_workspace_id SynapseSparkPool#synapse_workspace_id}.
     *
     * @stability stable
     */
    readonly synapseWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#tags SynapseSparkPool#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    };
    /**
     * auto_pause block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#auto_pause SynapseSparkPool#auto_pause}
     *
     * @stability stable
     */
    readonly autoPause?: SynapseSparkPoolAutoPause;
    /**
     * auto_scale block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#auto_scale SynapseSparkPool#auto_scale}
     *
     * @stability stable
     */
    readonly autoScale?: SynapseSparkPoolAutoScale;
    /**
     * library_requirement block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#library_requirement SynapseSparkPool#library_requirement}
     *
     * @stability stable
     */
    readonly libraryRequirement?: SynapseSparkPoolLibraryRequirement;
    /**
     * spark_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#spark_config SynapseSparkPool#spark_config}
     *
     * @stability stable
     */
    readonly sparkConfig?: SynapseSparkPoolSparkConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#timeouts SynapseSparkPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: SynapseSparkPoolTimeouts;
}
/**
 * @stability stable
 */
export interface SynapseSparkPoolAutoPause {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#delay_in_minutes SynapseSparkPool#delay_in_minutes}.
     *
     * @stability stable
     */
    readonly delayInMinutes: number;
}
export declare function synapseSparkPoolAutoPauseToTerraform(struct?: SynapseSparkPoolAutoPauseOutputReference | SynapseSparkPoolAutoPause): any;
/**
 * @stability stable
 */
export declare class SynapseSparkPoolAutoPauseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSparkPoolAutoPause | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSparkPoolAutoPause | undefined);
    private _delayInMinutes?;
    /**
     * @stability stable
     */
    get delayInMinutes(): number;
    /**
     * @stability stable
     */
    set delayInMinutes(value: number);
    /**
     * @stability stable
     */
    get delayInMinutesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SynapseSparkPoolAutoScale {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#max_node_count SynapseSparkPool#max_node_count}.
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#min_node_count SynapseSparkPool#min_node_count}.
     *
     * @stability stable
     */
    readonly minNodeCount: number;
}
export declare function synapseSparkPoolAutoScaleToTerraform(struct?: SynapseSparkPoolAutoScaleOutputReference | SynapseSparkPoolAutoScale): any;
/**
 * @stability stable
 */
export declare class SynapseSparkPoolAutoScaleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSparkPoolAutoScale | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSparkPoolAutoScale | undefined);
    private _maxNodeCount?;
    /**
     * @stability stable
     */
    get maxNodeCount(): number;
    /**
     * @stability stable
     */
    set maxNodeCount(value: number);
    /**
     * @stability stable
     */
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    /**
     * @stability stable
     */
    get minNodeCount(): number;
    /**
     * @stability stable
     */
    set minNodeCount(value: number);
    /**
     * @stability stable
     */
    get minNodeCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface SynapseSparkPoolLibraryRequirement {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#content SynapseSparkPool#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#filename SynapseSparkPool#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
}
export declare function synapseSparkPoolLibraryRequirementToTerraform(struct?: SynapseSparkPoolLibraryRequirementOutputReference | SynapseSparkPoolLibraryRequirement): any;
/**
 * @stability stable
 */
export declare class SynapseSparkPoolLibraryRequirementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSparkPoolLibraryRequirement | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSparkPoolLibraryRequirement | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SynapseSparkPoolSparkConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#content SynapseSparkPool#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#filename SynapseSparkPool#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
}
export declare function synapseSparkPoolSparkConfigToTerraform(struct?: SynapseSparkPoolSparkConfigOutputReference | SynapseSparkPoolSparkConfig): any;
/**
 * @stability stable
 */
export declare class SynapseSparkPoolSparkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSparkPoolSparkConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSparkPoolSparkConfig | undefined);
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface SynapseSparkPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#create SynapseSparkPool#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#delete SynapseSparkPool#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#read SynapseSparkPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool#update SynapseSparkPool#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function synapseSparkPoolTimeoutsToTerraform(struct?: SynapseSparkPoolTimeoutsOutputReference | SynapseSparkPoolTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class SynapseSparkPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): SynapseSparkPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: SynapseSparkPoolTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool azurerm_synapse_spark_pool}.
 *
 * @stability stable
 */
export declare class SynapseSparkPool extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/synapse_spark_pool azurerm_synapse_spark_pool} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SynapseSparkPoolConfig);
    private _cacheSize?;
    /**
     * @stability stable
     */
    get cacheSize(): number;
    /**
     * @stability stable
     */
    set cacheSize(value: number);
    /**
     * @stability stable
     */
    resetCacheSize(): void;
    /**
     * @stability stable
     */
    get cacheSizeInput(): number | undefined;
    private _computeIsolationEnabled?;
    /**
     * @stability stable
     */
    get computeIsolationEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set computeIsolationEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetComputeIsolationEnabled(): void;
    /**
     * @stability stable
     */
    get computeIsolationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicExecutorAllocationEnabled?;
    /**
     * @stability stable
     */
    get dynamicExecutorAllocationEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicExecutorAllocationEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicExecutorAllocationEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicExecutorAllocationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _nodeSize?;
    /**
     * @stability stable
     */
    get nodeSize(): string;
    /**
     * @stability stable
     */
    set nodeSize(value: string);
    /**
     * @stability stable
     */
    get nodeSizeInput(): string | undefined;
    private _nodeSizeFamily?;
    /**
     * @stability stable
     */
    get nodeSizeFamily(): string;
    /**
     * @stability stable
     */
    set nodeSizeFamily(value: string);
    /**
     * @stability stable
     */
    get nodeSizeFamilyInput(): string | undefined;
    private _sessionLevelPackagesEnabled?;
    /**
     * @stability stable
     */
    get sessionLevelPackagesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sessionLevelPackagesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSessionLevelPackagesEnabled(): void;
    /**
     * @stability stable
     */
    get sessionLevelPackagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sparkEventsFolder?;
    /**
     * @stability stable
     */
    get sparkEventsFolder(): string;
    /**
     * @stability stable
     */
    set sparkEventsFolder(value: string);
    /**
     * @stability stable
     */
    resetSparkEventsFolder(): void;
    /**
     * @stability stable
     */
    get sparkEventsFolderInput(): string | undefined;
    private _sparkLogFolder?;
    /**
     * @stability stable
     */
    get sparkLogFolder(): string;
    /**
     * @stability stable
     */
    set sparkLogFolder(value: string);
    /**
     * @stability stable
     */
    resetSparkLogFolder(): void;
    /**
     * @stability stable
     */
    get sparkLogFolderInput(): string | undefined;
    private _sparkVersion?;
    /**
     * @stability stable
     */
    get sparkVersion(): string;
    /**
     * @stability stable
     */
    set sparkVersion(value: string);
    /**
     * @stability stable
     */
    resetSparkVersion(): void;
    /**
     * @stability stable
     */
    get sparkVersionInput(): string | undefined;
    private _synapseWorkspaceId?;
    /**
     * @stability stable
     */
    get synapseWorkspaceId(): string;
    /**
     * @stability stable
     */
    set synapseWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get synapseWorkspaceIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _autoPause;
    /**
     * @stability stable
     */
    get autoPause(): SynapseSparkPoolAutoPauseOutputReference;
    /**
     * @stability stable
     */
    putAutoPause(value: SynapseSparkPoolAutoPause): void;
    /**
     * @stability stable
     */
    resetAutoPause(): void;
    /**
     * @stability stable
     */
    get autoPauseInput(): SynapseSparkPoolAutoPause | undefined;
    private _autoScale;
    /**
     * @stability stable
     */
    get autoScale(): SynapseSparkPoolAutoScaleOutputReference;
    /**
     * @stability stable
     */
    putAutoScale(value: SynapseSparkPoolAutoScale): void;
    /**
     * @stability stable
     */
    resetAutoScale(): void;
    /**
     * @stability stable
     */
    get autoScaleInput(): SynapseSparkPoolAutoScale | undefined;
    private _libraryRequirement;
    /**
     * @stability stable
     */
    get libraryRequirement(): SynapseSparkPoolLibraryRequirementOutputReference;
    /**
     * @stability stable
     */
    putLibraryRequirement(value: SynapseSparkPoolLibraryRequirement): void;
    /**
     * @stability stable
     */
    resetLibraryRequirement(): void;
    /**
     * @stability stable
     */
    get libraryRequirementInput(): SynapseSparkPoolLibraryRequirement | undefined;
    private _sparkConfig;
    /**
     * @stability stable
     */
    get sparkConfig(): SynapseSparkPoolSparkConfigOutputReference;
    /**
     * @stability stable
     */
    putSparkConfig(value: SynapseSparkPoolSparkConfig): void;
    /**
     * @stability stable
     */
    resetSparkConfig(): void;
    /**
     * @stability stable
     */
    get sparkConfigInput(): SynapseSparkPoolSparkConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): SynapseSparkPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: SynapseSparkPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): SynapseSparkPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
