import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TrafficManagerNestedEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#enabled TrafficManagerNestedEndpoint#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#endpoint_location TrafficManagerNestedEndpoint#endpoint_location}.
     *
     * @stability stable
     */
    readonly endpointLocation?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#geo_mappings TrafficManagerNestedEndpoint#geo_mappings}.
     *
     * @stability stable
     */
    readonly geoMappings?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_child_endpoints TrafficManagerNestedEndpoint#minimum_child_endpoints}.
     *
     * @stability stable
     */
    readonly minimumChildEndpoints: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv4 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv4}.
     *
     * @stability stable
     */
    readonly minimumRequiredChildEndpointsIpv4?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#minimum_required_child_endpoints_ipv6 TrafficManagerNestedEndpoint#minimum_required_child_endpoints_ipv6}.
     *
     * @stability stable
     */
    readonly minimumRequiredChildEndpointsIpv6?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#priority TrafficManagerNestedEndpoint#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#profile_id TrafficManagerNestedEndpoint#profile_id}.
     *
     * @stability stable
     */
    readonly profileId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#target_resource_id TrafficManagerNestedEndpoint#target_resource_id}.
     *
     * @stability stable
     */
    readonly targetResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#weight TrafficManagerNestedEndpoint#weight}.
     *
     * @stability stable
     */
    readonly weight: number;
    /**
     * custom_header block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#custom_header TrafficManagerNestedEndpoint#custom_header}
     *
     * @stability stable
     */
    readonly customHeader?: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * subnet block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#subnet TrafficManagerNestedEndpoint#subnet}
     *
     * @stability stable
     */
    readonly subnet?: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#timeouts TrafficManagerNestedEndpoint#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: TrafficManagerNestedEndpointTimeouts;
}
/**
 * @stability stable
 */
export interface TrafficManagerNestedEndpointCustomHeader {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#name TrafficManagerNestedEndpoint#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#value TrafficManagerNestedEndpoint#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function trafficManagerNestedEndpointCustomHeaderToTerraform(struct?: TrafficManagerNestedEndpointCustomHeader | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerNestedEndpointSubnet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#first TrafficManagerNestedEndpoint#first}.
     *
     * @stability stable
     */
    readonly first: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#last TrafficManagerNestedEndpoint#last}.
     *
     * @stability stable
     */
    readonly last?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#scope TrafficManagerNestedEndpoint#scope}.
     *
     * @stability stable
     */
    readonly scope?: number;
}
export declare function trafficManagerNestedEndpointSubnetToTerraform(struct?: TrafficManagerNestedEndpointSubnet | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TrafficManagerNestedEndpointTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#create TrafficManagerNestedEndpoint#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#delete TrafficManagerNestedEndpoint#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#read TrafficManagerNestedEndpoint#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint#update TrafficManagerNestedEndpoint#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function trafficManagerNestedEndpointTimeoutsToTerraform(struct?: TrafficManagerNestedEndpointTimeoutsOutputReference | TrafficManagerNestedEndpointTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class TrafficManagerNestedEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TrafficManagerNestedEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TrafficManagerNestedEndpointTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint}.
 *
 * @stability stable
 */
export declare class TrafficManagerNestedEndpoint extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/traffic_manager_nested_endpoint azurerm_traffic_manager_nested_endpoint} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TrafficManagerNestedEndpointConfig);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _endpointLocation?;
    /**
     * @stability stable
     */
    get endpointLocation(): string;
    /**
     * @stability stable
     */
    set endpointLocation(value: string);
    /**
     * @stability stable
     */
    resetEndpointLocation(): void;
    /**
     * @stability stable
     */
    get endpointLocationInput(): string | undefined;
    private _geoMappings?;
    /**
     * @stability stable
     */
    get geoMappings(): string[];
    /**
     * @stability stable
     */
    set geoMappings(value: string[]);
    /**
     * @stability stable
     */
    resetGeoMappings(): void;
    /**
     * @stability stable
     */
    get geoMappingsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _minimumChildEndpoints?;
    /**
     * @stability stable
     */
    get minimumChildEndpoints(): number;
    /**
     * @stability stable
     */
    set minimumChildEndpoints(value: number);
    /**
     * @stability stable
     */
    get minimumChildEndpointsInput(): number | undefined;
    private _minimumRequiredChildEndpointsIpv4?;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv4(): number;
    /**
     * @stability stable
     */
    set minimumRequiredChildEndpointsIpv4(value: number);
    /**
     * @stability stable
     */
    resetMinimumRequiredChildEndpointsIpv4(): void;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv4Input(): number | undefined;
    private _minimumRequiredChildEndpointsIpv6?;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv6(): number;
    /**
     * @stability stable
     */
    set minimumRequiredChildEndpointsIpv6(value: number);
    /**
     * @stability stable
     */
    resetMinimumRequiredChildEndpointsIpv6(): void;
    /**
     * @stability stable
     */
    get minimumRequiredChildEndpointsIpv6Input(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    resetPriority(): void;
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    private _profileId?;
    /**
     * @stability stable
     */
    get profileId(): string;
    /**
     * @stability stable
     */
    set profileId(value: string);
    /**
     * @stability stable
     */
    get profileIdInput(): string | undefined;
    private _targetResourceId?;
    /**
     * @stability stable
     */
    get targetResourceId(): string;
    /**
     * @stability stable
     */
    set targetResourceId(value: string);
    /**
     * @stability stable
     */
    get targetResourceIdInput(): string | undefined;
    private _weight?;
    /**
     * @stability stable
     */
    get weight(): number;
    /**
     * @stability stable
     */
    set weight(value: number);
    /**
     * @stability stable
     */
    get weightInput(): number | undefined;
    private _customHeader?;
    /**
     * @stability stable
     */
    get customHeader(): TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customHeader(value: TrafficManagerNestedEndpointCustomHeader[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomHeader(): void;
    /**
     * @stability stable
     */
    get customHeaderInput(): cdktf.IResolvable | TrafficManagerNestedEndpointCustomHeader[] | undefined;
    private _subnet?;
    /**
     * @stability stable
     */
    get subnet(): TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subnet(value: TrafficManagerNestedEndpointSubnet[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSubnet(): void;
    /**
     * @stability stable
     */
    get subnetInput(): cdktf.IResolvable | TrafficManagerNestedEndpointSubnet[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): TrafficManagerNestedEndpointTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: TrafficManagerNestedEndpointTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): TrafficManagerNestedEndpointTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
