import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface VirtualDesktopHostPoolRegistrationInfoAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#expiration_date VirtualDesktopHostPoolRegistrationInfoA#expiration_date}.
     *
     * @stability stable
     */
    readonly expirationDate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#hostpool_id VirtualDesktopHostPoolRegistrationInfoA#hostpool_id}.
     *
     * @stability stable
     */
    readonly hostpoolId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#timeouts VirtualDesktopHostPoolRegistrationInfoA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: VirtualDesktopHostPoolRegistrationInfoTimeouts;
}
/**
 * @stability stable
 */
export interface VirtualDesktopHostPoolRegistrationInfoTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#create VirtualDesktopHostPoolRegistrationInfoA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#delete VirtualDesktopHostPoolRegistrationInfoA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#read VirtualDesktopHostPoolRegistrationInfoA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info#update VirtualDesktopHostPoolRegistrationInfoA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function virtualDesktopHostPoolRegistrationInfoTimeoutsToTerraform(struct?: VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference | VirtualDesktopHostPoolRegistrationInfoTimeouts | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export declare class VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info azurerm_virtual_desktop_host_pool_registration_info}.
 *
 * @stability stable
 */
export declare class VirtualDesktopHostPoolRegistrationInfoA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/virtual_desktop_host_pool_registration_info azurerm_virtual_desktop_host_pool_registration_info} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: VirtualDesktopHostPoolRegistrationInfoAConfig);
    private _expirationDate?;
    /**
     * @stability stable
     */
    get expirationDate(): string;
    /**
     * @stability stable
     */
    set expirationDate(value: string);
    /**
     * @stability stable
     */
    get expirationDateInput(): string | undefined;
    private _hostpoolId?;
    /**
     * @stability stable
     */
    get hostpoolId(): string;
    /**
     * @stability stable
     */
    set hostpoolId(value: string);
    /**
     * @stability stable
     */
    get hostpoolIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get token(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): VirtualDesktopHostPoolRegistrationInfoTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: VirtualDesktopHostPoolRegistrationInfoTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): VirtualDesktopHostPoolRegistrationInfoTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
