# LocUCT/__init__.py

from .annotation import get_coordinate_type, identify_coordinates_from_csv
from .geocoding import (
    arcgis_geocoding,
    baidu_geocoding,
    banfrance_geocoding,
    bing_geocoding,
    canadapost_geocoding,
    databc_geocoding,
    geocodeearth_geocoding,
    geocodefarm_geocoding,
    gaode_geocoding,
    geolake_geocoding,
    geonames_geocoding,
    geoottawa_geocoding,
    gisgraphy_geocoding,
    google_geocoding,
    here_geocoding,
    ignfrance_geocoding,
    locationiq_geocoding,
    mapbox_geocoding,
    mapquest_geocoding,
    maptiler_geocoding,
    opencage_geocoding,
    openstreetmap_geocoding,
    photon_geocoding,
    pickpoint_geocoding,
    uscensus_geocoding,
    yahoo_geocoding,
    # all_geocoding,
    batch_geocode_from_csv,
)

from .transformation import (
    DD1toOthers,
    OtherstoDD1,
    SpecialCoordsToDD1,
    LengthConverter,
    gars_to_dd1,
    georef_to_dd1,
    mgrs_to_dd1,
    usgn_to_dd1,
    utm1_to_dd1,
    utm2_to_dd1,
    ups_to_dd1,
    plus_codes_to_dd1,
    geohash_to_dd1,
    maidenhead_to_dd1,
)

__all__ = [
    'get_coordinate_type',
    'identify_coordinates_from_csv',
    'arcgis_geocoding',
    'baidu_geocoding',
    'banfrance_geocoding',
    'bing_geocoding',
    'canadapost_geocoding',
    'databc_geocoding',
    'geocodeearth_geocoding',
    'geocodefarm_geocoding',
    # 'gaode_geocoding',
    'geolake_geocoding',
    'geonames_geocoding',
    'geoottawa_geocoding',
    'gisgraphy_geocoding',
    'google_geocoding',
    'here_geocoding',
    # 'ignfrance_geocoding',
    'locationiq_geocoding',
    'mapbox_geocoding',
    'mapquest_geocoding',
    'maptiler_geocoding',
    'opencage_geocoding',
    'openstreetmap_geocoding',
    'photon_geocoding',
    'pickpoint_geocoding',
    'uscensus_geocoding',
    'yahoo_geocoding',
    # 'all_geocoding',
    'batch_geocode_from_csv',
    'DD1toOthers',
    'OtherstoDD1',
    'SpecialCoordsToDD1',
    'LengthConverter',
    'gars_to_dd1',
    'georef_to_dd1',
    'mgrs_to_dd1',
    'usgn_to_dd1',
    'utm1_to_dd1',
    'utm2_to_dd1',
    'ups_to_dd1',
    'plus_codes_to_dd1',
    'geohash_to_dd1',
    'maidenhead_to_dd1',
]
