"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DenoVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// https://semver.org/#is-there-a-suggested-regular-expression-regex-to-check-a-semver-string
const regex = /^(0|[1-9]\d*)\.(0|[1-9]\d*)\.(0|[1-9]\d*)(?:-((?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\.(?:0|[1-9]\d*|\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\+([0-9a-zA-Z-]+(?:\.[0-9a-zA-Z-]+)*))?$/g;
class DenoVersion {
    /**
     * Specify a custom version.
     * Use this if the version you need is not available in one of the predefined versions.
     *
     * @param version The semantic version number without prefix 'v'.
     */
    static of(version) {
        if (!regex.test(version)) {
            throw new Error(`'${version}' is not a valid semantic version`);
        }
        return new DenoVersion(version);
    }
    constructor(version) {
        this.version = version;
    }
}
exports.DenoVersion = DenoVersion;
_a = JSII_RTTI_SYMBOL_1;
DenoVersion[_a] = { fqn: "@pepperize/cdk-lambda-deno.DenoVersion", version: "0.0.573" };
/**
 * 1.23.3
 */
DenoVersion.V1_23_3 = new DenoVersion("1.23.3");
//# sourceMappingURL=data:application/json;base64,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