/////////////////////////////////////////////////////////////////////////
/// DriectAccess Trade Engine
/// Copyright (C) Shanghai DirectAccess Technology Co., Ltd.
/// Last Modify 2019/3/18
/// Define Future Struct
/// Author (c) Wang Jian Quan (Franklin)
/////////////////////////////////////////////////////////////////////////

#pragma once

#include "DADataType.h"

namespace Directaccess {


// 
struct CFutureRspInfoField 
{
	TDAIntType			ErrorID;							// 
	TDAStringType		ErrorMsg;							// 
};
// û¼
struct CFutureReqUserLoginField
{
	TDAStringType		UserId;								// ûʶ
	TDAStringType		UserPwd;							// û
	TDAStringType		UserType;							// û
	TDAStringType		MacAddress;							// MACַ
	TDAStringType		ComputerName;						// 
	TDAStringType		SoftwareName;						// 
	TDAStringType		SoftwareVersion;					// 汾
	TDAStringType		AuthorCode;							// Ȩ
	TDAStringType		ErrorDescription;					// Ϣ
};
// û¼
struct CFutureRspAccountField
{
	TDAStringType		UserId;								// ûʶ
	TDAStringType		UserName;							// û    
	TDAStringType		UserType;							// û             
	TDAStringType		LoginPwd;							// ¼             
	TDAStringType		AccountNo;							// ʽ˺              
	TDAStringType		TradePwd;							//              
	TDAStringType		IsSimulation;						// Ƿģû              
	TDAStringType		FrontendIp;							// ǰûIPַ              
	TDAStringType		FrontendPort;						// ǰû˿ں            
	TDAStringType		CurrencyNo;							// ʻ           
	TDAStringType		UserState;							// û״̬ C U D         
	TDAStringType		SelAll;								// ǷȨ             
	TDAStringType		Strategy;							// ǷԶԵ              
	TDAStringType		Inner;								// Ƿ¹ڵ             
	TDAStringType		YingSun;							// Ƿʹֹֹӯ          
	TDAStringType		ChaoDan;							// Ƿʹóֹ             
	TDAStringType		Option;								// ǷԽȨ0             
	TDAStringType		CmeMarket;							// ǷԻȡCME飺0              
	TDAStringType		CmeCOMEXMarket;						// ǷԻȡCME_COMEX               
	TDAStringType		CmeNYMEXMarket;						// ǷԻȡCME_NYMEX               
	TDAStringType		CmeCBTMarket;						// ǷԻȡCME_CBT               
	TDAStringType		IceUSMarket;						// ǷԻȡICE US              
	TDAStringType		IceECMarket;						// ǷԻȡICE EC             
	TDAStringType		IceEFMarket;						// ǷԻȡICE EF             
	TDAStringType		CanTradeStockHK;					// ǷԽ׸۹             
	TDAStringType		CanTradeStockAM;					// ǷԽ            
	TDAStringType		MultiLogin;							// ǷԶദ¼          
	TDAStringType		SellStockHK;						// Ƿո۹              
	TDAStringType		SellStockAM;						// Ƿ                
	TDAStringType		CanTradeStockKRX;					// ǷԽ׺               
	TDAStringType		HkexMarket;							// ǷԻȡڻ۽HKEX飺0ԣ1ԣʹŻ飩2ʹŻ飻3ʹŻ mantis1080 mantis393           
	TDAStringType		IdNumber;							// û֤Ʊֻ֤ͣΪ1ʱѡ88Ż飻ڻ֤룬15λ18λǹڿͻ    
	TDAStringType		HkexMarketFee;						// ۽շѽΪ0ʱʾڻڣ0ʾʼշѣ       
	TDAStringType		IsProfessional;						// CMEȨǷרҵ棨1ǣ0  
	TDAStringType		IsOverSea;							// Ƿ¼       
	TDAStringType		IsFirstLogin;						// Ƿ豸ε¼ 
	TDAStringType		UserMobile;							// ûֻ 
	TDAStringType		HasSetQA;							// ǷѾܱ 
	TDAStringType		CanTradeStockSGXQ;					// ǷԽ¼¹      
	TDAStringType		ExistMac;							// ǷѾ󶨹豸macַ1ǣ0 or other   
	TDAStringType		RatioINE;							// ϺԴȡʽϵ          
	TDAStringType		EurexMarket;						// ǷԻȡEurex飺0ԣ1ԣ̫Żݣ2ԣרҵ3ԣרҵͶߣ4ԣʾ̫ʹ̫Ż飩   
	TDAStringType		HkexIsOverMaxTerminal;				// Ƿ񳬹ն:0:δ,0      
	TDAStringType		HkexOverMoney;						// ۽նշ      
	TDAStringType		CanTradeStockAU;					// ǷɽװĹ      
	TDAStringType		NyFlag;								// Դʾ
};
// ûǳ
struct CFutureReqUserLogoutField
{
	TDAStringType		UserId;								// ûʶ
	TDAStringType		AccountNo;							// ʽ˺
	TDAStringType		ErrorDescription;					// Ϣ
};
// 
// new order request struct
struct CFutureReqOrderInsertField
{
	TDAStringType		UserId;								// ûʶ
															// User id

	TDAStringType		AccountNo;							// ʽ˺
															// Account No

	TDAStringType		LocalNo;							// APIûĳָıض	
															// Order ID assigned by API user program

	TDAStringType		ExchangeCode;						// 
															// Exchange code

	TDAStringType		ContractCode;						// Լ
															// Contract code 

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=	
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OpenCloseFlag;						// ֻƽ: DERIVATIVE_OPEN_POS_FLAG=,DERIVATIVE_CLOSE_POS_FLAG=ƽ
															// Open/close position flag: DERIVATIVE_OPEN_POS_FLAG=open position	,DERIVATIVE_CLOSE_POS_FLAG=close position

	TDAStringType		OrderQty;							// 
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸	
															// Order price

	// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	//		DERIVATIVE_LIMIT_STOP_ORDER=޼ֹDERIVATIVE_STOP_LOSS_ORDER=ֹ	
	// order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	//		DERIVATIVE_LIMIT_STOP_ORDER=limit stop order ,DERIVATIVE_STOP_LOSS_ORDER=stop loss order
	TDAStringType		OrderType;

	TDAStringType		TriggerPrice;						// ۸
															// Trigger price
	// Ч:
	//		DERIVATIVE_TDY_TIF=Ч, DERIVATIVE_GTC_TIF=ЧGTCDERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF4=IOC
	//		DERIVATIVE_FOK_TIF=FOKDERIVATIVE_GTD_TIF=GTDDERIVATIVE_ATC_TIF=ATCDERIVATIVE_FAK_TIF=FAK
	// order time in force:
	//		DERIVATIVE_TDY_TIF=the day only,DERIVATIVE_GTC_TIF=GTC,DERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF=IOC
	//		DERIVATIVE_FOK_TIF=FOK,DERIVATIVE_GTD_TIF=GTD,DERIVATIVE_ATC_TIF=ATC,DERIVATIVE_FAK_TIF=FAK	
	TDAStringType		TIF;							
	
	TDAStringType		StrategyId;							// ID 20130726 add
															// Strategy id

	TDAStringType		MaxShow;							// ɽʾ
															// Max show quantity for ICE order													

	TDAStringType		MinQty;								// FAK/FOKСɽ
															// Min filled quantity expected by FAK/FOK order

	TDAStringType		Tag50;								// µID(CMEض)
															//  Order placer's id (CME exchange specific)

	TDAStringType		ErrorDescription;					// Ϣ
															// Error message description
	TDAIntType		    IsProgram;							// 򻯵(0)˹(1)	

	TDAStringType	    OrgOrderLocationID;					// ISO(3166-1)׼жĹҴ
															// ISO(3166-1)identifier of the physical location

};
// 
struct CFutureRspOrderInsertField
{
	TDAStringType		UserId;								// ûʶ
															// User id
		
	TDAStringType		AccountNo;							// ʽ˺
															// Account No														

	TDAStringType		SystemNo;							// ϵͳ
															// System no	
		
	TDAStringType		LocalNo;							// ر APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
															// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships
																	
	TDAStringType		ExchangeCode;						// 
															// Exchange code														

	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OrderQty;							// 
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸
															// Order price
		
	// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	//		DERIVATIVE_LIMIT_STOP_ORDER=޼ֹDERIVATIVE_STOP_LOSS_ORDER=ֹ	
	// Order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	//		DERIVATIVE_LIMIT_STOP_ORDER=limit stop order ,DERIVATIVE_STOP_LOSS_ORDER=stop loss order
	TDAStringType		OrderType;							
	
	TDAStringType		OrderDate;							// µ
															// Order date

	TDAStringType		OrderTime;							// µʱ
															// Order time

	TDAStringType		ErrorCode;							// 
															// Error code

	// ״̬:
	//		DERIVATIVE_ORDER_STATE1=  DERIVATIVE_ORDER_STATE2=Ŷӣ  DERIVATIVE_ORDER_STATE3=ֳɽ
	//		DERIVATIVE_ORDER_STATE4=ȫɽDERIVATIVE_ORDER_STATE5=ѳ൥DERIVATIVE_ORDER_STATE6=ѳ
	//		DERIVATIVE_ORDER_STATE7=ָʧܣDERIVATIVE_ORDER_STATE8=ͳ  DERIVATIVE_ORDER_STATE9=ģ
	//		DERIVATIVE_ORDER_STATEA=
	// Order state:
	//		DERIVATIVE_ORDER_STATE1=requested 
	//		DERIVATIVE_ORDER_STATE2=be queuing  
	//		DERIVATIVE_ORDER_STATE3=some orders were closed  
	//		DERIVATIVE_ORDER_STATE4=full order  
	//		DERIVATIVE_ORDER_STATE5=the remaining order has been cancelled
	//		DERIVATIVE_ORDER_STATE6=order has been cancelled  
	//		DERIVATIVE_ORDER_STATE7=command failure 
	//		DERIVATIVE_ORDER_STATE8=the command is waiting to be sent 
	//		DERIVATIVE_ORDER_STATE9=the command is waiting to be changed 
	//		DERIVATIVE_ORDER_STATEA=the command is waiting to be cancelled
	TDAStringType		OrderState;							
															
	
	TDAStringType		TriggerPrice;						// ۸
															// Trigger price
	// Ч:
	//		DERIVATIVE_TDY_TIF=Ч, DERIVATIVE_GTC_TIF=ЧGTCDERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF4=IOC
	//		DERIVATIVE_FOK_TIF=FOKDERIVATIVE_GTD_TIF=GTDDERIVATIVE_ATC_TIF=ATCDERIVATIVE_FAK_TIF=FAK
	// Order time in force:
	//		DERIVATIVE_TDY_TIF=the day only,DERIVATIVE_GTC_TIF=GTC,DERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF=IOC
	//		DERIVATIVE_FOK_TIF=FOK,DERIVATIVE_GTD_TIF=GTD,DERIVATIVE_ATC_TIF=ATC,DERIVATIVE_FAK_TIF=FAK
	TDAStringType		TIF;

	TDAStringType		OpenCloseFlag;						// ֻƽ: DERIVATIVE_OPEN_POS_FLAG=,DERIVATIVE_CLOSE_POS_FLAG=ƽ
															// Open/close position flag: DERIVATIVE_OPEN_POS_FLAG=open position	,DERIVATIVE_CLOSE_POS_FLAG=close position

	TDAStringType		StrategyId;							// ID		
															// Strategy id													
		
	TDAStringType		MaxShow;							// ɽʾ
															// Max show quantity for ICE order

	TDAStringType		MinQty;								// FAK/FOKСɽ 
															// Min filled quantity expected by FAK/FOK order

	TDAStringType		ExchangeTime;						// ʱ
															// Exchange time
	
	TDAStringType		OrdSourceType;						// ն(CMEض)
															// Identify the type of terminal(CME exchange specific)

	TDAStringType		Tag50;								// µID(CMEض)
															// Order placer's id (CME exchange specific)
};
// ޸Ķ
struct CFutureReqOrderModifyField
{
	TDAStringType		SystemNo;							// ϵͳ
															// System No

	TDAStringType		UserId;								// ûʶ
															// User id
	
	TDAStringType		LocalNo;							// APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		AccountNo;							// ʽ˺
															// Account No
	
	TDAStringType		OrderNo;							// 
															// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

	TDAStringType		ExchangeCode;						// 
															// Exchange code
															
	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OrderQty;							// 
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸
															// Order price
	
	TDAStringType		ModifyQty;							// ĵ 
															// Modify quantity

	TDAStringType		ModifyPrice;						// ĵ۸
															// Modify price
	
	// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	//		DERIVATIVE_LIMIT_STOP_ORDER=޼ֹDERIVATIVE_STOP_LOSS_ORDER=ֹ	
	// order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	//		DERIVATIVE_LIMIT_STOP_ORDER=limit stop order ,DERIVATIVE_STOP_LOSS_ORDER=stop loss order
	TDAStringType		OrderType;							
	
	TDAStringType		TriggerPrice;						// ۸
															// Trigger price

	TDAStringType		ModifyTriggerPrice;					// ĵ۸
															// Modify trigger price
	// Ч:
	//		DERIVATIVE_TDY_TIF=Ч, DERIVATIVE_GTC_TIF=ЧGTC	
	// order time in force:
	//		DERIVATIVE_TDY_TIF=the day only,DERIVATIVE_GTC_TIF=GTC
	TDAStringType		TIF;

	TDAStringType		Tag50;								// µID(CMEض)
															// Order placer's id (CME exchange specific)

	TDAStringType		ErrorDescription;					// Ϣ
															// Error description
	TDAStringType	    OrgOrderLocationID;					// ISO(3166-1)׼жĹҴ
															// ISO(3166-1)identifier of the physical location

};
// ޸Ķ
typedef CFutureRspOrderInsertField CFutureRspOrderModifyField;
// 
struct CFutureReqOrderCancelField
{
	TDAStringType		UserId;								// ûʶ
															// User id
	
	TDAStringType		LocalNo;							// APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		AccountNo;							// ʽ˺
															// Account No
		
	TDAStringType		SystemNo;							// ϵͳ
															// System No

	TDAStringType		OrderNo;							// 
															// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships
	TDAStringType		ExchangeCode;						// 
															// Exchange code

	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OrderQty;							// µ
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸
															// Order price
	
		// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	// Order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	TDAStringType		OrderType;							
		
	TDAStringType		Tag50;								// µID(CMEض)
															//  Order placer's id (CME exchange specific)

	TDAStringType		ErrorDescription;					// Ϣ
															// Error message description

	TDAStringType	    OrgOrderLocationID;					// ISO(3166-1)׼жĹҴ
															// ISO(3166-1)identifier of the physical location

};
// 
struct CFutureRspOrderCancelField
{
	TDAStringType		UserId;								// ûʶ
															// User id

	TDAStringType		AccountNo;							// ʽ˺
															// Account No

	TDAStringType		SystemNo;							// ϵͳ
															// System No

	TDAStringType		LocalNo;							// ر APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
															// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

	TDAStringType		CancelNo;							// 
															// Cancel order No

	TDAStringType		ExchangeCode;						// 
															// Exchange code

	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OrderQty;							// µ
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸
															// Order price

	TDAStringType		FilledQty;							// ѳɽ
															// Filled quantity (The number of orders has been completed)

	TDAStringType		CancelledQty;						// ѳ
															// Cancelled quantity
	// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	// Order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	TDAStringType		OrderType;							
	
	TDAStringType		CancelledDate;						// 
															// Cancelled date

	TDAStringType		CancelledTime;						// ʱ
															// Cancelled time

	TDAStringType		ErrorCode;							// 
															// Error code
	
	TDAStringType		OrdSourceType;						// ն(CMEض)
															// Identify the type of terminal(CME exchange specific)
															
	TDAStringType		Tag50;								// µID(CMEض)
															// Order placer's id (CME exchange specific)
};
// ޸
struct CFutureReqPasswordUpdateField
{
	TDAStringType		UserId;								// û
	TDAStringType		OldPassword;						// ûԭ
	TDAStringType		NewPassword;						// û
	TDAStringType		ErrorDescription;					// Ϣ
};
// ޸뷵
struct CFutureRspPasswordUpdateField
{
	TDAStringType		UserId;								// û
	TDAStringType		OldPassword;						// ûԭ
	TDAStringType		NewPassword;						// û
};
// ѯ
struct CFutureQryOrderField
{
	TDAStringType		UserId;								// ûʶ
															// User id

	TDAStringType		AccountNo;							// ʽ˺
															// Account No
// ǷģûDERIVATIVE_IS_SIMULATED_USER=ǣDERIVATIVE_IS_NOT_SIMULATED_USER or other
// Is it a simulated user:
// DERIVATIVE_IS_SIMULATED_USER=is a simulated user
// DERIVATIVE_IS_NOT_SIMULATED_USER or other = is not a simulated user
	TDAStringType		IsSimulation;						
															
	TDAStringType		OrderNo;							// ȡָԺĶ
															// Obtain a subsequent order with the specified order number

	TDAStringType		OrderDateTime;						// ȡָʱԺĶʽyyyy-MM-dd hh:mm:ss
															// Obtain orders after the specified order timeformatyyyy-MM-dd hh:mm:ss

	TDAStringType		ErrorDescription;					// Ϣ
															// Error description
};
// ѯ
struct CFutureRspOrderField
{
	TDAStringType		UserId;								// ûʶ
															// User id

	TDAStringType		AccountNo;							// ʽ˺
															// Account No

	TDAStringType		SystemNo;							// ϵͳ
															// System No

	TDAStringType		LocalNo;							// APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
															// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships
		
	TDAStringType		ExchangeCode;						// 
															// Exchange code

	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		BidAskFlag;							// : DERIVATIVE_BID=,DERIVATIVE_ASK=
															// Bid or ask: DERIVATIVE_BID=bid,DERIVATIVE_ASK=ask

	TDAStringType		OrderQty;							// 
															// Order quantity

	TDAStringType		OrderPrice;							// µ۸
															// Order price

	TDAStringType		FilledQty;							// ѳɽ
															// Filled quantity (The number of orders has been completed)

	TDAStringType		FilledPrice;						// ɽ
															// Filled price(Average transaction price)

	// ͣ
	//		DERIVATIVE_LIMIT_ORDER=޼۵, DERIVATIVE_MARKET_ORDER=м۵
	//		DERIVATIVE_LIMIT_STOP_ORDER=޼ֹDERIVATIVE_STOP_LOSS_ORDER=ֹ	
	// Order type:
	//		DERIVATIVE_LIMIT_ORDER=limit order, DERIVATIVE_MARKET_ORDER=market order 
	//		DERIVATIVE_LIMIT_STOP_ORDER=limit stop order ,DERIVATIVE_STOP_LOSS_ORDER=stop loss order
	TDAStringType		OrderType;							
	
	TDAStringType		OrderDate;							// µ
															// Order date

	TDAStringType		OrderTime;							// µʱ
															// Order time

	TDAStringType		ErrorCode;							// 
															// Error code

	// ״̬:
	//		DERIVATIVE_ORDER_STATE1=  DERIVATIVE_ORDER_STATE2=Ŷӣ  DERIVATIVE_ORDER_STATE3=ֳɽ
	//		DERIVATIVE_ORDER_STATE4=ȫɽDERIVATIVE_ORDER_STATE5=ѳ൥DERIVATIVE_ORDER_STATE6=ѳ
	//		DERIVATIVE_ORDER_STATE7=ָʧܣDERIVATIVE_ORDER_STATE8=ͳ  DERIVATIVE_ORDER_STATE9=ģ
	//		DERIVATIVE_ORDER_STATEA=
	// Order state:
	//		DERIVATIVE_ORDER_STATE1=requested 
	//		DERIVATIVE_ORDER_STATE2=be queuing  
	//		DERIVATIVE_ORDER_STATE3=some orders were closed  
	//		DERIVATIVE_ORDER_STATE4=full order  
	//		DERIVATIVE_ORDER_STATE5=the remaining order has been cancelled
	//		DERIVATIVE_ORDER_STATE6=order has been cancelled  
	//		DERIVATIVE_ORDER_STATE7=command failure 
	//		DERIVATIVE_ORDER_STATE8=the command is waiting to be sent 
	//		DERIVATIVE_ORDER_STATE9=the command is waiting to be changed 
	//		DERIVATIVE_ORDER_STATEA=the command is waiting to be cancelled
	TDAStringType		OrderState;							
	
	TDAStringType		CancelUserId;						// ûʶ
															// User id of cancel order

	TDAStringType		TriggerPrice;						// ۸
															// Trigger price

	// Ч:
	//		DERIVATIVE_TDY_TIF=Ч, DERIVATIVE_GTC_TIF=ЧGTCDERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF4=IOC
	//		DERIVATIVE_FOK_TIF=FOKDERIVATIVE_GTD_TIF=GTDDERIVATIVE_ATC_TIF=ATCDERIVATIVE_FAK_TIF=FAK
	// order time in force:
	//		DERIVATIVE_TDY_TIF=the day only,DERIVATIVE_GTC_TIF=GTC,DERIVATIVE_OPG_TIF=OPG,DERIVATIVE_IOC_TIF=IOC
	//		DERIVATIVE_FOK_TIF=FOK,DERIVATIVE_GTD_TIF=GTD,DERIVATIVE_ATC_TIF=ATC,DERIVATIVE_FAK_TIF=FAK
	TDAStringType		TIF;								

	TDAStringType		OpenCloseFlag;						// ֻƽ: DERIVATIVE_OPEN_POS_FLAG=,DERIVATIVE_CLOSE_POS_FLAG=ƽ
															// Open/close position flag: DERIVATIVE_OPEN_POS_FLAG=open position	,DERIVATIVE_CLOSE_POS_FLAG=close position

	TDAStringType		StrategyId;							// ID 20130726 add
															// Strategy id

	TDAStringType		MaxShow;							// ɽʾ
															// Max show quantity for ICE order

	TDAStringType		MinQty;								// FAK/FOKСɽ
															// Min filled quantity expected by FAK/FOK order

	TDAStringType		ExchangeTime;						// ʱ
															// Exchange time

	TDAStringType		CancelTime;							// ʱ
															// Cancel time
};
// ѯɽ
struct CFutureQryTradeField
{

	TDAStringType		UserId;								// û		
	TDAStringType		ErrorDescription;					// Ϣ
	TDAStringType		lastFilledNo;						//ѯһûɽ //update 2020.04.29 ywh
	TDAStringType		maxItemNumOnePage;					//ѯɽÿҳ		
};
// ѯɽ
struct CFutureRspTradeField
{
	TDAStringType		UserId;								// ûʶ
	TDAStringType		AccountNo;							// ʽ˺
	TDAStringType		FilledNo;							// ɽţҪ7λĶţһ11λ
	TDAStringType		OrderNo;							// 
	TDAStringType		SystemNo;							// ϵͳ
	TDAStringType		LocalNo;							// ر
	TDAStringType		ExchangeCode;						// 
	TDAStringType		TreatyCode;							// Լ
	TDAStringType		BuySale;							// 1=buy 2=sell
	TDAStringType		FilledNumber;						// ɽ
	TDAStringType		FilledPrice;						// ɽ۸
	TDAStringType		FilledDate;							// ɽ(yyyy-MM-dd)
	TDAStringType		FilledTime;							// ɽʱ(hh:mm:ss)
	TDAStringType		Commsion;							// ɽ
	TDAStringType		OrderNumber;						// ί
	TDAStringType		OrderPrice;							// ίм۸
	TDAStringType		DeliveryDate;						// Լ(yyyyMMdd)
	TDAStringType		FilledType;							// ɽ(NͨµɽCTģɽ)
	TDAStringType		OrderType;							// ͣ1=޼۵, 2=м۵3=޼ֹstop to limit4=ֹstop to market
	TDAStringType		ValidDate;							// Чڣ1=Ч, 2=Ч
	TDAStringType		AddReduce;							// ֻƽ֣1= 2=ƽ֣3=ƽ4=ƽ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯԼ
struct CFutureQryInstrumentField
{
	TDAIntType			PageIndex;							// ѯ,ÿηص
	TDAStringType		ExchangeNo;							// 룬дֵѯһĺԼ
	TDAStringType		CommodityNo;						// Լ롣ѯԼ	
	TDAStringType		CommodityType;						// Ʒ 
	TDAStringType		ContractNo;							// ԼNO
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯԼ
struct CFutureRspInstrumentField
{
	TDAStringType		CommodityCode;						// ƷźԼNO 
	TDAStringType		ExchangeNo;							// 
	TDAStringType		ContractNo;							// ԼNO
	TDAStringType		ContractFName;						// Լ
	TDAStringType		CommodityNo;						// Ʒ
	TDAStringType		CommodityFName;						// Ʒ 
	TDAStringType		CommodityType;						// Ʒ 
	TDAStringType		CommodityFCurrencyNo;				// ұ 
	TDAStringType		CurrencyFName;						//  
	TDADoubleType		ProductDot;							// ֵһСļֵ
	TDADoubleType		UpperTick;							// С䶯λ 
	TDAStringType		ExchangeName;						//  
	TDADoubleType		LastSettlePrice;					// ս 
	TDAStringType		TradeMonth;							//  (yyyyMM)/ (yyyyMMdd)
	TDAIntType			DotNum;								// Сλ
	TDAIntType			LowerTick;							// ׵λ
	TDAIntType			DotNumCarry;						// Сλ
	TDADoubleType		UpperTickCarry;						// С䶯λ
	TDAStringType		FirstNoticeDay;						// ״֪ͨ (yyyyMMdd)
	TDADoubleType		FreezenPercent;						// ᱣ֤ٷֱ ϺԴ뱣֤ٷֱȣ
	TDADoubleType		FreezenMoney;						// ᱣ̶ֵ֤ 
	TDADoubleType		FeeMoney;							// ̶ 
	TDADoubleType		FeePercent;							// ٷֱ 
	TDADoubleType		PriceStrike;						// ֻƷ 
	TDADoubleType		ProductDotStrike;					// ֻƷֵ  
	TDADoubleType		UpperTickStrike;					// ֻƷС䶯λ 
	TDAStringType		LastTradeDay;						//  (yyyyMMdd)
	TDAStringType		LastUpdateDay;						//  (yyyyMMdd)
	TDADoubleType		CriticalPrice;						// Ȩٽ۸ 
	TDADoubleType		CriticalMinChangedPrice;			// Ȩٽ۸µС 
	TDAStringType		ExchangeSub;						// ʵʽ(CMEϸֳ3:CME,CME_COMEX,CME_NYMEX)
	TDAStringType		OptionType;							// Ȩ(RǣF)
	TDAStringType		OptionMonth;						// Ȩ(yyyyMM)
	TDAStringType		OptionStrikePrice;					// Ȩִм۸
	TDAStringType		OptionCommodityNo;					// ȨӦڻƷţϺԴ֤ٷֱȣ
	TDAStringType		OptionContractNo;					// ȨӦڻԼ
	TDAStringType		ContractFNameEN;					// ԼӢģ
	TDAStringType		CommodityFNameEN;					// ƷӢģ
	TDAStringType		OptionStyle;						// Ȩ(EŷʽAʽ)
};
// ѯ
struct CFutureQryExchangeField
{
	TDAStringType		ProductGroupID;
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯ
struct CFutureRspExchangeField
{
	TDAStringType		ExchangeNo;							// 
	TDAStringType		ExchangeName;						// 
	TDAStringType		SettleType;							// ͣHK۹ɣUSɣ
	TDAStringType 		NameEN;								// ƣӢģ
};
// ѯʽ
// Query fund
struct CFutureQryCapitalField
{
	TDACharType			Unused;								// ʹ
															// No use

	TDAStringType		ErrorDescription;					// Ϣ
															// Error description
};
// ѯʽ𷵻
// Query fund return struct
struct CFutureRspCapitalField
{
	TDAStringType		UserId;								// ûʶ
															// User id

	TDAStringType		Deposit;							// 
															// Deposit

	TDAStringType		Withdraw;							// 
															// Withdraw

	TDAStringType		TodayTradableFund;					// ɣã£տڽ׵ʽ
															// Today tradable fund amount

	TDAStringType		TodayInitialBalance;				// ɣ棻£ڳȨ
															// Today inital balance

	TDAStringType		TodayRealtimeBalance;				// ɣȨ棻£ʵʱȨ
															// Today realtime floating balance with Profit&Loss

	TDAStringType		FrozenFund;							// ʽ
															// Frozen fund

	TDAStringType		Commission;							// Ӷ
															// Commission

	TDAStringType		InitialMargin;						// ɣ֤£ʼ֤
															// Initial margin
								
	TDAStringType		YdTradableFund;						// ɣã£տڽ׵ʽ
															// Yesterday tradable fund amount

	TDAStringType		YdInitialBalance;					// ɣ棻£ڳȨ
															// Yesterday inital balance

	TDAStringType		YdFinalBalance;						// ɣȨ棻£ĩȨ
															// Yesterday final balance with Profit&Loss

	TDAStringType		ProfitLoss;							// ӯ
															// Profit and loss

	TDAStringType		CurrencyNo;							// ֱ 
															// Currency No

	TDAMoneyType		CurrencyRate;						// Ļ
															// Currency rate

	TDAMoneyType		LMEUnexpiredPL;						// LMEδƽӯ
															// LME unexpired profit&losss

	TDAMoneyType		LMEUnaccountPL;						// LMEδƽӯ
															// LME unaccounting profit&losss

	TDAMoneyType		MaintenanceMargin;					// άֱ֤
															// Maintenance margin

	TDAMoneyType		Premium;							// ȨȨ
															// Premium for options

	TDAMoneyType		CreditAmount;						// ζ
															// Credit amount
	
	TDAMoneyType		IntialFund;							// ʼʽ
															// Intial fund

	TDAStringType		FundAccountNo;						// ʽʺ 
															// Fund account No
							
	TDAMoneyType		TradeLimit;							// ޶
															// Trade limit

	TDAMoneyType		CanCashOutMoneyAmount;				// ȡʽ
															// Can cash out money amount

	TDAMoneyType		DepositInterest;					// ´Ϣ
															// Monthly deposit interest

	TDAMoneyType		LoanInterest;						// ǷϢ
															// Monthly loan interest

	TDAStringType		ErrorDescription;					// Ϣ
															// Error description
};
// ѯֲ
struct CFutureQryPositionField
{
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯֲַ
struct CFutureRspPositionField
{
	TDAStringType		MatchDate;							// ɽڣyyyyMMdd
	TDAStringType		MatchNo;							// ɽ
	TDAStringType		ClientNo;							// ͻ
	TDAStringType		ExchangeNo;							// 
	TDAStringType		CommodityNo;						// Ʒ
	TDAStringType		ContractNo;							// Լ
	TDAStringType		Direct;								// 12
	TDAVolumeType		HoldVol;							// ֲ
	TDAPriceType		HoldPrice;							// ־ۣԭʼּۣ
	TDAStringType		CurrencyNo;							// ұ
	TDAPriceType		ForciblyPrice;						// ĳֲ־
	TDAStringType		Account;							// ʽ˺
	TDAStringType		HoldType;							// ֲͣ0֣1֣
	TDAStringType		DeliveryDate;						// Լ(yyyyMMdd)
	TDAStringType		ExchangeName;						// (ͻԼȡ)
	TDAStringType		CurrencyName;						// (ͻԼȡ)
	TDAStringType		ContCode;							// Լ루Ʒ+Լţ(ͻԼȡ)
	TDAPriceType		HoldMargin;							// ֱֲ֤ add 20141222
};
// ѯ
struct CFutureQryTickField
{
	TDACharType			Unused;								// ʹ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯ㷵
struct CFutureRspTickField
{
	TDAStringType		UpperTickCode;						// С䶯λ
	TDAStringType		PriceFrom;							// С䶯λʼ۸
	TDAStringType		UpperTick;							// С䶯λ
	TDAStringType		ProductDot;							// С䶯λӦĵֵ
	TDAStringType		DotNum;								// Сλ
	TDAStringType		LowerTick;							// ۵λ
};
// ѯ
struct CFutureQryCurrencyField
{
	TDACharType			Unused;								// ʹ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯҷ
struct CFutureRspCurrencyField
{
	TDAStringType		CurrencyNo;							// ұ
	TDAIntType			IsBase;								// һұ
	TDADoubleType		ChangeRate;							// ҵĻ
	TDAStringType		CurrencyName;						// 
	TDAStringType		CurrencyNameEN;						// ƣӢģ
};
// ѯʱ
struct CFutureQryCommodityField
{
	TDAStringType		UpdateDate;							// 
	TDAStringType		ExchangeNo;							// 
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯƷб
struct CFutureRspCommodityField
{
	TDAStringType		CommodityNo;						// Ʒ
	TDAStringType		ExchangeNo;							// 
	TDAStringType		CommodityType;						// Ʒ	
	TDAStringType		Name;								// Ʒ
	TDAStringType		Enabled;							// ״̬
	TDAStringType		RegDate;							// 	
	TDAStringType		CurrencyNo;							// ֱ	
	TDADoubleType		ProductDot;							// ֵ
	TDADoubleType		LowerTick;							// ׵λ
	TDADoubleType		UpperTick;							// С䶯λ	
	TDAIntType			DotNum;								// Сλ
	TDAIntType			StrikeCommodityId;					// ԺԼID
	TDAStringType		OptionStyle;						// Ȩ
	TDAStringType		ExchangeNo2;						//  (ExchangeNoµĽCOMEX NYMEX)
	TDAStringType		IsSFuture;							// ǷǸڻ
};
// ѯʱ
struct CFutureQryExchangeTimeField
{
	TDACharType			Unused;								// ʹ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯƷʱ
struct CFutureQryCommodityTimeField
{
	TDAStringType		ExchangeNo;							// 
	TDAStringType		CommodityNo;						// Ʒ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯʱ䷵
struct CFutureRspExchangeTimeField
{
	TDAStringType		Year;								//  ǰ
	TDAStringType		SummerBegin;						//  ʱʼʱ
	TDAStringType		WinterBegin;						//  ʱʼʱ
	TDAStringType		ExchangeNo;							//  
	TDAStringType		Name;								//  
};
// ѯƷʱ䷵
struct CFutureRspCommodityTimeField
{
	TDAStringType		CrossTrade;							// Ƿ
	TDAStringType		Stage;								// ״̬
	TDAStringType		Summer;								// 2 1	
	TDAStringType		Opendate;							// Ʒʱ
	TDAStringType		Closingdate;						// Ʒʱ
	TDAStringType		CommodityNo;						// Ʒ
	TDAStringType		ComName;							// Ʒ
	TDAStringType		ExchangeNo;							// 
	TDAStringType		ExName;								// 
};
// ѯ汾
struct CFutureQryVersionField
{
	TDAStringType		UserId;								// ûʶ
	TDAStringType		UserPwd;							// û
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯ汾
struct CFutureRspVersionField
{
	TDAStringType		Version;							// 汾
	TDAStringType		MustUpdate;							// Ƿµ°汾ʹã0Բ£1£
	TDAStringType		MustVersion;						// Ҫİ汾
	TDAStringType		VersionContent_CN;					// 汾
	TDAStringType		VersionContent_US;					// 汾Ӣ
};
//-------------------------------------------------------------------------
// Ͷ仯
// Push order change struct
struct CFutureRtnOrderField
{
	TDAStringType		LocalNo;							// ر APIûĳָıض
															// Order ID assigned by API user program

	TDAStringType		ExchangeCode;						// 
															// Exchange code

	TDAStringType		ContractCode;						// Լ
															// Contract code

	TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
															// the order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

	TDAIntType			OrderQty;							// ί
															// Quantity of entrusted order

	TDAIntType			FilledQty;							// ѳɽ
															// Filled quantity

	TDAPriceType		FilledAvgPrice;						// ɽ
															// Filled average price	

	TDAIntType			LongPositionQty;					// 
															// Long position quantity

	TDAPriceType		LongPosAveragePrx;					// ɣ򿪲־ۣ£ֳɽ
															// Long - position average price

	TDAPriceType		CNLongPosAveragePrx;				// йƷ(INE/sc)õƽ
															// Long - position average price for Chinese varieties (e.g., INE/sc)

	TDAIntType			ShortPositionQty;					// 
															// Short position quantity

	TDAPriceType		ShortPosAveragePrx;					// ɣ־ۣ£ղֳɽ
															// Short position transaction average price

	TDAPriceType		CNShortPosAveragePrx;				// йƷ(INE/sc)õƽ
															// Short - position average price for Chinese varieties (e.g., INE/sc)
	// ǷѾ
	//	    DERIVATIVE_ORDER_IS_NOT_CANCELLEDûУDERIVATIVE_ORDER_IS_CANCELLEDѳ														// Short  position average price for Chinese varieties (e.g., INE/sc)
	// Order is cancelled 
	//		DERIVATIVE_ORDER_IS_NOT_CANCELLED=order is not cancelled
	//		DERIVATIVE_ORDER_IS_CANCELLED=order is cancelled
	TDAStringType		IsCanceled;							
					
	TDAPriceType		FilledTotalFee;						// ɽܵ
															// Total transaction fee

	TDAIntType			SequenceNo;							// ˳
															// Sequence No

	TDAStringType		AccountNo;							// ʽʺ
															// Account No
	//ֲ:
	//		DERIVATIVE_POSITION_TYPE_Y=,DERIVATIVE_POSITION_TYPE_T=
	//Position type:
	//		DERIVATIVE_POSITION_TYPE_Y=yesterday position, DERIVATIVE_POSITION_TYPE_T=today position
	TDAStringType		PositionType;						
															

	TDAPriceType		LongPosMargin;						// ֤
															// Long position margin

	TDAPriceType		ShortPosMargin;						// ֤
															// Short position margin

	TDAPriceType		CurrPrice;							// ¼
															// Current price

	TDAPriceType		ProfitLoss;							// ӯ
															// Profit loss
};
// ʽ仯
struct CFutureRtnCapitalField
{
	TDAStringType		ClientNo;							// ͻ
	TDAStringType		AccountNo;							// ʽʺ
	TDAStringType		CurrencyNo;							// 
	TDAPriceType		Available;							// 
	TDAPriceType		YAvailable;							// 
	TDAPriceType		CanCashOut;							// ɳ
	TDAPriceType		Money;								// 
	TDAPriceType		ExpiredProfit;						// ƽӯ
	TDAPriceType		FrozenDeposit;						// ʽ
	TDAPriceType		Fee;								// 
	TDAPriceType		Deposit;							// ֤
	TDAPriceType		KeepDeposit;						// άֱ֤
	TDAIntType			Status;								// ״̬
	TDAPriceType		InMoney;							// 
	TDAPriceType		OutMoney;							// 
	TDAPriceType		UnexpiredProfit;					// δƽӯ
	TDAPriceType		TodayTotal;							// Ȩ
	TDAPriceType		UnaccountProfit;					// δƽӯ
	TDAPriceType		Royalty;							// ȨȨ
	TDAStringType		ExchangeNo;							// 
	TDAStringType		TreatyCode;							// Լ
	TDAStringType		OrderNo;							// 
	TDAIntType			OrderNumber;						// ί
	TDAIntType			FilledNumber;						// ѳɽ
	TDAPriceType		FilledAdvPrice;						// ɽ
	TDAIntType			BuyHoldNumber;						// 
	TDAPriceType		BuyHoldOpenPrice;					// 򿪲־
	TDAPriceType		BuyHoldPrice;						// 
	TDAIntType			SaleHoldNumber;						// 
	TDAPriceType		SaleHoldOpenPrice;					// ־
	TDAPriceType		SaleHoldPrice;						// 
	TDAStringType		IsCanceled;							// ǷѾ0ûУ1ѳ
	TDAPriceType		FilledTotalFee;						// ɽܵ
	TDAPriceType		Credit;								// ζ
	TDAPriceType		MarginLimit;						// Iչ޶ 20150727 added for ۹
	TDAPriceType		BorrowValue;						// ֵ 20150727 added for ۹
	TDAPriceType		MortgageMoney;						// Ҽֵ 20150727 added for ۹
	TDAPriceType		T1;									// T1 20160219 added for ۹
	TDAPriceType		T2;									// T2 20160219 added for ۹
	TDAPriceType		T3;									// T3 20160219 added for ۹
	TDAPriceType		TN;									// Tn 20160219 added for ۹
	TDAPriceType		TradeLimit;							// ޶
	TDAPriceType		FCrossMax;							// гʽ޶
	TDAPriceType		SellFreezenMoney;					// նʽ
	TDAPriceType		SellInterest;						// Ϣ
	TDAPriceType		SellNeedAddMargin;					// 貹
};
// ͳֱֲ仯
typedef CFutureRtnOrderField CFutureRtnPositionField;
// ͳɽ
typedef CFutureRspTradeField CFutureRtnTradeField;
//-------------------------------------------------------------------------
// ȡ
struct CFutureReqGetQuestionField
{
	TDAIntType			Unused;								// ûʺ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ȡⷵ
struct CFutureRspQuestionField
{
	TDAStringType		QuestionType;						// 	0ڻ1ʹƱ
	TDAStringType		QuestionId;							// 
	TDAStringType		QuestionCN;							// ⣨ģ
	TDAStringType		QuestionEN;							// ⣨Ӣģ
};
// ȫ֤
struct CFutureReqSafeVerifyField
{
	TDAStringType		UserId;								// ûʺ
	TDAStringType		UserPwd;							// 
	TDAStringType		Type;								// 
	TDAStringType		Question;							// ܱ
	TDAStringType		Answer;								// ܱ
	TDAStringType		MobileNumber;						// ֻ
	TDAStringType		VerifyCode;							// ֻ֤
	TDAStringType		SaveMac;							// ǷҪס豸
	TDAStringType		MacAddress;							// MACַ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ֤
struct CFutureReqSetVerifyQAField
{
	TDAStringType		UserId;								// ûʺ
	TDAStringType		UserPwd;							// 
	TDAStringType		Type;								// 
	TDAStringType		Question;							// ܱ
	TDAStringType		Answer;								// ܱ
	TDAStringType		MobileNumber;						// ֻ
	TDAStringType		VerifyCode;							// ֻ֤
	TDAStringType		SaveMac;							// ǷҪס豸
	TDAStringType		ErrorDescription;					// Ϣ
};
// ֤
struct CFutureReqVerifyCodeField
{
	TDAStringType		UserId;								// ûʺ
	TDAStringType		UserPwd;							// 
	TDAStringType		Type;								// 
	TDAStringType		Question;							// ܱ
	TDAStringType		Answer;								// ܱ
	TDAStringType		MobileNumber;						// ֻ
	TDAStringType		VerifyCode;							// ֻ֤
	TDAStringType		ErrorDescription;					// Ϣ
};
//-------------------------------------------------------------------------
// ѯֲֺϼ
struct CFutureQryTotalPositionField
{
	TDAStringType		AccountNo;							// ʽ˺
	TDAStringType		ErrorDescription;					// Ϣ
};

// ѯֲֺϼƷ
// Query position total return
typedef CFutureRtnOrderField CFutureRspTotalPositionField;

// ѯ
struct CFutureQryStrategyField
{
	TDAStringType		ExchangeNo;							// 룬дֵѯһĲ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯԷ
struct CFutureRspStrategyField
{
	TDAStringType		CommodityCode;					// ƷźԼNO 
	TDAStringType		ExchangeNo;						// 
	TDAStringType		ContractNo;						// ԼNO
	TDAStringType		ContractFName;					// Լ
	TDAStringType		CommodityNo;					// Ʒ
	TDAStringType		CommodityFName;					// Ʒ 
	TDAStringType		CommodityType;					// Ʒ 
	TDAStringType		CommodityFCurrencyNo;			// ұ 
	TDAStringType		CurrencyFName;					//  
	TDAPriceType		ProductDot;						// ֵһСļֵ
	TDAPriceType		UpperTick;						// С䶯λ 
	TDAStringType		ExchangeName;					//  
	TDAPriceType		LastSettlePrice;				// ս 
	TDAStringType		TradeMonth;						//  (yyyyMM)/ (yyyyMMdd)
	TDAIntType			DotNum;							// Сλ
	TDAIntType			LowerTick;						// ׵λ
	TDAIntType			DotNumCarry;					// Сλ
	TDAPriceType		UpperTickCarry;					// С䶯λ
	TDAStringType		FirstNoticeDay;					// ״֪ͨ (yyyyMMdd)
	TDAPriceType		FreezenPercent;					// ᱣ֤ٷֱ ϺԴ뱣֤ٷֱȣ
	TDAPriceType		FreezenMoney;					// ᱣ̶ֵ֤ 
	TDAPriceType		FeeMoney;						// ̶ 
	TDAPriceType		FeePercent;						// ٷֱ 
	TDAPriceType		PriceStrike;					// ֻƷ 
	TDAPriceType		ProductDotStrike;				// ֻƷֵ  
	TDAPriceType		UpperTickStrike;				// ֻƷС䶯λ 
	TDAStringType		LastTradeDay;					//  (yyyyMMdd)
	TDAStringType		LastUpdateDay;					//  (yyyyMMdd)
	TDAPriceType		CriticalPrice;					// Ȩٽ۸ 
	TDAPriceType		CriticalMinChangedPrice;		// Ȩٽ۸µС 
	TDAStringType		ExchangeSub;					// ʵʽ(CMEϸֳ3:CME,CME_COMEX,CME_NYMEX)
	TDAStringType		OptionType;						// Ȩ(RǣF)
	TDAStringType		OptionMonth;					// Ȩ(yyyyMM)
	TDAStringType		OptionStrikePrice;				// Ȩִм۸
	TDAStringType		OptionCommodityNo;				// ȨӦڻƷţϺԴ֤ٷֱȣ
	TDAStringType		OptionContractNo;				// ȨӦڻԼ
	TDAStringType		ContractFNameEN;				// ԼӢģ
	TDAStringType		CommodityFNameEN;				// ƷӢģ
	TDAStringType		OptionStyle;					// Ȩ(EŷʽAʽ)
};
// ѯϸ
struct CFutureQryStrategyDetailField
{
	TDAStringType		StartegyCommodityNo;				// Լ
	TDAStringType		ErrorDescription;					// Ϣ
};
// ѯϸ
struct CFutureRspStrategyDetailField
{
	TDAStringType		StartegyCommodityNo;				// Ʒ
	TDAStringType		StartegyContractNo;					// ԺԼϱ
	TDAStringType		Price;								// ۸
	TDAIntType			LegNum;								// 2ԼΪ2ȣ
	TDAStringType		LastTradeDate;						// գyyyy-MM-dd
	TDAIntType			SeqId;								// кԼ˳
	TDAStringType		CommodityNo;						// кԼƷ
	TDAStringType		ContractNo;							// кԼĺԼ
	TDAStringType		Direct;								// 1ʾ2ʾ
	TDAIntType			Quantity;							// Լµ
	TDAStringType		Model;								// Լµ
	TDAStringType		ModifyDate;							// ڣyyyy-MM-dd
	TDAStringType		OrderMethod;						// µͣ޼ۣмۣ
	TDAPriceType		PriceTolerance;						// ۸̶
	TDAPriceType		PriceParam;							// ۸
	TDAIntType			SuportQuantity;						// ԼС̹ҵ
	TDAIntType			MinMove;							// ԼСƶ
	TDAIntType			TimerOrder;							// Լʱ׷
	TDAStringType		TimerOrderBeyondNum;				// ʱ׷
	TDAIntType			TimerOrderPrice;					// Լʱ׷
	TDAStringType		TimerOrderPriceBeyondNum;			// ʱ׷ۻ
	TDAStringType		TimerOrderPriceTriggerNum;			// ʱ׷۴
	TDAIntType			ZhiSunOrder;						// ֹ׷
	TDAStringType		ZhiSunOrderBeyondNum;				// ֹ׷
	TDAIntType			TimerPingCang;						// Լʱƽ
	TDAStringType		TimerPingCangBeyondNum;				// ʱƽֻ
	TDAIntType			SafeDeep;							// ȫ
	TDAIntType			MainRange;							// 
};



}//end of namespace Directaccess