/////////////////////////////////////////////////////////////////////////
/// DriectAccess Trade Engine
/// Copyright (C) Shanghai DirectAccess Technology Co., Ltd.
/// Last Modify 2019/3/18
/// Define Stock Struct
/// Author (c) Wang Jian Quan (Franklin)
/////////////////////////////////////////////////////////////////////////

#pragma once

#include "DADataType.h"

namespace Directaccess {

	// 
	struct CStockRspInfoField
	{
		TDAIntType			ErrorID;							// 
		TDAStringType		ErrorMsg;							// 
	};
	// û¼
	struct CStockReqUserLoginField
	{
		TDAStringType		UserId;								// ûʶ
		TDAStringType		UserPwd;							// û
		TDAStringType		UserType;							// û
		TDAStringType		MacAddress;							// MACַ
		TDAStringType		ComputerName;						// 
		TDAStringType		SoftwareName;						// 
		TDAStringType		SoftwareVersion;					// 汾
		TDAStringType		AuthorCode;							// Ȩ
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// û¼
	struct CStockRspAccountField
	{
		TDAStringType		UserId;								// ûʶ
		TDAStringType		UserName;							// û    
		TDAStringType		UserType;							// û             
		TDAStringType		LoginPwd;							// ¼             
		TDAStringType		AccountNo;							// ʽ˺              
		TDAStringType		TradePwd;							//              
		TDAStringType		IsSimulation;						// Ƿģû              
		TDAStringType		FrontendIp;							// ǰûIPַ              
		TDAStringType		FrontendPort;						// ǰû˿ں            
		TDAStringType		CurrencyNo;							// ʻ           
		TDAStringType		UserState;							// û״̬ C U D         
		TDAStringType		SelAll;								// ǷȨ             
		TDAStringType		Strategy;							// ǷԶԵ              
		TDAStringType		Inner;								// Ƿ¹ڵ             
		TDAStringType		YingSun;							// Ƿʹֹֹӯ          
		TDAStringType		ChaoDan;							// Ƿʹóֹ             
		TDAStringType		Option;								// ǷԽȨ0             
		TDAStringType		CmeMarket;							// ǷԻȡCME飺0              
		TDAStringType		CmeCOMEXMarket;						// ǷԻȡCME_COMEX               
		TDAStringType		CmeNYMEXMarket;						// ǷԻȡCME_NYMEX               
		TDAStringType		CmeCBTMarket;						// ǷԻȡCME_CBT               
		TDAStringType		IceUSMarket;						// ǷԻȡICE US              
		TDAStringType		IceECMarket;						// ǷԻȡICE EC             
		TDAStringType		IceEFMarket;						// ǷԻȡICE EF             
		TDAStringType		CanTradeStockHK;					// ǷԽ׸۹             
		TDAStringType		CanTradeStockAM;					// ǷԽ            
		TDAStringType		MultiLogin;							// ǷԶദ¼          
		TDAStringType		SellStockHK;						// Ƿո۹              
		TDAStringType		SellStockAM;						// Ƿ                
		TDAStringType		CanTradeStockKRX;					// ǷԽ׺               
		TDAStringType		HkexMarket;							// ǷԻȡڻ۽HKEX飺0ԣ1ԣʹŻ飩2ʹŻ飻3ʹŻ mantis1080 mantis393           
		TDAStringType		IdNumber;							// û֤Ʊֻ֤ͣΪ1ʱѡ88Ż飻ڻ֤룬15λ18λǹڿͻ    
		TDAStringType		HkexMarketFee;						// ۽շѽΪ0ʱʾڻڣ0ʾʼշѣ       
		TDAStringType		IsProfessional;						// CMEȨǷרҵ棨1ǣ0  
		TDAStringType		IsOverSea;							// Ƿ¼       
		TDAStringType		IsFirstLogin;						// Ƿ豸ε¼ 
		TDAStringType		UserMobile;							// ûֻ 
		TDAStringType		HasSetQA;							// ǷѾܱ 
		TDAStringType		CanTradeStockSGXQ;					// ǷԽ¼¹      
		TDAStringType		ExistMac;							// ǷѾ󶨹豸macַ1ǣ0 or other   
		TDAStringType		RatioINE;							// ϺԴȡʽϵ          
		TDAStringType		EurexMarket;						// ǷԻȡEurex飺0ԣ1ԣ̫Żݣ2ԣרҵ3ԣרҵͶߣ4ԣʾ̫ʹ̫Ż飩   
		TDAStringType		HkexIsOverMaxTerminal;				// Ƿ񳬹ն:0:δ,0      
		TDAStringType		HkexOverMoney;						// ۽նշ      
		TDAStringType		CanTradeStockAU;					// ǷɽװĹ      
		TDAStringType		NyFlag;								// Դʾ
	};
	// ûǳ
	struct CStockReqUserLogoutField
	{
		TDAStringType		UserId;								// ûʶ
		TDAStringType		AccountNo;							// ʽ˺
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// 
	struct CStockReqOrderInsertField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		LocalNo;							// APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ContractCode;						// Լ
																// Contract code 

		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		// ֻƽ:
				// STOCK_OPEN_POS_FLAG=,STOCK_OPEN_POS_FLAG=ƽ
		// open/close position flag:
				// STOCK_OPEN_POS_FLAG=open position,STOCK_CLOSE_POS_FLAG=close position
		TDAStringType		OpenCloseFlag;

		TDAStringType		OrderQty;							// µ
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		TriggerPrice;						// ۸
																// Trigger price

		// Ч:
		//		STOCKE_TDY_TIF=Ч, STOCK_GTC_TIF=ЧGTCSTOCK_OPG_TIF=OPG,STOCK_IOC_TIF4=IOC
		//		STOCK_FOK_TIF=FOKSTOCK_GTD_TIF=GTDSTOCK_ATC_TIF=ATCSTOCK_FAK_TIF=FAK
		// Order time in force:
		//		STOCK_TDY_TIF=the day only,STOCK_GTC_TIF=GTC,STOCK_OPG_TIF=OPG,STOCK_IOC_TIF=IOC
		//		STOCK_FOK_TIF=FOK,STOCK_GTD_TIF=GTD,STOCK_ATC_TIF=ATC,STOCK_FAK_TIF=FAK						
		TDAStringType		TIF;

		TDAStringType		StrategyId;							// ID 20130726 add
																// Strategy id

		TDAStringType		MaxShow;							// ɽʾ
																// Max show quantity for ICE order		

		TDAStringType		MinQty;								// FAK/FOKСɽ
																// Min filled quantity expected by FAK/FOK order

		TDAStringType		ErrorDescription;					// Ϣ
																// Error message description
	};
	// 
	struct CStockRspOrderInsertField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		SystemNo;							// ϵͳ
																// System No	

		TDAStringType		LocalNo;							// ر APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
																// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

		TDAStringType		ExchangeCode;						// 
																// Exchange code	

		TDAStringType		ContractCode;						// Լ
																// Contract code
		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		TDAStringType		OrderQty;							// µ
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price	

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		OrderDate;							// µ
																// Order date

		TDAStringType		OrderTime;							// µʱ
																// Order time

		TDAStringType		ErrorCode;							// 
																// Error code
		// ״̬:
		//		STOCK_ORDER_STATE1=  STOCK_ORDER_STATE2=Ŷӣ  STOCK_ORDER_STATE3=ֳɽ
		//		STOCK_ORDER_STATE4=ȫɽSTOCK_ORDER_STATE5=ѳ൥STOCK_ORDER_STATE6=ѳ
		//		STOCK_ORDER_STATE7=ָʧܣSTOCK_ORDER_STATE8=ͳ  STOCK_ORDER_STATE9=ģ
		//		STOCK_ORDER_STATEA=
		// Order state:
		//		STOCK_ORDER_STATE1=requested 
		//		STOCK_ORDER_STATE2=be queuing  
		//		STOCK_ORDER_STATE3=some orders were closed  
		//		STOCK_ORDER_STATE4=full order  
		//		STOCK_ORDER_STATE5=the remaining order has been cancelled
		//		STOCK_ORDER_STATE6=order has been cancelled  
		//		STOCK_ORDER_STATE7=command failure 
		//		STOCK_ORDER_STATE8=the command is waiting to be sent 
		//		STOCK_ORDER_STATE9=the command is waiting to be changed 
		//		STOCK_ORDER_STATEA=the command is waiting to be cancelled
		TDAStringType		OrderState;

		TDAStringType		TriggerPrice;						// ۸
																// Trigger price
		// Ч:
		//		STOCKE_TDY_TIF=Ч, STOCK_GTC_TIF=ЧGTCSTOCK_OPG_TIF=OPG,STOCK_IOC_TIF4=IOC
		//		STOCK_FOK_TIF=FOKSTOCK_GTD_TIF=GTDSTOCK_ATC_TIF=ATCSTOCK_FAK_TIF=FAK
		// Order time in force:
		//		STOCK_TDY_TIF=the day only,STOCK_GTC_TIF=GTC,STOCK_OPG_TIF=OPG,STOCK_IOC_TIF=IOC
		//		STOCK_FOK_TIF=FOK,STOCK_GTD_TIF=GTD,STOCK_ATC_TIF=ATC,STOCK_FAK_TIF=FAK	
		TDAStringType		TIF;

		// ֻƽ:
			// STOCK_OPEN_POS_FLAG=,STOCK_OPEN_POS_FLAG=ƽ
		// open/close position flag:
			// STOCK_OPEN_POS_FLAG=open position,STOCK_CLOSE_POS_FLAG=close position
		TDAStringType		OpenCloseFlag;

		TDAStringType		StrategyId;							// ID 20130726 add
																// Strategy id	

		TDAStringType		MaxShow;							// ɽʾ
																// Max show quantity for ICE order

		TDAStringType		MinQty;								// FAK/FOKСɽ 
																// Min filled quantity expected by FAK/FOK order

		TDAStringType		ExchangeTime;						// ʱ
																// Exchange time

	};
	// ޸Ķ
	struct CStockReqOrderModifyField
	{
		TDAStringType		SystemNo;							// ϵͳ
																// System No

		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		LocalNo;							// APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		OrderNo;							// 
																// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ContractCode;						// Լ
																// Contract code

		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		TDAStringType		OrderQty;							//  
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price

		TDAStringType		ModifyQty;							// ĵ 
																// Modify quantity

		TDAStringType		ModifyPrice;						// ĵ۸
																// Modify price

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		TriggerPrice;						// ۸
																// Trigger price

		TDAStringType		ModifyTriggerPrice;					// ĵ۸
																// Modify trigger price

		// Ч:
		//		STOCKE_TDY_TIF=Ч, STOCK_GTC_TIF=ЧGTCSTOCK_OPG_TIF=OPG,STOCK_IOC_TIF4=IOC
		//		STOCK_FOK_TIF=FOKSTOCK_GTD_TIF=GTDSTOCK_ATC_TIF=ATCSTOCK_FAK_TIF=FAK
		// Order time in force:
		//		STOCK_TDY_TIF=the day only,STOCK_GTC_TIF=GTC,STOCK_OPG_TIF=OPG,STOCK_IOC_TIF=IOC
		//		STOCK_FOK_TIF=FOK,STOCK_GTD_TIF=GTD,STOCK_ATC_TIF=ATC,STOCK_FAK_TIF=FAK	
		TDAStringType		TIF;

		TDAStringType		ErrorDescription;					// Ϣ
																// Error description
	};
	// ޸Ķ
	typedef CStockRspOrderInsertField CStockRspOrderModifyField;
	// 
	struct CStockReqOrderCancelField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		LocalNo;							// APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		SystemNo;							// ϵͳ
																// System No

		TDAStringType		OrderNo;							// 
																// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ContractCode;						// Լ
																// Contract code

		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		TDAStringType		OrderQty;							// µ
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		ErrorDescription;					// Ϣ
																// Error message description
	};
	// 
	struct CStockRspOrderCancelField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		SystemNo;							// ϵͳ
																// System No

		TDAStringType		LocalNo;							// ر APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
																// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

		TDAStringType		CancelNo;							// 
																// Cancel order No

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ContractCode;						// Լ
																// Contract code

		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		TDAStringType		OrderQty;							// µ
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price

		TDAStringType		FilledQty;							// ѳɽ
																// Filled quantity (The number of orders has been completed)

		TDAStringType		CancelledQty;						// ѳ
																// Cancelled quantity

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		CancelledDate;						// 
																// Cancelled date

		TDAStringType		CancelledTime;						// ʱ
																// Cancelled time

		TDAStringType		ErrorCode;							//  -----ΪŶ״̬12Ŷӣ3ֳɽ4ȫɽ5ѳ൥6ѳ7ָʧܣ8ͳ9ģ10
																// Error code
	};
	// ޸
	struct CStockReqPasswordUpdateField
	{
		TDAStringType		UserId;								// û
		TDAStringType		OldPassword;						// ûԭ
		TDAStringType		NewPassword;						// û
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ޸뷵
	struct CStockRspPasswordUpdateField
	{
		TDAStringType		UserId;								// û
		TDAStringType		OldPassword;						// ûԭ
		TDAStringType		NewPassword;						// û
	};
	// ѯ
	struct CStockQryOrderField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		// ǷģûSTOCK_IS_SIMULATED_USER=ǣSTOCK_IS_NOT_SIMULATED_USER or other
		//Simulated user:
		//		STOCK_IS_SIMULATED_USER=is a simulated user
		//		STOCK_IS_NOT_SIMULATED_USER or other = is not a simulated user
		TDAStringType		IsSimulation;

		TDAStringType		OrderNo;							// ȡָԺĶ
																// Obtain a subsequent order with the specified order number

		TDAStringType		OrderDateTime;						// ȡָʱԺĶʽyyyy-MM-dd hh:mm:ss
																// Obtain orders after the specified order timeformatyyyy-MM-dd hh:mm:ss

		TDAStringType		ErrorDescription;					// Ϣ
																// Error description
	};
	// ѯ
	struct CStockRspOrderField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		AccountNo;							// ʽ˺
																// Account No

		TDAStringType		SystemNo;							// ϵͳ
																// System No

		TDAStringType		LocalNo;							// APIûĳָıض
																// Order ID assigned by API user program

		TDAStringType		OrderNo;							//  ϵͳĶţLocalNo:SystemNo:OrderNoһһһĹϵ
																// The order number given by the exchange system ,LocalNo:SystemNo:OrderNo,these three are one-to-one relationships

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ContractCode;						// Լ
																// Contract code

		// :		STOCK_BID=,  STOCK_ASK=
		// Bid or ask:		STOCK_BID=bid, STOCK_ASK=ask
		TDAStringType		BidAskFlag;

		TDAStringType		OrderQty;							// µ
																// Order quantity

		TDAStringType		OrderPrice;							// µ۸
																// Order price

		TDAStringType		FilledQty;							// ѳɽ
																// Filled quantity (The number of orders has been completed)

		TDAStringType		FilledPrice;						// ɽ
																// Filled price(Average transaction price)

		// ͣ
		//		STOCK_LIMIT_ORDER=޼۵, STOCK_MARKET_ORDER=м۵
		//		STOCK_LIMIT_STOP_ORDER=޼ֹSTOCK_STOP_LOSS_ORDER=ֹ	
		// Order type:
		//		STOCK_LIMIT_ORDER=limit order, STOCK_MARKET_ORDER=market order 
		//		STOCK_LIMIT_STOP_ORDER=limit stop order ,STOCK_STOP_LOSS_ORDER=stop loss order
		TDAStringType		OrderType;

		TDAStringType		OrderDate;							// µ
																// Order date

		TDAStringType		OrderTime;							// µʱ
																// Order time

		TDAStringType		ErrorCode;							// 
																// Error code

		// ״̬:
		//		STOCK_ORDER_STATE1=  STOCK_ORDER_STATE2=Ŷӣ  STOCK_ORDER_STATE3=ֳɽ
		//		STOCK_ORDER_STATE4=ȫɽSTOCK_ORDER_STATE5=ѳ൥STOCK_ORDER_STATE6=ѳ
		//		STOCK_ORDER_STATE7=ָʧܣSTOCK_ORDER_STATE8=ͳ  STOCK_ORDER_STATE9=ģ
		//		STOCK_ORDER_STATEA=
		// Order state:
		//		STOCK_ORDER_STATE1=requested 
		//		STOCK_ORDER_STATE2=be queuing  
		//		STOCK_ORDER_STATE3=some orders were closed  
		//		STOCK_ORDER_STATE4=full order  
		//		STOCK_ORDER_STATE5=the remaining order has been cancelled
		//		STOCK_ORDER_STATE6=order has been cancelled  
		//		STOCK_ORDER_STATE7=command failure 
		//		STOCK_ORDER_STATE8=the command is waiting to be sent 
		//		STOCK_ORDER_STATE9=the command is waiting to be changed 
		//		STOCK_ORDER_STATEA=the command is waiting to be cancelled
		TDAStringType		OrderState;

		TDAStringType		CancelUserId;						// ûʶ
																// User id of cancel order

		TDAStringType		TriggerPrice;						// ۸
																// Trigger price

		// Ч:
		//		STOCK_TDY_TIF=Ч, STOCK_GTC_TIF=ЧGTCSTOCK_OPG_TIF=OPG,STOCK_IOC_TIF4=IOC
		//		STOCK_FOK_TIF=FOKSTOCK_GTD_TIF=GTDSTOCK_ATC_TIF=ATCSTOCK_FAK_TIF=FAK
		// Order time in force:
		//		STOCK_TDY_TIF=the day only,STOCK_GTC_TIF=GTC,STOCK_OPG_TIF=OPG,STOCK_IOC_TIF=IOC
		//		STOCK_FOK_TIF=FOK,STOCK_GTD_TIF=GTD,STOCK_ATC_TIF=ATC,STOCK_FAK_TIF=FAK		
		TDAStringType		TIF;

		// ֻƽ:
		//		STOCK_OPEN_POS_FLAG=,STOCK_OPEN_POS_FLAG=ƽ
		// open/close position flag:
		//		STOCK_OPEN_POS_FLAG=open position,STOCK_CLOSE_POS_FLAG=close position
		TDAStringType		OpenCloseFlag;

		TDAStringType		StrategyId;							// ID 20130726 add
																// Strategy id

		TDAStringType		MaxShow;							// ɽʾ
																// Max show quantity for ICE order

		TDAStringType		MinQty;								// FAK/FOKСɽ 
																// Min filled quantity expected by FAK/FOK order

		TDAStringType		ExchangeTime;						// ʱ
																// Exchange time

		TDAStringType		CancelTime;							// ʱ
																// Cancel time
	};
	// ѯɽ
	struct CStockQryTradeField
	{
		TDAStringType		UserId;								// û		
		TDAStringType		ErrorDescription;					// Ϣ
		TDAStringType		lastFilledNo;						//ѯһûɽ update 2020.04.30 ywh
	};
	// ѯɽ
	struct CStockRspTradeField
	{
		TDAStringType		UserId;								// ûʶ
		TDAStringType		AccountNo;							// ʽ˺
		TDAStringType		FilledNo;							// ɽţҪ7λĶţһ11λ
		TDAStringType		OrderNo;							// 
		TDAStringType		SystemNo;							// ϵͳ
		TDAStringType		LocalNo;							// ر
		TDAStringType		ExchangeCode;						// 
		TDAStringType		TreatyCode;							// Լ
		TDAStringType		BuySale;							// 1=buy 2=sell
		TDAStringType		FilledNumber;						// ɽ
		TDAStringType		FilledPrice;						// ɽ۸
		TDAStringType		FilledDate;							// ɽ(yyyy-MM-dd)
		TDAStringType		FilledTime;							// ɽʱ(hh:mm:ss)
		TDAStringType		Commsion;							// ɽ
		TDAStringType		OrderNumber;						// ί
		TDAStringType		OrderPrice;							// ίм۸
		TDAStringType		DeliveryDate;						// Լ(yyyyMMdd)
		TDAStringType		FilledType;							// ɽ(NͨµɽCTģɽ)
		TDAStringType		OrderType;							// ͣ1=޼۵, 2=м۵3=޼ֹstop to limit4=ֹstop to market
		TDAStringType		ValidDate;							// Чڣ1=Ч, 2=Ч
		TDAStringType		AddReduce;							// ֻƽ֣1= 2=ƽ֣3=ƽ4=ƽ
		TDAStringType		ExchangeTime;						// ʱ(yyyy-MM-dd hh24:mm:ss) 20151214 add
		TDAStringType		SubClientNo;						// ˻
		TDAStringType		FillBrokerList;						// ۹УɽʱԵõɽľ̴
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯԼ
	struct CStockQryInstrumentField
	{
		TDAIntType			PageIndex;							// ѯ,ÿηص
		TDAStringType       ExchangeNo;							// 룬дֵѯһĺԼ
		TDAStringType		ModifyDay;							// Լ,ѯ ʽ("20200101")
		TDAStringType		ErrorDescription;					// Ϣ
		
	};
	// ѯԼ
	struct CStockRspInstrumentField
	{
		TDAStringType		ExchangeNo;							//  
		TDAStringType		ExchangeName;						//  
		TDAStringType		CommodityNo;						// ԼNO
		TDAStringType		CommodityName;						// Ʒ 
		TDAStringType		CommodityType;						// Ʒ 
		TDAStringType		CurrencyNo;							// ұ 
		TDAStringType		CurrencyName;						//  
		TDADoubleType		ProductDot;							// ֵһСļֵ   
		TDADoubleType		UpperTick;							// С䶯λ 
		TDADoubleType		SettlePrice;						// ս 
		TDAStringType		TradeMonth;							//  (yyyyMM)/ (yyyyMMdd)
		TDAIntType			DotNum;								// Сλ
		TDAIntType			LowerTick;							// ׵λ
		TDAIntType			DotNumCarry;						// Сλ
		TDADoubleType		UpperTickCarry;						// С䶯λ
		TDAStringType		FirstNoticeDay;						// ״֪ͨ (yyyyMMdd)
		TDADoubleType		FreezenPercent;						// ᱣ֤ٷֱ 
		TDADoubleType		FreezenMoney;						// ᱣ̶ֵ֤ 
		TDADoubleType		FeeMoney;							// ̶ 
		TDADoubleType		FeePercent;							// ٷֱ 
		TDADoubleType		PriceStrike;						// ֻƷ 
		TDADoubleType		ProductDotStrike;					// ֻƷֵ  
		TDADoubleType		UpperTickStrike;					// ֻƷС䶯λ 
		TDAStringType		LastTradeDay;						//  (yyyyMMdd)(ڻר)
		TDAStringType		LastUpdateDay;						//  (yyyyMMdd)(ڻר)
		TDADoubleType		CriticalPrice;						// Ȩٽ۸ (ڻר)
		TDADoubleType		CriticalMinChangedPrice;			// Ȩٽ۸µС (ڻר)
		TDAStringType		ExchangeSub;						// ʵʽ(CMEϸֳ3:CME,CME_COMEX,CME_NYMEX)(ڻר)
		TDAStringType		OptionType;							// Ȩ(RǣF)(ڻר)
		TDAStringType		OptionMonth;						// Ȩ(yyyyMM)(ڻר)
		TDAStringType		OptionStrikePrice;					// Ȩִм۸(ڻר)
		TDAStringType		OptionCommodityNo;					// ȨӦڻƷ(ڻר)
		TDAStringType		OptionContractNo;					// ȨӦڻԼ(ڻר)
		TDAStringType		MortgagePercent;					// Ҽֵٷֱ
		TDAStringType		UpperTickCode;						// С䶯λ
		TDAStringType		LotSize;							// С
		TDAStringType		FlatTime;							// ƽʱ־(T+10T+0Եƽ֣1T+1ƽ֣NT+N)
		TDAStringType		CommodityFNameEN;					// ƷӢģ
		TDAStringType		CanSell;							// Ƿ֧գ0գԣ1ԣ
		TDADoubleType		SellRate;							// ʱİ0.5
		TDADoubleType		SellMax;							// ճֲ޶
		TDADoubleType		StrikeRate;							// ɱʣʾһţ^൱ڶ
		TDADoubleType		StrikePrice;						// ʹ
		TDADoubleType		ReceivePrice;						// ջؼ
		TDAStringType		ExpireDate;							// գyyyy-MM-dd
		TDADoubleType		SellRateKeep;						// ʱάְ0.5
		TDAStringType		StrikeCommodityNo;					// ţ֤Ӧɱ
		TDAStringType		CallPutFlag;						// ţ֤ǵ־(C:ǣP:)
		TDAStringType		Publisher;							// ţ֤ķ
	};
	// ѯ
	struct CStockQryExchangeField
	{
		TDAStringType		ProductGroupID;
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯ
	struct CStockRspExchangeField
	{
		TDAStringType		ExchangeNo;							// 
		TDAStringType		ExchangeName;						// 
		TDAStringType		SettleType;							// ͣHK۹ɣUSɣ
		TDAStringType 		NameEN;								// ƣӢģ
	};
	// ѯʽ
	struct CStockQryCapitalField
	{
		TDACharType			Unused;								// ʹ	
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯʽ𷵻
	// Query fund return struct
	struct CStockRspCapitalField
	{
		TDAStringType		UserId;								// ûʶ
																// User id

		TDAStringType		Deposit;							// 
																// Deposit

		TDAStringType		Withdraw;							// 
																// Withdraw

		TDAStringType		TodayTradableFund;					// ɣã£տڽ׵ʽ
																// Today tradable fund amount

		TDAStringType		TodayInitialBalance;				// ɣ棻£ڳȨ
																// today inital balance

		TDAStringType		TodayRealtimeBalance;				// ɣȨ棻£ʵʱȨ
																// today realtime floating balance with Profit&Loss

		TDAStringType		FrozenFund;							// ʽ
																// Frozen fund

		TDAStringType		Commission;							// Ӷ
																// Commission

		TDAStringType		InitialMargin;						// ɣ֤£ʼ֤
																// Initial margin

		TDAStringType		YdTradableFund;						// ɣã£տڽ׵ʽ
																// Yesterday tradable fund amount

		TDAStringType		YdInitialBalance;					// ɣ棻£ڳȨ
																// Yesterday inital balance

		TDAStringType		YdFinalBalance;						// ɣȨ棻£ĩȨ
																// Yesterday final balance with Profit&Loss

		TDAStringType		ProfitLoss;							// ӯ
																// Profit and loss

		TDAStringType		CurrencyNo;							// ֱ 
																// Currency No

		TDAMoneyType		CurrencyRate;						// Ļ
																//  Currency rate

		TDAMoneyType		LMEUnexpiredPL;						// LMEδƽӯ
																// LME unexpired profit&losss

		TDAMoneyType		LMEUnaccountPL;						// LMEδƽӯ
																// LME unaccounting profit&losss

		TDAMoneyType		MaintenanceMargin;					// άֱ֤
																// Maintenance margin

		TDAMoneyType		Premium;							// ȨȨ
																// Premium for options

		TDAMoneyType		CreditAmount;						// ζ
																// Credit amount

		TDAMoneyType		IntialFund;							// ʼʽ
																// Intial fund

		TDAStringType		FundAccountNo;						// ʽʺ 
																// Fund account No

		TDAMoneyType		MortgageInMoney;					// Ҽֵ 20150610 added for ۹
																// Mortgage in money(add for HK stock)

		TDAMoneyType		MarginLimit;						// Iչ޶ 20150727 added for ۹
																// Margin limit(add for Hk stock)

		TDAMoneyType		BorrowInMoney;						// ֵ 20150727 added for ۹
																// Borrow in money

		TDAMoneyType		T1DeliveryMoney;					// T1սʽ븺
																// T1 day delivery of funds, positive in negative out

		TDAMoneyType		T2DeliveryMoney;					// T2 սʽ븺
																// T2 day delivery of funds, positive in negative out

		TDAMoneyType		T3DeliveryMoney;					// T3 սʽ븺
																// T3 day delivery of funds, positive in negative out

		TDAMoneyType		TNDeliveryMoney;					// TN սʽ븺
																// TN day delivery of funds, positive in negative out

		TDAMoneyType		TradeLimit;							// ޶
																// Trade limit

		TDAMoneyType		CanCashOutMoneyAmount;				// ȡʽ
																// Can cash out money amount

		TDAMoneyType		DepositInterest;					// ´Ϣ
																// Monthly deposit interest

		TDAMoneyType		LoanInterest;						// ǷϢ
																// Monthly loan interest

		TDAMoneyType		CrossCurrencyMaxMoneyAmt;			// гʽ޶
																// Cross-market capital limits

		TDAMoneyType		SellShortFrozenMoney;				// նʽ
																// Short sale frozen funds

		TDAMoneyType		SellShortInterest;					// Ϣ
																// Short sale interest

		TDAMoneyType		ShortPosAddtionalMargin;			// 貹
																// Short position addtional margin

		TDAStringType		ErrorDescription;					// Ϣ
																// Error description
	};
	// ѯֲ
	struct CStockQryPositionField
	{
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯֲַ
	struct CStockRspPositionField
	{
		TDAStringType		ClientNo;							// ûʶ
																// Client No

		TDAStringType		ExchangeCode;						// 
																// Exchange code

		TDAStringType		ProductCode;						// ֤ȯ
																// Product code
		// ֲַ:
		// STOCK_POSITION_FLAG_LONG=STOCK_POSITION_FLAG_SHORT=
		// The position direction flag:
		// STOCK_POSITION_FLAG_LONG=long position,STOCK_POSITION_FLAG_SHORT=short position
		TDAStringType		LongShortPosFlag;

		TDADoubleType		PosCostPrice;						// ֲֳɱ
																// Position at cost

		TDAIntType			CanSellShares;						// 
																// Can sell shares

		TDAIntType			TodayBuyShares;						// 
																// Today buy shares

		TDAIntType			FrosenShares;						// 
																// Frosen shares

		TDADoubleType		TotalBuyMoney;						// ܺ
																// Total amount of purchase during the holding period

		TDADoubleType		TotalSellMoney;						// ܺ
																// Total amount sold during the holding period

		TDAIntType			TotalBuyShares;						// ܹ
																// Total number of shares bought during the holding period

		TDAIntType			TotalSellShares;					// ܹ
																// Total number of shares sold during the holding period

		TDAStringType		FirstPosDate;						// ״ο(yyyy-MM-dd)
																// Date of first opening(yyyy-MM-dd)

		TDADoubleType		ClosePosPL;							// ƽӯ
																// Closing position profit

		TDAIntType			T1DeliveryShares;					// T1ս븺
																// T1 day delivery of shares, positive in negative out

		TDAIntType			T2DeliveryShares;					// T2ս븺
																// T2 day delivery of shares, positive in negative out

		TDAIntType			T3DeliveryShares;					// T3ս븺
																// T3 day delivery of shares, positive in negative out

		TDAIntType			NotDeliveryShares;					// δ=T1DeliveryShares+T2DeliveryShares+T3DeliveryShares
																// Number of outstanding shares=T1DeliveryShares+T2DeliveryShares+T3DeliveryShares

		TDAIntType			DeliveredShares;					// ѽ
																// Number of shares delivered

		TDAIntType			SellShortShares;					// չ
																// Short the number of shares

		TDADoubleType		SellShortMoney;						// նʽ
																// Short sale frozen funds

		TDADoubleType		SSPosAvgCostPrice;					// ղλĿ־
																// The average opening price of a short position
	};
	// ѯ
	struct CStockQryTickField
	{
		TDACharType			Unused;								// ʹ
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯ㷵
	struct CStockRspTickField
	{
		TDAStringType		UpperTickCode;						// С䶯λ
		TDAStringType		PriceFrom;							// С䶯λʼ۸
		TDAStringType		UpperTick;							// С䶯λ
		TDAStringType		ProductDot;							// С䶯λӦĵֵ
		TDAStringType		DotNum;								// Сλ
		TDAStringType		LowerTick;							// ۵λ
	};
	// ѯ
	struct CStockQryCurrencyField
	{
		TDACharType			Unused;								// ʹ
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯҷ
	struct CStockRspCurrencyField
	{
		TDAStringType		CurrencyNo;							// ұ
		TDAIntType			IsBase;								// һұ
		TDADoubleType		ChangeRate;							// ҵĻ
		TDAStringType		CurrencyName;						// 
		TDAStringType		CurrencyNameEN;						// ƣӢģ
	};
	// ѯ汾
	struct CStockQryVersionField
	{
		TDAStringType		UserId;								// ûʶ
		TDAStringType		UserPwd;							// û
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ѯ汾
	struct CStockRspVersionField
	{
		TDAStringType		Version;							// 汾
		TDAStringType		MustUpdate;							// Ƿµ°汾ʹã0Բ£1£
		TDAStringType		MustVersion;						// Ҫİ汾
		TDAStringType		VersionContent_CN;					// 汾
		TDAStringType		VersionContent_US;					// 汾Ӣ
	};
	//-------------------------------------------------------------------------
	// Ͷ仯
	struct CStockRtnOrderField
	{
		TDAStringType		LocalOrderNo;						// ض
		TDAStringType		ExchangeNo;							// 
		TDAStringType		TreatyCode;							// Լ
		TDAStringType		OrderNo;							// 
		TDAIntType			OrderNumber;						// ί
		TDAIntType			FilledNumber;						// ѳɽ
		TDAPriceType		FilledAdvPrice;						// ɽ
		TDAIntType			BuyHoldNumber;						// 
		TDAPriceType		BuyHoldOpenPrice;					// 򿪲־
		TDAPriceType		BuyHoldPrice;						// 
		TDAIntType			SaleHoldNumber;						// 
		TDAPriceType		SaleHoldOpenPrice;					// ־
		TDAPriceType		SaleHoldPrice;						// 
		TDAStringType		IsCanceled;							// ǷѾ0ûУ1ѳ
		TDAPriceType		FilledTotalFee;						// ɽܵ
		TDAIntType			Status;								// ˳
		TDAStringType		AccountNo;							// ʽʺ
		TDAStringType		HoldType;							// ֲͣ0֣1֣
		TDAPriceType		HoldMarginBuy;						// ֤
		TDAPriceType		HoldMarginSale;						// ֤
		TDAPriceType		CurrPrice;							// ¼
		TDAPriceType		FloatProfit;						// ӯ
	};
	// ʽ仯
	struct CStockRtnCapitalField
	{
		TDAStringType		ClientNo;							// ͻ
		TDAStringType		AccountNo;							// ʽʺ
		TDAStringType		CurrencyNo;							// 
		TDAPriceType		Available;							// 
		TDAPriceType		YAvailable;							// 
		TDAPriceType		CanCashOut;							// ɳ
		TDAPriceType		Money;								// 
		TDAPriceType		ExpiredProfit;						// ƽӯ
		TDAPriceType		FrozenDeposit;						// ʽ
		TDAPriceType		Fee;								// 
		TDAPriceType		Deposit;							// ֤
		TDAPriceType		KeepDeposit;						// άֱ֤
		TDAIntType			Status;								// ״̬
		TDAPriceType		InMoney;							// 
		TDAPriceType		OutMoney;							// 
		TDAPriceType		UnexpiredProfit;					// δƽӯ
		TDAPriceType		TodayTotal;							// Ȩ
		TDAPriceType		UnaccountProfit;					// δƽӯ
		TDAPriceType		Royalty;							// ȨȨ
		TDAStringType		ExchangeNo;							// 
		TDAStringType		TreatyCode;							// Լ
		TDAStringType		OrderNo;							// 
		TDAIntType			OrderNumber;						// ί
		TDAIntType			FilledNumber;						// ѳɽ
		TDAPriceType		FilledAdvPrice;						// ɽ
		TDAIntType			BuyHoldNumber;						// 
		TDAPriceType		BuyHoldOpenPrice;					// 򿪲־
		TDAPriceType		BuyHoldPrice;						// 
		TDAIntType			SaleHoldNumber;						// 
		TDAPriceType		SaleHoldOpenPrice;					// ־
		TDAPriceType		SaleHoldPrice;						// 
		TDAStringType		IsCanceled;							// ǷѾ0ûУ1ѳ
		TDAPriceType		FilledTotalFee;						// ɽܵ
		TDAPriceType		Credit;								// ζ
		TDAPriceType		MarginLimit;						// Iչ޶ 20150727 added for ۹
		TDAPriceType		BorrowValue;						// ֵ 20150727 added for ۹
		TDAPriceType		MortgageMoney;						// Ҽֵ 20150727 added for ۹
		TDAPriceType		T1;									// T1 20160219 added for ۹
		TDAPriceType		T2;									// T2 20160219 added for ۹
		TDAPriceType		T3;									// T3 20160219 added for ۹
		TDAPriceType		TN;									// Tn 20160219 added for ۹
		TDAPriceType		TradeLimit;							// ޶
		TDAPriceType		FCrossMax;							// гʽ޶
		TDAPriceType		SellFreezenMoney;					// նʽ
		TDAPriceType		SellInterest;						// Ϣ
		TDAPriceType		SellNeedAddMargin;					// 貹
	};
	// ͳֱֲ仯
	typedef CStockRspPositionField CStockRtnPositionField;
	// ͳɽ
	typedef CStockRspTradeField	CStockRtnTradeField;
	//-------------------------------------------------------------------------
	// ȡ
	struct CStockReqGetQuestionField
	{
		TDAIntType			Unused;								// ûʺ
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ȡⷵ
	struct CStockRspQuestionField
	{
		TDAStringType		QuestionType;						// 	0ڻ1ʹƱ
		TDAStringType		QuestionId;							// 
		TDAStringType		QuestionCN;							// ⣨ģ
		TDAStringType		QuestionEN;							// ⣨Ӣģ
	};
	// ȫ֤
	struct CStockReqSafeVerifyField
	{
		TDAStringType		UserId;								// ûʺ
		TDAStringType		UserPwd;							// 
		TDAStringType		Type;								// 
		TDAStringType		Question;							// ܱ
		TDAStringType		Answer;								// ܱ
		TDAStringType		MobileNumber;						// ֻ
		TDAStringType		VerifyCode;							// ֻ֤
		TDAStringType		SaveMac;							// ǷҪס豸
		TDAStringType		MacAddress;							// MACַ
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ֤
	struct CStockReqSetVerifyQAField
	{
		TDAStringType		UserId;								// ûʺ
		TDAStringType		UserPwd;							// 
		TDAStringType		Type;								// 
		TDAStringType		Question;							// ܱ
		TDAStringType		Answer;								// ܱ
		TDAStringType		MobileNumber;						// ֻ
		TDAStringType		VerifyCode;							// ֻ֤
		TDAStringType		SaveMac;							// ǷҪס豸
		TDAStringType		ErrorDescription;					// Ϣ
	};
	// ֤
	struct CStockReqVerifyCodeField
	{
		TDAStringType		UserId;								// ûʺ
		TDAStringType		UserPwd;							// 
		TDAStringType		Type;								// 
		TDAStringType		Question;							// ܱ
		TDAStringType		Answer;								// ܱ
		TDAStringType		MobileNumber;						// ֻ
		TDAStringType		VerifyCode;							// ֻ֤
		TDAStringType		ErrorDescription;					// Ϣ
	};

}