"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const base_edge_construct_1 = require("./base-edge-construct");
class EdgeRole extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.role = new aws_iam_1.Role(this.edgeStack, id, {
            assumedBy: new aws_iam_1.CompositePrincipal(new aws_iam_1.ServicePrincipal('edgelambda.amazonaws.com'), new aws_iam_1.ServicePrincipal('lambda.amazonaws.com')),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole')],
            ...props,
        });
    }
    addToEdgeRolePolicy(statement) {
        this.role.addToPolicy(statement);
    }
}
exports.EdgeRole = EdgeRole;
_a = JSII_RTTI_SYMBOL_1;
EdgeRole[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.EdgeRole", version: "1.48.0" };
//# sourceMappingURL=data:application/json;base64,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