# Logs Directory

This directory contains organized log files generated by the Slurm MCP server.

## Structure

```
logs/
├── README.md              # This file
└── slurm_output/          # Slurm job output files
    ├── slurm_*.out        # Job stdout files
    ├── slurm_*.err        # Job stderr files
    └── slurm_*_*.out      # Array job outputs (format: slurm_<array_id>_<task_id>.out)
```

## File Naming Convention

- **Single Jobs**: `slurm_<job_id>.out` and `slurm_<job_id>.err`
- **Array Jobs**: `slurm_<array_job_id>_<task_id>.out` and `slurm_<array_job_id>_<task_id>.err`

## Purpose

The Slurm output files are automatically organized here to keep the main project directory clean while maintaining easy access to job outputs for debugging and monitoring.

## Cleanup

To clean up old log files:

```bash
# Remove all output files older than 7 days
find logs/slurm_output/ -name "*.out" -o -name "*.err" -mtime +7 -delete

# Remove all output files
rm -f logs/slurm_output/*.out logs/slurm_output/*.err
```

## Configuration

The output directory is configured in `src/capabilities/slurm_handler.py` in the `_create_sbatch_script()` function.
