"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const sftasks = require("aws-cdk-lib/aws-stepfunctions-tasks");
const sfn = require("aws-cdk-lib/aws-stepfunctions");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
const defaults = require("@aws-solutions-constructs/core");
// Setup the app and stack
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
const functionOne = (0, core_1.deployLambdaFunction)(stack, {
    runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
    handler: 'index.handler',
    code: lambda.Code.fromInline(`exports.handler = async (event) => { console.log("First Function");}`)
}, 'first-function');
const taskOne = new sftasks.LambdaInvoke(stack, 'task-one', {
    lambdaFunction: functionOne,
});
const functionTwo = (0, core_1.deployLambdaFunction)(stack, {
    runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
    handler: 'index.handler',
    code: lambda.Code.fromInline(`exports.handler = async (event) => { console.log("Second Function");}`)
}, 'second-function');
const taskTwo = new sftasks.LambdaInvoke(stack, 'task-two', {
    lambdaFunction: functionTwo,
});
// // Launch the construct
const startState = sfn.DefinitionBody.fromChainable(taskOne.next(taskTwo));
// Setup the pattern props
const props = {
    lambdaFunctionProps: {
        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
        handler: 'index.handler',
        code: lambda.Code.fromAsset(`${__dirname}/lambda`)
    },
    stateMachineProps: {
        definitionBody: startState
    },
    logGroupProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    }
};
// Add the pattern
new lib_1.LambdaToStepfunctions(stack, 'test-lambda-stepfunctions-construct', props);
// Synth the app
new integ_tests_alpha_1.IntegTest(stack, 'Integ', {
    testCases: [
        stack
    ]
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGFtc3RwLXN0YXRlLW1hY2hpbmUtZGVmaW50aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubGFtc3RwLXN0YXRlLW1hY2hpbmUtZGVmaW50aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7QUFFSCxnQkFBZ0I7QUFDaEIsNkNBQXdEO0FBQ3hELGdDQUEyRTtBQUMzRSxpREFBaUQ7QUFDakQsK0RBQStEO0FBQy9ELHFEQUFxRDtBQUNyRCx5REFBOEY7QUFDOUYsa0VBQXVEO0FBQ3ZELDJEQUEyRDtBQUUzRCwwQkFBMEI7QUFDMUIsTUFBTSxHQUFHLEdBQUcsSUFBSSxpQkFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxDQUFDLEdBQUcsRUFBRSxJQUFBLDZCQUFzQixFQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7QUFFakUsTUFBTSxXQUFXLEdBQUcsSUFBQSwyQkFBb0IsRUFBQyxLQUFLLEVBQUU7SUFDOUMsT0FBTyxFQUFFLFFBQVEsQ0FBQyxxQ0FBcUM7SUFDdkQsT0FBTyxFQUFFLGVBQWU7SUFDeEIsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLHNFQUFzRSxDQUFDO0NBQ3JHLEVBQ0QsZ0JBQWdCLENBQUMsQ0FBQztBQUVsQixNQUFNLE9BQU8sR0FBRyxJQUFJLE9BQU8sQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRTtJQUMxRCxjQUFjLEVBQUUsV0FBVztDQUM1QixDQUFDLENBQUM7QUFFSCxNQUFNLFdBQVcsR0FBRyxJQUFBLDJCQUFvQixFQUFDLEtBQUssRUFBRTtJQUM5QyxPQUFPLEVBQUUsUUFBUSxDQUFDLHFDQUFxQztJQUN2RCxPQUFPLEVBQUUsZUFBZTtJQUN4QixJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsdUVBQXVFLENBQUM7Q0FDdEcsRUFDRCxpQkFBaUIsQ0FBQyxDQUFDO0FBRW5CLE1BQU0sT0FBTyxHQUFHLElBQUksT0FBTyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFO0lBQzFELGNBQWMsRUFBRSxXQUFXO0NBQzVCLENBQUMsQ0FBQztBQUVILDBCQUEwQjtBQUMxQixNQUFNLFVBQVUsR0FBRyxHQUFHLENBQUMsY0FBYyxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7QUFFM0UsMEJBQTBCO0FBQzFCLE1BQU0sS0FBSyxHQUErQjtJQUN4QyxtQkFBbUIsRUFBRTtRQUNuQixPQUFPLEVBQUUsUUFBUSxDQUFDLHFDQUFxQztRQUN2RCxPQUFPLEVBQUUsZUFBZTtRQUN4QixJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsR0FBRyxTQUFTLFNBQVMsQ0FBQztLQUNuRDtJQUNELGlCQUFpQixFQUFFO1FBQ2pCLGNBQWMsRUFBRSxVQUFVO0tBQzNCO0lBQ0QsYUFBYSxFQUFFO1FBQ2IsYUFBYSxFQUFFLDJCQUFhLENBQUMsT0FBTztLQUNyQztDQUNGLENBQUM7QUFFRixrQkFBa0I7QUFDbEIsSUFBSSwyQkFBcUIsQ0FBQyxLQUFLLEVBQUUscUNBQXFDLEVBQUUsS0FBSyxDQUFDLENBQUM7QUFFL0UsZ0JBQWdCO0FBQ2hCLElBQUksNkJBQVMsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO0lBQzVCLFNBQVMsRUFBRTtRQUNULEtBQUs7S0FDTjtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqICBMaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpLiBZb3UgbWF5IG5vdCB1c2UgdGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlXG4gKiAgd2l0aCB0aGUgTGljZW5zZS4gQSBjb3B5IG9mIHRoZSBMaWNlbnNlIGlzIGxvY2F0ZWQgYXRcbiAqXG4gKiAgICAgIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqICBvciBpbiB0aGUgJ2xpY2Vuc2UnIGZpbGUgYWNjb21wYW55aW5nIHRoaXMgZmlsZS4gVGhpcyBmaWxlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuICdBUyBJUycgQkFTSVMsIFdJVEhPVVQgV0FSUkFOVElFU1xuICogIE9SIENPTkRJVElPTlMgT0YgQU5ZIEtJTkQsIGV4cHJlc3Mgb3IgaW1wbGllZC4gU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXG4gKiAgYW5kIGxpbWl0YXRpb25zIHVuZGVyIHRoZSBMaWNlbnNlLlxuICovXG5cbi8vLyAhY2RrLWludGVnICpcbmltcG9ydCB7IEFwcCwgU3RhY2ssIFJlbW92YWxQb2xpY3kgfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IExhbWJkYVRvU3RlcGZ1bmN0aW9ucywgTGFtYmRhVG9TdGVwZnVuY3Rpb25zUHJvcHMgfSBmcm9tIFwiLi4vbGliXCI7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnYXdzLWNkay1saWIvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzZnRhc2tzIGZyb20gJ2F3cy1jZGstbGliL2F3cy1zdGVwZnVuY3Rpb25zLXRhc2tzJztcbmltcG9ydCAqIGFzIHNmbiBmcm9tICdhd3MtY2RrLWxpYi9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyBnZW5lcmF0ZUludGVnU3RhY2tOYW1lLCBkZXBsb3lMYW1iZGFGdW5jdGlvbiB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBJbnRlZ1Rlc3QgfSBmcm9tICdAYXdzLWNkay9pbnRlZy10ZXN0cy1hbHBoYSc7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmUnO1xuXG4vLyBTZXR1cCB0aGUgYXBwIGFuZCBzdGFja1xuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBnZW5lcmF0ZUludGVnU3RhY2tOYW1lKF9fZmlsZW5hbWUpKTtcblxuY29uc3QgZnVuY3Rpb25PbmUgPSBkZXBsb3lMYW1iZGFGdW5jdGlvbihzdGFjaywge1xuICBydW50aW1lOiBkZWZhdWx0cy5DT01NRVJDSUFMX1JFR0lPTl9MQU1CREFfTk9ERV9SVU5USU1FLFxuICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21JbmxpbmUoYGV4cG9ydHMuaGFuZGxlciA9IGFzeW5jIChldmVudCkgPT4geyBjb25zb2xlLmxvZyhcIkZpcnN0IEZ1bmN0aW9uXCIpO31gKVxufSxcbidmaXJzdC1mdW5jdGlvbicpO1xuXG5jb25zdCB0YXNrT25lID0gbmV3IHNmdGFza3MuTGFtYmRhSW52b2tlKHN0YWNrLCAndGFzay1vbmUnLCB7XG4gIGxhbWJkYUZ1bmN0aW9uOiBmdW5jdGlvbk9uZSxcbn0pO1xuXG5jb25zdCBmdW5jdGlvblR3byA9IGRlcGxveUxhbWJkYUZ1bmN0aW9uKHN0YWNrLCB7XG4gIHJ1bnRpbWU6IGRlZmF1bHRzLkNPTU1FUkNJQUxfUkVHSU9OX0xBTUJEQV9OT0RFX1JVTlRJTUUsXG4gIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUlubGluZShgZXhwb3J0cy5oYW5kbGVyID0gYXN5bmMgKGV2ZW50KSA9PiB7IGNvbnNvbGUubG9nKFwiU2Vjb25kIEZ1bmN0aW9uXCIpO31gKVxufSxcbidzZWNvbmQtZnVuY3Rpb24nKTtcblxuY29uc3QgdGFza1R3byA9IG5ldyBzZnRhc2tzLkxhbWJkYUludm9rZShzdGFjaywgJ3Rhc2stdHdvJywge1xuICBsYW1iZGFGdW5jdGlvbjogZnVuY3Rpb25Ud28sXG59KTtcblxuLy8gLy8gTGF1bmNoIHRoZSBjb25zdHJ1Y3RcbmNvbnN0IHN0YXJ0U3RhdGUgPSBzZm4uRGVmaW5pdGlvbkJvZHkuZnJvbUNoYWluYWJsZSh0YXNrT25lLm5leHQodGFza1R3bykpO1xuXG4vLyBTZXR1cCB0aGUgcGF0dGVybiBwcm9wc1xuY29uc3QgcHJvcHM6IExhbWJkYVRvU3RlcGZ1bmN0aW9uc1Byb3BzID0ge1xuICBsYW1iZGFGdW5jdGlvblByb3BzOiB7XG4gICAgcnVudGltZTogZGVmYXVsdHMuQ09NTUVSQ0lBTF9SRUdJT05fTEFNQkRBX05PREVfUlVOVElNRSxcbiAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgY29kZTogbGFtYmRhLkNvZGUuZnJvbUFzc2V0KGAke19fZGlybmFtZX0vbGFtYmRhYClcbiAgfSxcbiAgc3RhdGVNYWNoaW5lUHJvcHM6IHtcbiAgICBkZWZpbml0aW9uQm9keTogc3RhcnRTdGF0ZVxuICB9LFxuICBsb2dHcm91cFByb3BzOiB7XG4gICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5ERVNUUk9ZLFxuICB9XG59O1xuXG4vLyBBZGQgdGhlIHBhdHRlcm5cbm5ldyBMYW1iZGFUb1N0ZXBmdW5jdGlvbnMoc3RhY2ssICd0ZXN0LWxhbWJkYS1zdGVwZnVuY3Rpb25zLWNvbnN0cnVjdCcsIHByb3BzKTtcblxuLy8gU3ludGggdGhlIGFwcFxubmV3IEludGVnVGVzdChzdGFjaywgJ0ludGVnJywge1xuICB0ZXN0Q2FzZXM6IFtcbiAgICBzdGFja1xuICBdXG59KTtcbiJdfQ==