/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#client_certificate_enabled ApiManagement#client_certificate_enabled}
    */
    readonly clientCertificateEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#gateway_disabled ApiManagement#gateway_disabled}
    */
    readonly gatewayDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#id ApiManagement#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#location ApiManagement#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#min_api_version ApiManagement#min_api_version}
    */
    readonly minApiVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#name ApiManagement#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#notification_sender_email ApiManagement#notification_sender_email}
    */
    readonly notificationSenderEmail?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#public_ip_address_id ApiManagement#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#public_network_access_enabled ApiManagement#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#publisher_email ApiManagement#publisher_email}
    */
    readonly publisherEmail: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#publisher_name ApiManagement#publisher_name}
    */
    readonly publisherName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#resource_group_name ApiManagement#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#sku_name ApiManagement#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tags ApiManagement#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#virtual_network_type ApiManagement#virtual_network_type}
    */
    readonly virtualNetworkType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#zones ApiManagement#zones}
    */
    readonly zones?: string[];
    /**
    * additional_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#additional_location ApiManagement#additional_location}
    */
    readonly additionalLocation?: ApiManagementAdditionalLocation[] | cdktf.IResolvable;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: ApiManagementCertificate[] | cdktf.IResolvable;
    /**
    * delegation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#delegation ApiManagement#delegation}
    */
    readonly delegation?: ApiManagementDelegation;
    /**
    * hostname_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#hostname_configuration ApiManagement#hostname_configuration}
    */
    readonly hostnameConfiguration?: ApiManagementHostnameConfiguration;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#identity ApiManagement#identity}
    */
    readonly identity?: ApiManagementIdentity;
    /**
    * protocols block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#protocols ApiManagement#protocols}
    */
    readonly protocols?: ApiManagementProtocols;
    /**
    * security block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#security ApiManagement#security}
    */
    readonly security?: ApiManagementSecurity;
    /**
    * sign_in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#sign_in ApiManagement#sign_in}
    */
    readonly signIn?: ApiManagementSignIn;
    /**
    * sign_up block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#sign_up ApiManagement#sign_up}
    */
    readonly signUp?: ApiManagementSignUp;
    /**
    * tenant_access block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tenant_access ApiManagement#tenant_access}
    */
    readonly tenantAccess?: ApiManagementTenantAccess;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#timeouts ApiManagement#timeouts}
    */
    readonly timeouts?: ApiManagementTimeouts;
    /**
    * virtual_network_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#virtual_network_configuration ApiManagement#virtual_network_configuration}
    */
    readonly virtualNetworkConfiguration?: ApiManagementVirtualNetworkConfiguration;
}
export interface ApiManagementAdditionalLocationVirtualNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#subnet_id ApiManagement#subnet_id}
    */
    readonly subnetId: string;
}
export declare function apiManagementAdditionalLocationVirtualNetworkConfigurationToTerraform(struct?: ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference | ApiManagementAdditionalLocationVirtualNetworkConfiguration): any;
export declare function apiManagementAdditionalLocationVirtualNetworkConfigurationToHclTerraform(struct?: ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference | ApiManagementAdditionalLocationVirtualNetworkConfiguration): any;
export declare class ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementAdditionalLocationVirtualNetworkConfiguration | undefined;
    set internalValue(value: ApiManagementAdditionalLocationVirtualNetworkConfiguration | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export interface ApiManagementAdditionalLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#capacity ApiManagement#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#gateway_disabled ApiManagement#gateway_disabled}
    */
    readonly gatewayDisabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#location ApiManagement#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#public_ip_address_id ApiManagement#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#zones ApiManagement#zones}
    */
    readonly zones?: string[];
    /**
    * virtual_network_configuration block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#virtual_network_configuration ApiManagement#virtual_network_configuration}
    */
    readonly virtualNetworkConfiguration?: ApiManagementAdditionalLocationVirtualNetworkConfiguration;
}
export declare function apiManagementAdditionalLocationToTerraform(struct?: ApiManagementAdditionalLocation | cdktf.IResolvable): any;
export declare function apiManagementAdditionalLocationToHclTerraform(struct?: ApiManagementAdditionalLocation | cdktf.IResolvable): any;
export declare class ApiManagementAdditionalLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementAdditionalLocation | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementAdditionalLocation | cdktf.IResolvable | undefined);
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    private _gatewayDisabled?;
    get gatewayDisabled(): boolean | cdktf.IResolvable;
    set gatewayDisabled(value: boolean | cdktf.IResolvable);
    resetGatewayDisabled(): void;
    get gatewayDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get gatewayRegionalUrl(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get privateIpAddresses(): string[];
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    get publicIpAddresses(): string[];
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _virtualNetworkConfiguration;
    get virtualNetworkConfiguration(): ApiManagementAdditionalLocationVirtualNetworkConfigurationOutputReference;
    putVirtualNetworkConfiguration(value: ApiManagementAdditionalLocationVirtualNetworkConfiguration): void;
    resetVirtualNetworkConfiguration(): void;
    get virtualNetworkConfigurationInput(): ApiManagementAdditionalLocationVirtualNetworkConfiguration | undefined;
}
export declare class ApiManagementAdditionalLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementAdditionalLocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementAdditionalLocationOutputReference;
}
export interface ApiManagementCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#encoded_certificate ApiManagement#encoded_certificate}
    */
    readonly encodedCertificate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#store_name ApiManagement#store_name}
    */
    readonly storeName: string;
}
export declare function apiManagementCertificateToTerraform(struct?: ApiManagementCertificate | cdktf.IResolvable): any;
export declare function apiManagementCertificateToHclTerraform(struct?: ApiManagementCertificate | cdktf.IResolvable): any;
export declare class ApiManagementCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementCertificate | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementCertificate | cdktf.IResolvable | undefined);
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    private _encodedCertificate?;
    get encodedCertificate(): string;
    set encodedCertificate(value: string);
    get encodedCertificateInput(): string | undefined;
    get expiry(): string;
    private _storeName?;
    get storeName(): string;
    set storeName(value: string);
    get storeNameInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementCertificateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementCertificate[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementCertificateOutputReference;
}
export interface ApiManagementDelegation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#subscriptions_enabled ApiManagement#subscriptions_enabled}
    */
    readonly subscriptionsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#url ApiManagement#url}
    */
    readonly url?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#user_registration_enabled ApiManagement#user_registration_enabled}
    */
    readonly userRegistrationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#validation_key ApiManagement#validation_key}
    */
    readonly validationKey?: string;
}
export declare function apiManagementDelegationToTerraform(struct?: ApiManagementDelegationOutputReference | ApiManagementDelegation): any;
export declare function apiManagementDelegationToHclTerraform(struct?: ApiManagementDelegationOutputReference | ApiManagementDelegation): any;
export declare class ApiManagementDelegationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementDelegation | undefined;
    set internalValue(value: ApiManagementDelegation | undefined);
    private _subscriptionsEnabled?;
    get subscriptionsEnabled(): boolean | cdktf.IResolvable;
    set subscriptionsEnabled(value: boolean | cdktf.IResolvable);
    resetSubscriptionsEnabled(): void;
    get subscriptionsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _userRegistrationEnabled?;
    get userRegistrationEnabled(): boolean | cdktf.IResolvable;
    set userRegistrationEnabled(value: boolean | cdktf.IResolvable);
    resetUserRegistrationEnabled(): void;
    get userRegistrationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _validationKey?;
    get validationKey(): string;
    set validationKey(value: string);
    resetValidationKey(): void;
    get validationKeyInput(): string | undefined;
}
export interface ApiManagementHostnameConfigurationDeveloperPortal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#host_name ApiManagement#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#key_vault_id ApiManagement#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationDeveloperPortalToTerraform(struct?: ApiManagementHostnameConfigurationDeveloperPortal | cdktf.IResolvable): any;
export declare function apiManagementHostnameConfigurationDeveloperPortalToHclTerraform(struct?: ApiManagementHostnameConfigurationDeveloperPortal | cdktf.IResolvable): any;
export declare class ApiManagementHostnameConfigurationDeveloperPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementHostnameConfigurationDeveloperPortal | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementHostnameConfigurationDeveloperPortal | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementHostnameConfigurationDeveloperPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementHostnameConfigurationDeveloperPortalOutputReference;
}
export interface ApiManagementHostnameConfigurationManagement {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#host_name ApiManagement#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#key_vault_id ApiManagement#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationManagementToTerraform(struct?: ApiManagementHostnameConfigurationManagement | cdktf.IResolvable): any;
export declare function apiManagementHostnameConfigurationManagementToHclTerraform(struct?: ApiManagementHostnameConfigurationManagement | cdktf.IResolvable): any;
export declare class ApiManagementHostnameConfigurationManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementHostnameConfigurationManagement | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementHostnameConfigurationManagement | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementHostnameConfigurationManagementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementHostnameConfigurationManagementOutputReference;
}
export interface ApiManagementHostnameConfigurationPortal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#host_name ApiManagement#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#key_vault_id ApiManagement#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationPortalToTerraform(struct?: ApiManagementHostnameConfigurationPortal | cdktf.IResolvable): any;
export declare function apiManagementHostnameConfigurationPortalToHclTerraform(struct?: ApiManagementHostnameConfigurationPortal | cdktf.IResolvable): any;
export declare class ApiManagementHostnameConfigurationPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementHostnameConfigurationPortal | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementHostnameConfigurationPortal | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementHostnameConfigurationPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementHostnameConfigurationPortalOutputReference;
}
export interface ApiManagementHostnameConfigurationProxy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#default_ssl_binding ApiManagement#default_ssl_binding}
    */
    readonly defaultSslBinding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#host_name ApiManagement#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#key_vault_id ApiManagement#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationProxyToTerraform(struct?: ApiManagementHostnameConfigurationProxy | cdktf.IResolvable): any;
export declare function apiManagementHostnameConfigurationProxyToHclTerraform(struct?: ApiManagementHostnameConfigurationProxy | cdktf.IResolvable): any;
export declare class ApiManagementHostnameConfigurationProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementHostnameConfigurationProxy | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementHostnameConfigurationProxy | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    private _defaultSslBinding?;
    get defaultSslBinding(): boolean | cdktf.IResolvable;
    set defaultSslBinding(value: boolean | cdktf.IResolvable);
    resetDefaultSslBinding(): void;
    get defaultSslBindingInput(): boolean | cdktf.IResolvable | undefined;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementHostnameConfigurationProxyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementHostnameConfigurationProxyOutputReference;
}
export interface ApiManagementHostnameConfigurationScm {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate ApiManagement#certificate}
    */
    readonly certificate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#certificate_password ApiManagement#certificate_password}
    */
    readonly certificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#host_name ApiManagement#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#key_vault_id ApiManagement#key_vault_id}
    */
    readonly keyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#negotiate_client_certificate ApiManagement#negotiate_client_certificate}
    */
    readonly negotiateClientCertificate?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#ssl_keyvault_identity_client_id ApiManagement#ssl_keyvault_identity_client_id}
    */
    readonly sslKeyvaultIdentityClientId?: string;
}
export declare function apiManagementHostnameConfigurationScmToTerraform(struct?: ApiManagementHostnameConfigurationScm | cdktf.IResolvable): any;
export declare function apiManagementHostnameConfigurationScmToHclTerraform(struct?: ApiManagementHostnameConfigurationScm | cdktf.IResolvable): any;
export declare class ApiManagementHostnameConfigurationScmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiManagementHostnameConfigurationScm | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementHostnameConfigurationScm | cdktf.IResolvable | undefined);
    private _certificate?;
    get certificate(): string;
    set certificate(value: string);
    resetCertificate(): void;
    get certificateInput(): string | undefined;
    private _certificatePassword?;
    get certificatePassword(): string;
    set certificatePassword(value: string);
    resetCertificatePassword(): void;
    get certificatePasswordInput(): string | undefined;
    get certificateSource(): string;
    get certificateStatus(): string;
    get expiry(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _keyVaultId?;
    get keyVaultId(): string;
    set keyVaultId(value: string);
    resetKeyVaultId(): void;
    get keyVaultIdInput(): string | undefined;
    private _negotiateClientCertificate?;
    get negotiateClientCertificate(): boolean | cdktf.IResolvable;
    set negotiateClientCertificate(value: boolean | cdktf.IResolvable);
    resetNegotiateClientCertificate(): void;
    get negotiateClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
    private _sslKeyvaultIdentityClientId?;
    get sslKeyvaultIdentityClientId(): string;
    set sslKeyvaultIdentityClientId(value: string);
    resetSslKeyvaultIdentityClientId(): void;
    get sslKeyvaultIdentityClientIdInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
}
export declare class ApiManagementHostnameConfigurationScmList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiManagementHostnameConfigurationScmOutputReference;
}
export interface ApiManagementHostnameConfiguration {
    /**
    * developer_portal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#developer_portal ApiManagement#developer_portal}
    */
    readonly developerPortal?: ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable;
    /**
    * management block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#management ApiManagement#management}
    */
    readonly management?: ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable;
    /**
    * portal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#portal ApiManagement#portal}
    */
    readonly portal?: ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable;
    /**
    * proxy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#proxy ApiManagement#proxy}
    */
    readonly proxy?: ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable;
    /**
    * scm block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#scm ApiManagement#scm}
    */
    readonly scm?: ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable;
}
export declare function apiManagementHostnameConfigurationToTerraform(struct?: ApiManagementHostnameConfigurationOutputReference | ApiManagementHostnameConfiguration): any;
export declare function apiManagementHostnameConfigurationToHclTerraform(struct?: ApiManagementHostnameConfigurationOutputReference | ApiManagementHostnameConfiguration): any;
export declare class ApiManagementHostnameConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementHostnameConfiguration | undefined;
    set internalValue(value: ApiManagementHostnameConfiguration | undefined);
    private _developerPortal;
    get developerPortal(): ApiManagementHostnameConfigurationDeveloperPortalList;
    putDeveloperPortal(value: ApiManagementHostnameConfigurationDeveloperPortal[] | cdktf.IResolvable): void;
    resetDeveloperPortal(): void;
    get developerPortalInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationDeveloperPortal[] | undefined;
    private _management;
    get management(): ApiManagementHostnameConfigurationManagementList;
    putManagement(value: ApiManagementHostnameConfigurationManagement[] | cdktf.IResolvable): void;
    resetManagement(): void;
    get managementInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationManagement[] | undefined;
    private _portal;
    get portal(): ApiManagementHostnameConfigurationPortalList;
    putPortal(value: ApiManagementHostnameConfigurationPortal[] | cdktf.IResolvable): void;
    resetPortal(): void;
    get portalInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationPortal[] | undefined;
    private _proxy;
    get proxy(): ApiManagementHostnameConfigurationProxyList;
    putProxy(value: ApiManagementHostnameConfigurationProxy[] | cdktf.IResolvable): void;
    resetProxy(): void;
    get proxyInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationProxy[] | undefined;
    private _scm;
    get scm(): ApiManagementHostnameConfigurationScmList;
    putScm(value: ApiManagementHostnameConfigurationScm[] | cdktf.IResolvable): void;
    resetScm(): void;
    get scmInput(): cdktf.IResolvable | ApiManagementHostnameConfigurationScm[] | undefined;
}
export interface ApiManagementIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#identity_ids ApiManagement#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#type ApiManagement#type}
    */
    readonly type: string;
}
export declare function apiManagementIdentityToTerraform(struct?: ApiManagementIdentityOutputReference | ApiManagementIdentity): any;
export declare function apiManagementIdentityToHclTerraform(struct?: ApiManagementIdentityOutputReference | ApiManagementIdentity): any;
export declare class ApiManagementIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementIdentity | undefined;
    set internalValue(value: ApiManagementIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ApiManagementProtocols {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_http2 ApiManagement#enable_http2}
    */
    readonly enableHttp2?: boolean | cdktf.IResolvable;
}
export declare function apiManagementProtocolsToTerraform(struct?: ApiManagementProtocolsOutputReference | ApiManagementProtocols): any;
export declare function apiManagementProtocolsToHclTerraform(struct?: ApiManagementProtocolsOutputReference | ApiManagementProtocols): any;
export declare class ApiManagementProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementProtocols | undefined;
    set internalValue(value: ApiManagementProtocols | undefined);
    private _enableHttp2?;
    get enableHttp2(): boolean | cdktf.IResolvable;
    set enableHttp2(value: boolean | cdktf.IResolvable);
    resetEnableHttp2(): void;
    get enableHttp2Input(): boolean | cdktf.IResolvable | undefined;
}
export interface ApiManagementSecurity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_backend_ssl30 ApiManagement#enable_backend_ssl30}
    */
    readonly enableBackendSsl30?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_backend_tls10 ApiManagement#enable_backend_tls10}
    */
    readonly enableBackendTls10?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_backend_tls11 ApiManagement#enable_backend_tls11}
    */
    readonly enableBackendTls11?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_frontend_ssl30 ApiManagement#enable_frontend_ssl30}
    */
    readonly enableFrontendSsl30?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_frontend_tls10 ApiManagement#enable_frontend_tls10}
    */
    readonly enableFrontendTls10?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enable_frontend_tls11 ApiManagement#enable_frontend_tls11}
    */
    readonly enableFrontendTls11?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_ecdsa_with_aes128_cbc_sha_ciphers_enabled}
    */
    readonly tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_ecdsa_with_aes256_cbc_sha_ciphers_enabled}
    */
    readonly tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_rsa_with_aes128_cbc_sha_ciphers_enabled}
    */
    readonly tlsEcdheRsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_ecdhe_rsa_with_aes256_cbc_sha_ciphers_enabled}
    */
    readonly tlsEcdheRsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes128_cbc_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes128_cbc_sha256_ciphers_enabled}
    */
    readonly tlsRsaWithAes128CbcSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes128_cbc_sha_ciphers_enabled ApiManagement#tls_rsa_with_aes128_cbc_sha_ciphers_enabled}
    */
    readonly tlsRsaWithAes128CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes128_gcm_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes128_gcm_sha256_ciphers_enabled}
    */
    readonly tlsRsaWithAes128GcmSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes256_cbc_sha256_ciphers_enabled ApiManagement#tls_rsa_with_aes256_cbc_sha256_ciphers_enabled}
    */
    readonly tlsRsaWithAes256CbcSha256CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes256_cbc_sha_ciphers_enabled ApiManagement#tls_rsa_with_aes256_cbc_sha_ciphers_enabled}
    */
    readonly tlsRsaWithAes256CbcShaCiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#tls_rsa_with_aes256_gcm_sha384_ciphers_enabled ApiManagement#tls_rsa_with_aes256_gcm_sha384_ciphers_enabled}
    */
    readonly tlsRsaWithAes256GcmSha384CiphersEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#triple_des_ciphers_enabled ApiManagement#triple_des_ciphers_enabled}
    */
    readonly tripleDesCiphersEnabled?: boolean | cdktf.IResolvable;
}
export declare function apiManagementSecurityToTerraform(struct?: ApiManagementSecurityOutputReference | ApiManagementSecurity): any;
export declare function apiManagementSecurityToHclTerraform(struct?: ApiManagementSecurityOutputReference | ApiManagementSecurity): any;
export declare class ApiManagementSecurityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSecurity | undefined;
    set internalValue(value: ApiManagementSecurity | undefined);
    private _enableBackendSsl30?;
    get enableBackendSsl30(): boolean | cdktf.IResolvable;
    set enableBackendSsl30(value: boolean | cdktf.IResolvable);
    resetEnableBackendSsl30(): void;
    get enableBackendSsl30Input(): boolean | cdktf.IResolvable | undefined;
    private _enableBackendTls10?;
    get enableBackendTls10(): boolean | cdktf.IResolvable;
    set enableBackendTls10(value: boolean | cdktf.IResolvable);
    resetEnableBackendTls10(): void;
    get enableBackendTls10Input(): boolean | cdktf.IResolvable | undefined;
    private _enableBackendTls11?;
    get enableBackendTls11(): boolean | cdktf.IResolvable;
    set enableBackendTls11(value: boolean | cdktf.IResolvable);
    resetEnableBackendTls11(): void;
    get enableBackendTls11Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendSsl30?;
    get enableFrontendSsl30(): boolean | cdktf.IResolvable;
    set enableFrontendSsl30(value: boolean | cdktf.IResolvable);
    resetEnableFrontendSsl30(): void;
    get enableFrontendSsl30Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendTls10?;
    get enableFrontendTls10(): boolean | cdktf.IResolvable;
    set enableFrontendTls10(value: boolean | cdktf.IResolvable);
    resetEnableFrontendTls10(): void;
    get enableFrontendTls10Input(): boolean | cdktf.IResolvable | undefined;
    private _enableFrontendTls11?;
    get enableFrontendTls11(): boolean | cdktf.IResolvable;
    set enableFrontendTls11(value: boolean | cdktf.IResolvable);
    resetEnableFrontendTls11(): void;
    get enableFrontendTls11Input(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled?;
    get tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEcdheEcdsaWithAes128CbcShaCiphersEnabled(): void;
    get tlsEcdheEcdsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled?;
    get tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEcdheEcdsaWithAes256CbcShaCiphersEnabled(): void;
    get tlsEcdheEcdsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheRsaWithAes128CbcShaCiphersEnabled?;
    get tlsEcdheRsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsEcdheRsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEcdheRsaWithAes128CbcShaCiphersEnabled(): void;
    get tlsEcdheRsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsEcdheRsaWithAes256CbcShaCiphersEnabled?;
    get tlsEcdheRsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsEcdheRsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEcdheRsaWithAes256CbcShaCiphersEnabled(): void;
    get tlsEcdheRsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128CbcSha256CiphersEnabled?;
    get tlsRsaWithAes128CbcSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes128CbcSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes128CbcSha256CiphersEnabled(): void;
    get tlsRsaWithAes128CbcSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128CbcShaCiphersEnabled?;
    get tlsRsaWithAes128CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes128CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes128CbcShaCiphersEnabled(): void;
    get tlsRsaWithAes128CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes128GcmSha256CiphersEnabled?;
    get tlsRsaWithAes128GcmSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes128GcmSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes128GcmSha256CiphersEnabled(): void;
    get tlsRsaWithAes128GcmSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes256CbcSha256CiphersEnabled?;
    get tlsRsaWithAes256CbcSha256CiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes256CbcSha256CiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes256CbcSha256CiphersEnabled(): void;
    get tlsRsaWithAes256CbcSha256CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes256CbcShaCiphersEnabled?;
    get tlsRsaWithAes256CbcShaCiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes256CbcShaCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes256CbcShaCiphersEnabled(): void;
    get tlsRsaWithAes256CbcShaCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsRsaWithAes256GcmSha384CiphersEnabled?;
    get tlsRsaWithAes256GcmSha384CiphersEnabled(): boolean | cdktf.IResolvable;
    set tlsRsaWithAes256GcmSha384CiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTlsRsaWithAes256GcmSha384CiphersEnabled(): void;
    get tlsRsaWithAes256GcmSha384CiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _tripleDesCiphersEnabled?;
    get tripleDesCiphersEnabled(): boolean | cdktf.IResolvable;
    set tripleDesCiphersEnabled(value: boolean | cdktf.IResolvable);
    resetTripleDesCiphersEnabled(): void;
    get tripleDesCiphersEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApiManagementSignIn {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enabled ApiManagement#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function apiManagementSignInToTerraform(struct?: ApiManagementSignInOutputReference | ApiManagementSignIn): any;
export declare function apiManagementSignInToHclTerraform(struct?: ApiManagementSignInOutputReference | ApiManagementSignIn): any;
export declare class ApiManagementSignInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSignIn | undefined;
    set internalValue(value: ApiManagementSignIn | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApiManagementSignUpTermsOfService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#consent_required ApiManagement#consent_required}
    */
    readonly consentRequired: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enabled ApiManagement#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#text ApiManagement#text}
    */
    readonly text?: string;
}
export declare function apiManagementSignUpTermsOfServiceToTerraform(struct?: ApiManagementSignUpTermsOfServiceOutputReference | ApiManagementSignUpTermsOfService): any;
export declare function apiManagementSignUpTermsOfServiceToHclTerraform(struct?: ApiManagementSignUpTermsOfServiceOutputReference | ApiManagementSignUpTermsOfService): any;
export declare class ApiManagementSignUpTermsOfServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSignUpTermsOfService | undefined;
    set internalValue(value: ApiManagementSignUpTermsOfService | undefined);
    private _consentRequired?;
    get consentRequired(): boolean | cdktf.IResolvable;
    set consentRequired(value: boolean | cdktf.IResolvable);
    get consentRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface ApiManagementSignUp {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enabled ApiManagement#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * terms_of_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#terms_of_service ApiManagement#terms_of_service}
    */
    readonly termsOfService: ApiManagementSignUpTermsOfService;
}
export declare function apiManagementSignUpToTerraform(struct?: ApiManagementSignUpOutputReference | ApiManagementSignUp): any;
export declare function apiManagementSignUpToHclTerraform(struct?: ApiManagementSignUpOutputReference | ApiManagementSignUp): any;
export declare class ApiManagementSignUpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSignUp | undefined;
    set internalValue(value: ApiManagementSignUp | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _termsOfService;
    get termsOfService(): ApiManagementSignUpTermsOfServiceOutputReference;
    putTermsOfService(value: ApiManagementSignUpTermsOfService): void;
    get termsOfServiceInput(): ApiManagementSignUpTermsOfService | undefined;
}
export interface ApiManagementTenantAccess {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#enabled ApiManagement#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function apiManagementTenantAccessToTerraform(struct?: ApiManagementTenantAccessOutputReference | ApiManagementTenantAccess): any;
export declare function apiManagementTenantAccessToHclTerraform(struct?: ApiManagementTenantAccessOutputReference | ApiManagementTenantAccess): any;
export declare class ApiManagementTenantAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementTenantAccess | undefined;
    set internalValue(value: ApiManagementTenantAccess | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get primaryKey(): string;
    get secondaryKey(): string;
    get tenantId(): string;
}
export interface ApiManagementTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#create ApiManagement#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#delete ApiManagement#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#read ApiManagement#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#update ApiManagement#update}
    */
    readonly update?: string;
}
export declare function apiManagementTimeoutsToTerraform(struct?: ApiManagementTimeouts | cdktf.IResolvable): any;
export declare function apiManagementTimeoutsToHclTerraform(struct?: ApiManagementTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApiManagementVirtualNetworkConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#subnet_id ApiManagement#subnet_id}
    */
    readonly subnetId: string;
}
export declare function apiManagementVirtualNetworkConfigurationToTerraform(struct?: ApiManagementVirtualNetworkConfigurationOutputReference | ApiManagementVirtualNetworkConfiguration): any;
export declare function apiManagementVirtualNetworkConfigurationToHclTerraform(struct?: ApiManagementVirtualNetworkConfigurationOutputReference | ApiManagementVirtualNetworkConfiguration): any;
export declare class ApiManagementVirtualNetworkConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementVirtualNetworkConfiguration | undefined;
    set internalValue(value: ApiManagementVirtualNetworkConfiguration | undefined);
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management azurerm_api_management}
*/
export declare class ApiManagement extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management";
    /**
    * Generates CDKTF code for importing a ApiManagement resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagement to import
    * @param importFromId The id of the existing ApiManagement that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagement to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/api_management azurerm_api_management} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementConfig);
    private _clientCertificateEnabled?;
    get clientCertificateEnabled(): boolean | cdktf.IResolvable;
    set clientCertificateEnabled(value: boolean | cdktf.IResolvable);
    resetClientCertificateEnabled(): void;
    get clientCertificateEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get developerPortalUrl(): string;
    private _gatewayDisabled?;
    get gatewayDisabled(): boolean | cdktf.IResolvable;
    set gatewayDisabled(value: boolean | cdktf.IResolvable);
    resetGatewayDisabled(): void;
    get gatewayDisabledInput(): boolean | cdktf.IResolvable | undefined;
    get gatewayRegionalUrl(): string;
    get gatewayUrl(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get managementApiUrl(): string;
    private _minApiVersion?;
    get minApiVersion(): string;
    set minApiVersion(value: string);
    resetMinApiVersion(): void;
    get minApiVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notificationSenderEmail?;
    get notificationSenderEmail(): string;
    set notificationSenderEmail(value: string);
    resetNotificationSenderEmail(): void;
    get notificationSenderEmailInput(): string | undefined;
    get portalUrl(): string;
    get privateIpAddresses(): string[];
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    get publicIpAddresses(): string[];
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _publisherEmail?;
    get publisherEmail(): string;
    set publisherEmail(value: string);
    get publisherEmailInput(): string | undefined;
    private _publisherName?;
    get publisherName(): string;
    set publisherName(value: string);
    get publisherNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scmUrl(): string;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _virtualNetworkType?;
    get virtualNetworkType(): string;
    set virtualNetworkType(value: string);
    resetVirtualNetworkType(): void;
    get virtualNetworkTypeInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _additionalLocation;
    get additionalLocation(): ApiManagementAdditionalLocationList;
    putAdditionalLocation(value: ApiManagementAdditionalLocation[] | cdktf.IResolvable): void;
    resetAdditionalLocation(): void;
    get additionalLocationInput(): cdktf.IResolvable | ApiManagementAdditionalLocation[] | undefined;
    private _certificate;
    get certificate(): ApiManagementCertificateList;
    putCertificate(value: ApiManagementCertificate[] | cdktf.IResolvable): void;
    resetCertificate(): void;
    get certificateInput(): cdktf.IResolvable | ApiManagementCertificate[] | undefined;
    private _delegation;
    get delegation(): ApiManagementDelegationOutputReference;
    putDelegation(value: ApiManagementDelegation): void;
    resetDelegation(): void;
    get delegationInput(): ApiManagementDelegation | undefined;
    private _hostnameConfiguration;
    get hostnameConfiguration(): ApiManagementHostnameConfigurationOutputReference;
    putHostnameConfiguration(value: ApiManagementHostnameConfiguration): void;
    resetHostnameConfiguration(): void;
    get hostnameConfigurationInput(): ApiManagementHostnameConfiguration | undefined;
    private _identity;
    get identity(): ApiManagementIdentityOutputReference;
    putIdentity(value: ApiManagementIdentity): void;
    resetIdentity(): void;
    get identityInput(): ApiManagementIdentity | undefined;
    private _protocols;
    get protocols(): ApiManagementProtocolsOutputReference;
    putProtocols(value: ApiManagementProtocols): void;
    resetProtocols(): void;
    get protocolsInput(): ApiManagementProtocols | undefined;
    private _security;
    get security(): ApiManagementSecurityOutputReference;
    putSecurity(value: ApiManagementSecurity): void;
    resetSecurity(): void;
    get securityInput(): ApiManagementSecurity | undefined;
    private _signIn;
    get signIn(): ApiManagementSignInOutputReference;
    putSignIn(value: ApiManagementSignIn): void;
    resetSignIn(): void;
    get signInInput(): ApiManagementSignIn | undefined;
    private _signUp;
    get signUp(): ApiManagementSignUpOutputReference;
    putSignUp(value: ApiManagementSignUp): void;
    resetSignUp(): void;
    get signUpInput(): ApiManagementSignUp | undefined;
    private _tenantAccess;
    get tenantAccess(): ApiManagementTenantAccessOutputReference;
    putTenantAccess(value: ApiManagementTenantAccess): void;
    resetTenantAccess(): void;
    get tenantAccessInput(): ApiManagementTenantAccess | undefined;
    private _timeouts;
    get timeouts(): ApiManagementTimeoutsOutputReference;
    putTimeouts(value: ApiManagementTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementTimeouts | undefined;
    private _virtualNetworkConfiguration;
    get virtualNetworkConfiguration(): ApiManagementVirtualNetworkConfigurationOutputReference;
    putVirtualNetworkConfiguration(value: ApiManagementVirtualNetworkConfiguration): void;
    resetVirtualNetworkConfiguration(): void;
    get virtualNetworkConfigurationInput(): ApiManagementVirtualNetworkConfiguration | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
