/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceCustomHostnameBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#app_service_name AppServiceCustomHostnameBinding#app_service_name}
    */
    readonly appServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#hostname AppServiceCustomHostnameBinding#hostname}
    */
    readonly hostname: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#id AppServiceCustomHostnameBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#resource_group_name AppServiceCustomHostnameBinding#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#ssl_state AppServiceCustomHostnameBinding#ssl_state}
    */
    readonly sslState?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#thumbprint AppServiceCustomHostnameBinding#thumbprint}
    */
    readonly thumbprint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#timeouts AppServiceCustomHostnameBinding#timeouts}
    */
    readonly timeouts?: AppServiceCustomHostnameBindingTimeouts;
}
export interface AppServiceCustomHostnameBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#create AppServiceCustomHostnameBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#delete AppServiceCustomHostnameBinding#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#read AppServiceCustomHostnameBinding#read}
    */
    readonly read?: string;
}
export declare function appServiceCustomHostnameBindingTimeoutsToTerraform(struct?: AppServiceCustomHostnameBindingTimeouts | cdktf.IResolvable): any;
export declare function appServiceCustomHostnameBindingTimeoutsToHclTerraform(struct?: AppServiceCustomHostnameBindingTimeouts | cdktf.IResolvable): any;
export declare class AppServiceCustomHostnameBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceCustomHostnameBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceCustomHostnameBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding azurerm_app_service_custom_hostname_binding}
*/
export declare class AppServiceCustomHostnameBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_custom_hostname_binding";
    /**
    * Generates CDKTF code for importing a AppServiceCustomHostnameBinding resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceCustomHostnameBinding to import
    * @param importFromId The id of the existing AppServiceCustomHostnameBinding that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceCustomHostnameBinding to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/app_service_custom_hostname_binding azurerm_app_service_custom_hostname_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceCustomHostnameBindingConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceCustomHostnameBindingConfig);
    private _appServiceName?;
    get appServiceName(): string;
    set appServiceName(value: string);
    get appServiceNameInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sslState?;
    get sslState(): string;
    set sslState(value: string);
    resetSslState(): void;
    get sslStateInput(): string | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    resetThumbprint(): void;
    get thumbprintInput(): string | undefined;
    get virtualIp(): string;
    private _timeouts;
    get timeouts(): AppServiceCustomHostnameBindingTimeoutsOutputReference;
    putTimeouts(value: AppServiceCustomHostnameBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceCustomHostnameBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
