/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbMongoRoleDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#cosmos_mongo_database_id CosmosdbMongoRoleDefinition#cosmos_mongo_database_id}
    */
    readonly cosmosMongoDatabaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#id CosmosdbMongoRoleDefinition#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#inherited_role_names CosmosdbMongoRoleDefinition#inherited_role_names}
    */
    readonly inheritedRoleNames?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#role_name CosmosdbMongoRoleDefinition#role_name}
    */
    readonly roleName: string;
    /**
    * privilege block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#privilege CosmosdbMongoRoleDefinition#privilege}
    */
    readonly privilege?: CosmosdbMongoRoleDefinitionPrivilege[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#timeouts CosmosdbMongoRoleDefinition#timeouts}
    */
    readonly timeouts?: CosmosdbMongoRoleDefinitionTimeouts;
}
export interface CosmosdbMongoRoleDefinitionPrivilegeResource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#collection_name CosmosdbMongoRoleDefinition#collection_name}
    */
    readonly collectionName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#db_name CosmosdbMongoRoleDefinition#db_name}
    */
    readonly dbName?: string;
}
export declare function cosmosdbMongoRoleDefinitionPrivilegeResourceToTerraform(struct?: CosmosdbMongoRoleDefinitionPrivilegeResourceOutputReference | CosmosdbMongoRoleDefinitionPrivilegeResource): any;
export declare function cosmosdbMongoRoleDefinitionPrivilegeResourceToHclTerraform(struct?: CosmosdbMongoRoleDefinitionPrivilegeResourceOutputReference | CosmosdbMongoRoleDefinitionPrivilegeResource): any;
export declare class CosmosdbMongoRoleDefinitionPrivilegeResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbMongoRoleDefinitionPrivilegeResource | undefined;
    set internalValue(value: CosmosdbMongoRoleDefinitionPrivilegeResource | undefined);
    private _collectionName?;
    get collectionName(): string;
    set collectionName(value: string);
    resetCollectionName(): void;
    get collectionNameInput(): string | undefined;
    private _dbName?;
    get dbName(): string;
    set dbName(value: string);
    resetDbName(): void;
    get dbNameInput(): string | undefined;
}
export interface CosmosdbMongoRoleDefinitionPrivilege {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#actions CosmosdbMongoRoleDefinition#actions}
    */
    readonly actions: string[];
    /**
    * resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#resource CosmosdbMongoRoleDefinition#resource}
    */
    readonly resource: CosmosdbMongoRoleDefinitionPrivilegeResource;
}
export declare function cosmosdbMongoRoleDefinitionPrivilegeToTerraform(struct?: CosmosdbMongoRoleDefinitionPrivilege | cdktf.IResolvable): any;
export declare function cosmosdbMongoRoleDefinitionPrivilegeToHclTerraform(struct?: CosmosdbMongoRoleDefinitionPrivilege | cdktf.IResolvable): any;
export declare class CosmosdbMongoRoleDefinitionPrivilegeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): CosmosdbMongoRoleDefinitionPrivilege | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbMongoRoleDefinitionPrivilege | cdktf.IResolvable | undefined);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    get actionsInput(): string[] | undefined;
    private _resource;
    get resource(): CosmosdbMongoRoleDefinitionPrivilegeResourceOutputReference;
    putResource(value: CosmosdbMongoRoleDefinitionPrivilegeResource): void;
    get resourceInput(): CosmosdbMongoRoleDefinitionPrivilegeResource | undefined;
}
export declare class CosmosdbMongoRoleDefinitionPrivilegeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: CosmosdbMongoRoleDefinitionPrivilege[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): CosmosdbMongoRoleDefinitionPrivilegeOutputReference;
}
export interface CosmosdbMongoRoleDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#create CosmosdbMongoRoleDefinition#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#delete CosmosdbMongoRoleDefinition#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#read CosmosdbMongoRoleDefinition#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#update CosmosdbMongoRoleDefinition#update}
    */
    readonly update?: string;
}
export declare function cosmosdbMongoRoleDefinitionTimeoutsToTerraform(struct?: CosmosdbMongoRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare function cosmosdbMongoRoleDefinitionTimeoutsToHclTerraform(struct?: CosmosdbMongoRoleDefinitionTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbMongoRoleDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbMongoRoleDefinitionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbMongoRoleDefinitionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition azurerm_cosmosdb_mongo_role_definition}
*/
export declare class CosmosdbMongoRoleDefinition extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_mongo_role_definition";
    /**
    * Generates CDKTF code for importing a CosmosdbMongoRoleDefinition resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CosmosdbMongoRoleDefinition to import
    * @param importFromId The id of the existing CosmosdbMongoRoleDefinition that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CosmosdbMongoRoleDefinition to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/cosmosdb_mongo_role_definition azurerm_cosmosdb_mongo_role_definition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbMongoRoleDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbMongoRoleDefinitionConfig);
    private _cosmosMongoDatabaseId?;
    get cosmosMongoDatabaseId(): string;
    set cosmosMongoDatabaseId(value: string);
    get cosmosMongoDatabaseIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inheritedRoleNames?;
    get inheritedRoleNames(): string[];
    set inheritedRoleNames(value: string[]);
    resetInheritedRoleNames(): void;
    get inheritedRoleNamesInput(): string[] | undefined;
    private _roleName?;
    get roleName(): string;
    set roleName(value: string);
    get roleNameInput(): string | undefined;
    private _privilege;
    get privilege(): CosmosdbMongoRoleDefinitionPrivilegeList;
    putPrivilege(value: CosmosdbMongoRoleDefinitionPrivilege[] | cdktf.IResolvable): void;
    resetPrivilege(): void;
    get privilegeInput(): cdktf.IResolvable | CosmosdbMongoRoleDefinitionPrivilege[] | undefined;
    private _timeouts;
    get timeouts(): CosmosdbMongoRoleDefinitionTimeoutsOutputReference;
    putTimeouts(value: CosmosdbMongoRoleDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbMongoRoleDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
