/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCdnFrontdoorOriginGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#id DataAzurermCdnFrontdoorOriginGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#name DataAzurermCdnFrontdoorOriginGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#profile_name DataAzurermCdnFrontdoorOriginGroup#profile_name}
    */
    readonly profileName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#resource_group_name DataAzurermCdnFrontdoorOriginGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#timeouts DataAzurermCdnFrontdoorOriginGroup#timeouts}
    */
    readonly timeouts?: DataAzurermCdnFrontdoorOriginGroupTimeouts;
}
export interface DataAzurermCdnFrontdoorOriginGroupHealthProbe {
}
export declare function dataAzurermCdnFrontdoorOriginGroupHealthProbeToTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupHealthProbe): any;
export declare function dataAzurermCdnFrontdoorOriginGroupHealthProbeToHclTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupHealthProbe): any;
export declare class DataAzurermCdnFrontdoorOriginGroupHealthProbeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCdnFrontdoorOriginGroupHealthProbe | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorOriginGroupHealthProbe | undefined);
    get intervalInSeconds(): number;
    get path(): string;
    get protocol(): string;
    get requestType(): string;
}
export declare class DataAzurermCdnFrontdoorOriginGroupHealthProbeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCdnFrontdoorOriginGroupHealthProbeOutputReference;
}
export interface DataAzurermCdnFrontdoorOriginGroupLoadBalancing {
}
export declare function dataAzurermCdnFrontdoorOriginGroupLoadBalancingToTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupLoadBalancing): any;
export declare function dataAzurermCdnFrontdoorOriginGroupLoadBalancingToHclTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupLoadBalancing): any;
export declare class DataAzurermCdnFrontdoorOriginGroupLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermCdnFrontdoorOriginGroupLoadBalancing | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorOriginGroupLoadBalancing | undefined);
    get additionalLatencyInMilliseconds(): number;
    get sampleSize(): number;
    get successfulSamplesRequired(): number;
}
export declare class DataAzurermCdnFrontdoorOriginGroupLoadBalancingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermCdnFrontdoorOriginGroupLoadBalancingOutputReference;
}
export interface DataAzurermCdnFrontdoorOriginGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#read DataAzurermCdnFrontdoorOriginGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCdnFrontdoorOriginGroupTimeoutsToTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermCdnFrontdoorOriginGroupTimeoutsToHclTerraform(struct?: DataAzurermCdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCdnFrontdoorOriginGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermCdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermCdnFrontdoorOriginGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group azurerm_cdn_frontdoor_origin_group}
*/
export declare class DataAzurermCdnFrontdoorOriginGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_origin_group";
    /**
    * Generates CDKTF code for importing a DataAzurermCdnFrontdoorOriginGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermCdnFrontdoorOriginGroup to import
    * @param importFromId The id of the existing DataAzurermCdnFrontdoorOriginGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermCdnFrontdoorOriginGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/cdn_frontdoor_origin_group azurerm_cdn_frontdoor_origin_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCdnFrontdoorOriginGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCdnFrontdoorOriginGroupConfig);
    get cdnFrontdoorProfileId(): string;
    private _healthProbe;
    get healthProbe(): DataAzurermCdnFrontdoorOriginGroupHealthProbeList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _loadBalancing;
    get loadBalancing(): DataAzurermCdnFrontdoorOriginGroupLoadBalancingList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _profileName?;
    get profileName(): string;
    set profileName(value: string);
    get profileNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restoreTrafficTimeToHealedOrNewEndpointInMinutes(): number;
    get sessionAffinityEnabled(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermCdnFrontdoorOriginGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCdnFrontdoorOriginGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermCdnFrontdoorOriginGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
