/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDedicatedHostGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#id DataAzurermDedicatedHostGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#name DataAzurermDedicatedHostGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#resource_group_name DataAzurermDedicatedHostGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#timeouts DataAzurermDedicatedHostGroup#timeouts}
    */
    readonly timeouts?: DataAzurermDedicatedHostGroupTimeouts;
}
export interface DataAzurermDedicatedHostGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#read DataAzurermDedicatedHostGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDedicatedHostGroupTimeoutsToTerraform(struct?: DataAzurermDedicatedHostGroupTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDedicatedHostGroupTimeoutsToHclTerraform(struct?: DataAzurermDedicatedHostGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDedicatedHostGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDedicatedHostGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDedicatedHostGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group azurerm_dedicated_host_group}
*/
export declare class DataAzurermDedicatedHostGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dedicated_host_group";
    /**
    * Generates CDKTF code for importing a DataAzurermDedicatedHostGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDedicatedHostGroup to import
    * @param importFromId The id of the existing DataAzurermDedicatedHostGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDedicatedHostGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/dedicated_host_group azurerm_dedicated_host_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDedicatedHostGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDedicatedHostGroupConfig);
    get automaticPlacementEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get platformFaultDomainCount(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermDedicatedHostGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDedicatedHostGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDedicatedHostGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
