/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#id DataAzurermManagedDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#name DataAzurermManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#resource_group_name DataAzurermManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#timeouts DataAzurermManagedDisk#timeouts}
    */
    readonly timeouts?: DataAzurermManagedDiskTimeouts;
}
export interface DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKey {
}
export declare function dataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyToTerraform(struct?: DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKey): any;
export declare function dataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyToHclTerraform(struct?: DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKey): any;
export declare class DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKey | undefined;
    set internalValue(value: DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKey | undefined);
    get secretUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyOutputReference;
}
export interface DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKey {
}
export declare function dataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyToTerraform(struct?: DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKey): any;
export declare function dataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyToHclTerraform(struct?: DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKey): any;
export declare class DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKey | undefined;
    set internalValue(value: DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKey | undefined);
    get keyUrl(): string;
    get sourceVaultId(): string;
}
export declare class DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyOutputReference;
}
export interface DataAzurermManagedDiskEncryptionSettings {
}
export declare function dataAzurermManagedDiskEncryptionSettingsToTerraform(struct?: DataAzurermManagedDiskEncryptionSettings): any;
export declare function dataAzurermManagedDiskEncryptionSettingsToHclTerraform(struct?: DataAzurermManagedDiskEncryptionSettings): any;
export declare class DataAzurermManagedDiskEncryptionSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermManagedDiskEncryptionSettings | undefined;
    set internalValue(value: DataAzurermManagedDiskEncryptionSettings | undefined);
    private _diskEncryptionKey;
    get diskEncryptionKey(): DataAzurermManagedDiskEncryptionSettingsDiskEncryptionKeyList;
    get enabled(): cdktf.IResolvable;
    private _keyEncryptionKey;
    get keyEncryptionKey(): DataAzurermManagedDiskEncryptionSettingsKeyEncryptionKeyList;
}
export declare class DataAzurermManagedDiskEncryptionSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermManagedDiskEncryptionSettingsOutputReference;
}
export interface DataAzurermManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#read DataAzurermManagedDisk#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagedDiskTimeoutsToTerraform(struct?: DataAzurermManagedDiskTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermManagedDiskTimeoutsToHclTerraform(struct?: DataAzurermManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagedDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermManagedDiskTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk azurerm_managed_disk}
*/
export declare class DataAzurermManagedDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_managed_disk";
    /**
    * Generates CDKTF code for importing a DataAzurermManagedDisk resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermManagedDisk to import
    * @param importFromId The id of the existing DataAzurermManagedDisk that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermManagedDisk to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/managed_disk azurerm_managed_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagedDiskConfig);
    get createOption(): string;
    get diskAccessId(): string;
    get diskEncryptionSetId(): string;
    get diskIopsReadWrite(): number;
    get diskMbpsReadWrite(): number;
    get diskSizeGb(): number;
    private _encryptionSettings;
    get encryptionSettings(): DataAzurermManagedDiskEncryptionSettingsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageReferenceId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkAccessPolicy(): string;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get storageAccountType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermManagedDiskTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
