/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorDataCollectionEndpointConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#id DataAzurermMonitorDataCollectionEndpoint#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#name DataAzurermMonitorDataCollectionEndpoint#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#resource_group_name DataAzurermMonitorDataCollectionEndpoint#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#timeouts DataAzurermMonitorDataCollectionEndpoint#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorDataCollectionEndpointTimeouts;
}
export interface DataAzurermMonitorDataCollectionEndpointTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#read DataAzurermMonitorDataCollectionEndpoint#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorDataCollectionEndpointTimeoutsToTerraform(struct?: DataAzurermMonitorDataCollectionEndpointTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMonitorDataCollectionEndpointTimeoutsToHclTerraform(struct?: DataAzurermMonitorDataCollectionEndpointTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorDataCollectionEndpointTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorDataCollectionEndpointTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionEndpointTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint azurerm_monitor_data_collection_endpoint}
*/
export declare class DataAzurermMonitorDataCollectionEndpoint extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_endpoint";
    /**
    * Generates CDKTF code for importing a DataAzurermMonitorDataCollectionEndpoint resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMonitorDataCollectionEndpoint to import
    * @param importFromId The id of the existing DataAzurermMonitorDataCollectionEndpoint that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMonitorDataCollectionEndpoint to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/monitor_data_collection_endpoint azurerm_monitor_data_collection_endpoint} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorDataCollectionEndpointConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorDataCollectionEndpointConfig);
    get configurationAccessEndpoint(): string;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get immutableId(): string;
    get kind(): string;
    get location(): string;
    get logsIngestionEndpoint(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMonitorDataCollectionEndpointTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorDataCollectionEndpointTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMonitorDataCollectionEndpointTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
