/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappVolumeGroupSapHanaConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#account_name DataAzurermNetappVolumeGroupSapHana#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#id DataAzurermNetappVolumeGroupSapHana#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#name DataAzurermNetappVolumeGroupSapHana#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#resource_group_name DataAzurermNetappVolumeGroupSapHana#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#timeouts DataAzurermNetappVolumeGroupSapHana#timeouts}
    */
    readonly timeouts?: DataAzurermNetappVolumeGroupSapHanaTimeouts;
}
export interface DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplication {
}
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationToTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplication): any;
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationToHclTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplication): any;
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplication | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplication | undefined);
    get endpointType(): string;
    get remoteVolumeLocation(): string;
    get remoteVolumeResourceId(): string;
    get replicationFrequency(): string;
}
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationOutputReference;
}
export interface DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy {
}
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyToTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy): any;
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyToHclTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy): any;
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicy | undefined);
    get snapshotPolicyId(): string;
}
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyOutputReference;
}
export interface DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRule {
}
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleToTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRule): any;
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleToHclTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRule): any;
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRule | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRule | undefined);
    get allowedClients(): string;
    get nfsv3Enabled(): cdktf.IResolvable;
    get nfsv41Enabled(): cdktf.IResolvable;
    get rootAccessEnabled(): cdktf.IResolvable;
    get ruleIndex(): number;
    get unixReadOnly(): cdktf.IResolvable;
    get unixReadWrite(): cdktf.IResolvable;
}
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleOutputReference;
}
export interface DataAzurermNetappVolumeGroupSapHanaVolume {
}
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeToTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolume): any;
export declare function dataAzurermNetappVolumeGroupSapHanaVolumeToHclTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaVolume): any;
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetappVolumeGroupSapHanaVolume | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupSapHanaVolume | undefined);
    get capacityPoolId(): string;
    private _dataProtectionReplication;
    get dataProtectionReplication(): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionReplicationList;
    private _dataProtectionSnapshotPolicy;
    get dataProtectionSnapshotPolicy(): DataAzurermNetappVolumeGroupSapHanaVolumeDataProtectionSnapshotPolicyList;
    private _exportPolicyRule;
    get exportPolicyRule(): DataAzurermNetappVolumeGroupSapHanaVolumeExportPolicyRuleList;
    get id(): string;
    get mountIpAddresses(): string[];
    get name(): string;
    get protocols(): string[];
    get proximityPlacementGroupId(): string;
    get securityStyle(): string;
    get serviceLevel(): string;
    get snapshotDirectoryVisible(): cdktf.IResolvable;
    get storageQuotaInGb(): number;
    get subnetId(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get throughputInMibps(): number;
    get volumePath(): string;
    get volumeSpecName(): string;
}
export declare class DataAzurermNetappVolumeGroupSapHanaVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetappVolumeGroupSapHanaVolumeOutputReference;
}
export interface DataAzurermNetappVolumeGroupSapHanaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#read DataAzurermNetappVolumeGroupSapHana#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappVolumeGroupSapHanaTimeoutsToTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetappVolumeGroupSapHanaTimeoutsToHclTerraform(struct?: DataAzurermNetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappVolumeGroupSapHanaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetappVolumeGroupSapHanaTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana azurerm_netapp_volume_group_sap_hana}
*/
export declare class DataAzurermNetappVolumeGroupSapHana extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_netapp_volume_group_sap_hana";
    /**
    * Generates CDKTF code for importing a DataAzurermNetappVolumeGroupSapHana resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetappVolumeGroupSapHana to import
    * @param importFromId The id of the existing DataAzurermNetappVolumeGroupSapHana that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetappVolumeGroupSapHana to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/netapp_volume_group_sap_hana azurerm_netapp_volume_group_sap_hana} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappVolumeGroupSapHanaConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappVolumeGroupSapHanaConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get applicationIdentifier(): string;
    get groupDescription(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _volume;
    get volume(): DataAzurermNetappVolumeGroupSapHanaVolumeList;
    private _timeouts;
    get timeouts(): DataAzurermNetappVolumeGroupSapHanaTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappVolumeGroupSapHanaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetappVolumeGroupSapHanaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
