/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#id DataAzurermNetworkInterface#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#name DataAzurermNetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#resource_group_name DataAzurermNetworkInterface#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#timeouts DataAzurermNetworkInterface#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkInterfaceTimeouts;
}
export interface DataAzurermNetworkInterfaceIpConfiguration {
}
export declare function dataAzurermNetworkInterfaceIpConfigurationToTerraform(struct?: DataAzurermNetworkInterfaceIpConfiguration): any;
export declare function dataAzurermNetworkInterfaceIpConfigurationToHclTerraform(struct?: DataAzurermNetworkInterfaceIpConfiguration): any;
export declare class DataAzurermNetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermNetworkInterfaceIpConfiguration | undefined;
    set internalValue(value: DataAzurermNetworkInterfaceIpConfiguration | undefined);
    get applicationGatewayBackendAddressPoolsIds(): string[];
    get applicationSecurityGroupIds(): string[];
    get gatewayLoadBalancerFrontendIpConfigurationId(): string;
    get loadBalancerBackendAddressPoolsIds(): string[];
    get loadBalancerInboundNatRulesIds(): string[];
    get name(): string;
    get primary(): cdktf.IResolvable;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateIpAddressVersion(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
}
export declare class DataAzurermNetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermNetworkInterfaceIpConfigurationOutputReference;
}
export interface DataAzurermNetworkInterfaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#read DataAzurermNetworkInterface#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkInterfaceTimeoutsToTerraform(struct?: DataAzurermNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetworkInterfaceTimeoutsToHclTerraform(struct?: DataAzurermNetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetworkInterfaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetworkInterfaceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface azurerm_network_interface}
*/
export declare class DataAzurermNetworkInterface extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_network_interface";
    /**
    * Generates CDKTF code for importing a DataAzurermNetworkInterface resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetworkInterface to import
    * @param importFromId The id of the existing DataAzurermNetworkInterface that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetworkInterface to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/network_interface azurerm_network_interface} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkInterfaceConfig);
    get acceleratedNetworkingEnabled(): cdktf.IResolvable;
    get appliedDnsServers(): string[];
    get dnsServers(): string[];
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get internalDnsNameLabel(): string;
    private _ipConfiguration;
    get ipConfiguration(): DataAzurermNetworkInterfaceIpConfigurationList;
    get ipForwardingEnabled(): cdktf.IResolvable;
    get location(): string;
    get macAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get networkSecurityGroupId(): string;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get virtualMachineId(): string;
    private _timeouts;
    get timeouts(): DataAzurermNetworkInterfaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkInterfaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetworkInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
