/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSystemCenterVirtualMachineManagerInventoryItemsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#id DataAzurermSystemCenterVirtualMachineManagerInventoryItems#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#inventory_type DataAzurermSystemCenterVirtualMachineManagerInventoryItems#inventory_type}
    */
    readonly inventoryType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#system_center_virtual_machine_manager_server_id DataAzurermSystemCenterVirtualMachineManagerInventoryItems#system_center_virtual_machine_manager_server_id}
    */
    readonly systemCenterVirtualMachineManagerServerId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#timeouts DataAzurermSystemCenterVirtualMachineManagerInventoryItems#timeouts}
    */
    readonly timeouts?: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts;
}
export interface DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItems {
}
export declare function dataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsToTerraform(struct?: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItems): any;
export declare function dataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsToHclTerraform(struct?: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItems): any;
export declare class DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItems | undefined;
    set internalValue(value: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItems | undefined);
    get id(): string;
    get name(): string;
    get uuid(): string;
}
export declare class DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsOutputReference;
}
export interface DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#read DataAzurermSystemCenterVirtualMachineManagerInventoryItems#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeoutsToTerraform(struct?: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeoutsToHclTerraform(struct?: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items azurerm_system_center_virtual_machine_manager_inventory_items}
*/
export declare class DataAzurermSystemCenterVirtualMachineManagerInventoryItems extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_system_center_virtual_machine_manager_inventory_items";
    /**
    * Generates CDKTF code for importing a DataAzurermSystemCenterVirtualMachineManagerInventoryItems resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSystemCenterVirtualMachineManagerInventoryItems to import
    * @param importFromId The id of the existing DataAzurermSystemCenterVirtualMachineManagerInventoryItems that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSystemCenterVirtualMachineManagerInventoryItems to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/data-sources/system_center_virtual_machine_manager_inventory_items azurerm_system_center_virtual_machine_manager_inventory_items} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSystemCenterVirtualMachineManagerInventoryItemsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _inventoryItems;
    get inventoryItems(): DataAzurermSystemCenterVirtualMachineManagerInventoryItemsInventoryItemsList;
    private _inventoryType?;
    get inventoryType(): string;
    set inventoryType(value: string);
    get inventoryTypeInput(): string | undefined;
    private _systemCenterVirtualMachineManagerServerId?;
    get systemCenterVirtualMachineManagerServerId(): string;
    set systemCenterVirtualMachineManagerServerId(value: string);
    get systemCenterVirtualMachineManagerServerIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSystemCenterVirtualMachineManagerInventoryItemsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
