/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDatasetParquetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#additional_properties DataFactoryDatasetParquet#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#annotations DataFactoryDatasetParquet#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#compression_codec DataFactoryDatasetParquet#compression_codec}
    */
    readonly compressionCodec?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#compression_level DataFactoryDatasetParquet#compression_level}
    */
    readonly compressionLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#data_factory_id DataFactoryDatasetParquet#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#description DataFactoryDatasetParquet#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#folder DataFactoryDatasetParquet#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#id DataFactoryDatasetParquet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#linked_service_name DataFactoryDatasetParquet#linked_service_name}
    */
    readonly linkedServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#name DataFactoryDatasetParquet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#parameters DataFactoryDatasetParquet#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * azure_blob_fs_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#azure_blob_fs_location DataFactoryDatasetParquet#azure_blob_fs_location}
    */
    readonly azureBlobFsLocation?: DataFactoryDatasetParquetAzureBlobFsLocation;
    /**
    * azure_blob_storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#azure_blob_storage_location DataFactoryDatasetParquet#azure_blob_storage_location}
    */
    readonly azureBlobStorageLocation?: DataFactoryDatasetParquetAzureBlobStorageLocation;
    /**
    * http_server_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#http_server_location DataFactoryDatasetParquet#http_server_location}
    */
    readonly httpServerLocation?: DataFactoryDatasetParquetHttpServerLocation;
    /**
    * schema_column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#schema_column DataFactoryDatasetParquet#schema_column}
    */
    readonly schemaColumn?: DataFactoryDatasetParquetSchemaColumn[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#timeouts DataFactoryDatasetParquet#timeouts}
    */
    readonly timeouts?: DataFactoryDatasetParquetTimeouts;
}
export interface DataFactoryDatasetParquetAzureBlobFsLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_file_system_enabled DataFactoryDatasetParquet#dynamic_file_system_enabled}
    */
    readonly dynamicFileSystemEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_filename_enabled DataFactoryDatasetParquet#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_path_enabled DataFactoryDatasetParquet#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#file_system DataFactoryDatasetParquet#file_system}
    */
    readonly fileSystem?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#filename DataFactoryDatasetParquet#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#path DataFactoryDatasetParquet#path}
    */
    readonly path?: string;
}
export declare function dataFactoryDatasetParquetAzureBlobFsLocationToTerraform(struct?: DataFactoryDatasetParquetAzureBlobFsLocationOutputReference | DataFactoryDatasetParquetAzureBlobFsLocation): any;
export declare function dataFactoryDatasetParquetAzureBlobFsLocationToHclTerraform(struct?: DataFactoryDatasetParquetAzureBlobFsLocationOutputReference | DataFactoryDatasetParquetAzureBlobFsLocation): any;
export declare class DataFactoryDatasetParquetAzureBlobFsLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetParquetAzureBlobFsLocation | undefined;
    set internalValue(value: DataFactoryDatasetParquetAzureBlobFsLocation | undefined);
    private _dynamicFileSystemEnabled?;
    get dynamicFileSystemEnabled(): boolean | cdktf.IResolvable;
    set dynamicFileSystemEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFileSystemEnabled(): void;
    get dynamicFileSystemEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fileSystem?;
    get fileSystem(): string;
    set fileSystem(value: string);
    resetFileSystem(): void;
    get fileSystemInput(): string | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface DataFactoryDatasetParquetAzureBlobStorageLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#container DataFactoryDatasetParquet#container}
    */
    readonly container: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_container_enabled DataFactoryDatasetParquet#dynamic_container_enabled}
    */
    readonly dynamicContainerEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_filename_enabled DataFactoryDatasetParquet#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_path_enabled DataFactoryDatasetParquet#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#filename DataFactoryDatasetParquet#filename}
    */
    readonly filename?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#path DataFactoryDatasetParquet#path}
    */
    readonly path?: string;
}
export declare function dataFactoryDatasetParquetAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference | DataFactoryDatasetParquetAzureBlobStorageLocation): any;
export declare function dataFactoryDatasetParquetAzureBlobStorageLocationToHclTerraform(struct?: DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference | DataFactoryDatasetParquetAzureBlobStorageLocation): any;
export declare class DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetParquetAzureBlobStorageLocation | undefined;
    set internalValue(value: DataFactoryDatasetParquetAzureBlobStorageLocation | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _dynamicContainerEnabled?;
    get dynamicContainerEnabled(): boolean | cdktf.IResolvable;
    set dynamicContainerEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicContainerEnabled(): void;
    get dynamicContainerEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    resetFilename(): void;
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface DataFactoryDatasetParquetHttpServerLocation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_filename_enabled DataFactoryDatasetParquet#dynamic_filename_enabled}
    */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#dynamic_path_enabled DataFactoryDatasetParquet#dynamic_path_enabled}
    */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#filename DataFactoryDatasetParquet#filename}
    */
    readonly filename: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#path DataFactoryDatasetParquet#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#relative_url DataFactoryDatasetParquet#relative_url}
    */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetParquetHttpServerLocationToTerraform(struct?: DataFactoryDatasetParquetHttpServerLocationOutputReference | DataFactoryDatasetParquetHttpServerLocation): any;
export declare function dataFactoryDatasetParquetHttpServerLocationToHclTerraform(struct?: DataFactoryDatasetParquetHttpServerLocationOutputReference | DataFactoryDatasetParquetHttpServerLocation): any;
export declare class DataFactoryDatasetParquetHttpServerLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetParquetHttpServerLocation | undefined;
    set internalValue(value: DataFactoryDatasetParquetHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicFilenameEnabled(): void;
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    resetDynamicPathEnabled(): void;
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    get filename(): string;
    set filename(value: string);
    get filenameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _relativeUrl?;
    get relativeUrl(): string;
    set relativeUrl(value: string);
    get relativeUrlInput(): string | undefined;
}
export interface DataFactoryDatasetParquetSchemaColumn {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#description DataFactoryDatasetParquet#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#name DataFactoryDatasetParquet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#type DataFactoryDatasetParquet#type}
    */
    readonly type?: string;
}
export declare function dataFactoryDatasetParquetSchemaColumnToTerraform(struct?: DataFactoryDatasetParquetSchemaColumn | cdktf.IResolvable): any;
export declare function dataFactoryDatasetParquetSchemaColumnToHclTerraform(struct?: DataFactoryDatasetParquetSchemaColumn | cdktf.IResolvable): any;
export declare class DataFactoryDatasetParquetSchemaColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryDatasetParquetSchemaColumn | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDatasetParquetSchemaColumn | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export declare class DataFactoryDatasetParquetSchemaColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryDatasetParquetSchemaColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryDatasetParquetSchemaColumnOutputReference;
}
export interface DataFactoryDatasetParquetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#create DataFactoryDatasetParquet#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#delete DataFactoryDatasetParquet#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#read DataFactoryDatasetParquet#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#update DataFactoryDatasetParquet#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDatasetParquetTimeoutsToTerraform(struct?: DataFactoryDatasetParquetTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryDatasetParquetTimeoutsToHclTerraform(struct?: DataFactoryDatasetParquetTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDatasetParquetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDatasetParquetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDatasetParquetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet azurerm_data_factory_dataset_parquet}
*/
export declare class DataFactoryDatasetParquet extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_dataset_parquet";
    /**
    * Generates CDKTF code for importing a DataFactoryDatasetParquet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryDatasetParquet to import
    * @param importFromId The id of the existing DataFactoryDatasetParquet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryDatasetParquet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/data_factory_dataset_parquet azurerm_data_factory_dataset_parquet} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDatasetParquetConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetParquetConfig);
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _compressionCodec?;
    get compressionCodec(): string;
    set compressionCodec(value: string);
    resetCompressionCodec(): void;
    get compressionCodecInput(): string | undefined;
    private _compressionLevel?;
    get compressionLevel(): string;
    set compressionLevel(value: string);
    resetCompressionLevel(): void;
    get compressionLevelInput(): string | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _linkedServiceName?;
    get linkedServiceName(): string;
    set linkedServiceName(value: string);
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _azureBlobFsLocation;
    get azureBlobFsLocation(): DataFactoryDatasetParquetAzureBlobFsLocationOutputReference;
    putAzureBlobFsLocation(value: DataFactoryDatasetParquetAzureBlobFsLocation): void;
    resetAzureBlobFsLocation(): void;
    get azureBlobFsLocationInput(): DataFactoryDatasetParquetAzureBlobFsLocation | undefined;
    private _azureBlobStorageLocation;
    get azureBlobStorageLocation(): DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference;
    putAzureBlobStorageLocation(value: DataFactoryDatasetParquetAzureBlobStorageLocation): void;
    resetAzureBlobStorageLocation(): void;
    get azureBlobStorageLocationInput(): DataFactoryDatasetParquetAzureBlobStorageLocation | undefined;
    private _httpServerLocation;
    get httpServerLocation(): DataFactoryDatasetParquetHttpServerLocationOutputReference;
    putHttpServerLocation(value: DataFactoryDatasetParquetHttpServerLocation): void;
    resetHttpServerLocation(): void;
    get httpServerLocationInput(): DataFactoryDatasetParquetHttpServerLocation | undefined;
    private _schemaColumn;
    get schemaColumn(): DataFactoryDatasetParquetSchemaColumnList;
    putSchemaColumn(value: DataFactoryDatasetParquetSchemaColumn[] | cdktf.IResolvable): void;
    resetSchemaColumn(): void;
    get schemaColumnInput(): cdktf.IResolvable | DataFactoryDatasetParquetSchemaColumn[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDatasetParquetTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDatasetParquetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryDatasetParquetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
