/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatadogMonitorTagRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#datadog_monitor_id DatadogMonitorTagRule#datadog_monitor_id}
    */
    readonly datadogMonitorId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#id DatadogMonitorTagRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#name DatadogMonitorTagRule#name}
    */
    readonly name?: string;
    /**
    * log block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#log DatadogMonitorTagRule#log}
    */
    readonly log?: DatadogMonitorTagRuleLog[] | cdktf.IResolvable;
    /**
    * metric block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#metric DatadogMonitorTagRule#metric}
    */
    readonly metric?: DatadogMonitorTagRuleMetric[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#timeouts DatadogMonitorTagRule#timeouts}
    */
    readonly timeouts?: DatadogMonitorTagRuleTimeouts;
}
export interface DatadogMonitorTagRuleLogFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#action DatadogMonitorTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#name DatadogMonitorTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#value DatadogMonitorTagRule#value}
    */
    readonly value: string;
}
export declare function datadogMonitorTagRuleLogFilterToTerraform(struct?: DatadogMonitorTagRuleLogFilter | cdktf.IResolvable): any;
export declare function datadogMonitorTagRuleLogFilterToHclTerraform(struct?: DatadogMonitorTagRuleLogFilter | cdktf.IResolvable): any;
export declare class DatadogMonitorTagRuleLogFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatadogMonitorTagRuleLogFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTagRuleLogFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DatadogMonitorTagRuleLogFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatadogMonitorTagRuleLogFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatadogMonitorTagRuleLogFilterOutputReference;
}
export interface DatadogMonitorTagRuleLog {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#aad_log_enabled DatadogMonitorTagRule#aad_log_enabled}
    */
    readonly aadLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#resource_log_enabled DatadogMonitorTagRule#resource_log_enabled}
    */
    readonly resourceLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#subscription_log_enabled DatadogMonitorTagRule#subscription_log_enabled}
    */
    readonly subscriptionLogEnabled?: boolean | cdktf.IResolvable;
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#filter DatadogMonitorTagRule#filter}
    */
    readonly filter?: DatadogMonitorTagRuleLogFilter[] | cdktf.IResolvable;
}
export declare function datadogMonitorTagRuleLogToTerraform(struct?: DatadogMonitorTagRuleLog | cdktf.IResolvable): any;
export declare function datadogMonitorTagRuleLogToHclTerraform(struct?: DatadogMonitorTagRuleLog | cdktf.IResolvable): any;
export declare class DatadogMonitorTagRuleLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatadogMonitorTagRuleLog | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTagRuleLog | cdktf.IResolvable | undefined);
    private _aadLogEnabled?;
    get aadLogEnabled(): boolean | cdktf.IResolvable;
    set aadLogEnabled(value: boolean | cdktf.IResolvable);
    resetAadLogEnabled(): void;
    get aadLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLogEnabled?;
    get resourceLogEnabled(): boolean | cdktf.IResolvable;
    set resourceLogEnabled(value: boolean | cdktf.IResolvable);
    resetResourceLogEnabled(): void;
    get resourceLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _subscriptionLogEnabled?;
    get subscriptionLogEnabled(): boolean | cdktf.IResolvable;
    set subscriptionLogEnabled(value: boolean | cdktf.IResolvable);
    resetSubscriptionLogEnabled(): void;
    get subscriptionLogEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter;
    get filter(): DatadogMonitorTagRuleLogFilterList;
    putFilter(value: DatadogMonitorTagRuleLogFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DatadogMonitorTagRuleLogFilter[] | undefined;
}
export declare class DatadogMonitorTagRuleLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatadogMonitorTagRuleLog[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatadogMonitorTagRuleLogOutputReference;
}
export interface DatadogMonitorTagRuleMetricFilter {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#action DatadogMonitorTagRule#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#name DatadogMonitorTagRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#value DatadogMonitorTagRule#value}
    */
    readonly value: string;
}
export declare function datadogMonitorTagRuleMetricFilterToTerraform(struct?: DatadogMonitorTagRuleMetricFilter | cdktf.IResolvable): any;
export declare function datadogMonitorTagRuleMetricFilterToHclTerraform(struct?: DatadogMonitorTagRuleMetricFilter | cdktf.IResolvable): any;
export declare class DatadogMonitorTagRuleMetricFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatadogMonitorTagRuleMetricFilter | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTagRuleMetricFilter | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class DatadogMonitorTagRuleMetricFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatadogMonitorTagRuleMetricFilter[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatadogMonitorTagRuleMetricFilterOutputReference;
}
export interface DatadogMonitorTagRuleMetric {
    /**
    * filter block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#filter DatadogMonitorTagRule#filter}
    */
    readonly filter?: DatadogMonitorTagRuleMetricFilter[] | cdktf.IResolvable;
}
export declare function datadogMonitorTagRuleMetricToTerraform(struct?: DatadogMonitorTagRuleMetric | cdktf.IResolvable): any;
export declare function datadogMonitorTagRuleMetricToHclTerraform(struct?: DatadogMonitorTagRuleMetric | cdktf.IResolvable): any;
export declare class DatadogMonitorTagRuleMetricOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatadogMonitorTagRuleMetric | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTagRuleMetric | cdktf.IResolvable | undefined);
    private _filter;
    get filter(): DatadogMonitorTagRuleMetricFilterList;
    putFilter(value: DatadogMonitorTagRuleMetricFilter[] | cdktf.IResolvable): void;
    resetFilter(): void;
    get filterInput(): cdktf.IResolvable | DatadogMonitorTagRuleMetricFilter[] | undefined;
}
export declare class DatadogMonitorTagRuleMetricList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DatadogMonitorTagRuleMetric[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatadogMonitorTagRuleMetricOutputReference;
}
export interface DatadogMonitorTagRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#create DatadogMonitorTagRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#delete DatadogMonitorTagRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#read DatadogMonitorTagRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#update DatadogMonitorTagRule#update}
    */
    readonly update?: string;
}
export declare function datadogMonitorTagRuleTimeoutsToTerraform(struct?: DatadogMonitorTagRuleTimeouts | cdktf.IResolvable): any;
export declare function datadogMonitorTagRuleTimeoutsToHclTerraform(struct?: DatadogMonitorTagRuleTimeouts | cdktf.IResolvable): any;
export declare class DatadogMonitorTagRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatadogMonitorTagRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatadogMonitorTagRuleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule azurerm_datadog_monitor_tag_rule}
*/
export declare class DatadogMonitorTagRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_datadog_monitor_tag_rule";
    /**
    * Generates CDKTF code for importing a DatadogMonitorTagRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatadogMonitorTagRule to import
    * @param importFromId The id of the existing DatadogMonitorTagRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatadogMonitorTagRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/datadog_monitor_tag_rule azurerm_datadog_monitor_tag_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatadogMonitorTagRuleConfig
    */
    constructor(scope: Construct, id: string, config: DatadogMonitorTagRuleConfig);
    private _datadogMonitorId?;
    get datadogMonitorId(): string;
    set datadogMonitorId(value: string);
    get datadogMonitorIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _log;
    get log(): DatadogMonitorTagRuleLogList;
    putLog(value: DatadogMonitorTagRuleLog[] | cdktf.IResolvable): void;
    resetLog(): void;
    get logInput(): cdktf.IResolvable | DatadogMonitorTagRuleLog[] | undefined;
    private _metric;
    get metric(): DatadogMonitorTagRuleMetricList;
    putMetric(value: DatadogMonitorTagRuleMetric[] | cdktf.IResolvable): void;
    resetMetric(): void;
    get metricInput(): cdktf.IResolvable | DatadogMonitorTagRuleMetric[] | undefined;
    private _timeouts;
    get timeouts(): DatadogMonitorTagRuleTimeoutsOutputReference;
    putTimeouts(value: DatadogMonitorTagRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatadogMonitorTagRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
