/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynatraceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#id DynatraceMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#location DynatraceMonitor#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#marketplace_subscription DynatraceMonitor#marketplace_subscription}
    */
    readonly marketplaceSubscription: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#monitoring_enabled DynatraceMonitor#monitoring_enabled}
    */
    readonly monitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#name DynatraceMonitor#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#resource_group_name DynatraceMonitor#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#tags DynatraceMonitor#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#identity DynatraceMonitor#identity}
    */
    readonly identity: DynatraceMonitorIdentity;
    /**
    * plan block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#plan DynatraceMonitor#plan}
    */
    readonly plan: DynatraceMonitorPlan;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#timeouts DynatraceMonitor#timeouts}
    */
    readonly timeouts?: DynatraceMonitorTimeouts;
    /**
    * user block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#user DynatraceMonitor#user}
    */
    readonly user: DynatraceMonitorUser;
}
export interface DynatraceMonitorIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#type DynatraceMonitor#type}
    */
    readonly type: string;
}
export declare function dynatraceMonitorIdentityToTerraform(struct?: DynatraceMonitorIdentityOutputReference | DynatraceMonitorIdentity): any;
export declare function dynatraceMonitorIdentityToHclTerraform(struct?: DynatraceMonitorIdentityOutputReference | DynatraceMonitorIdentity): any;
export declare class DynatraceMonitorIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceMonitorIdentity | undefined;
    set internalValue(value: DynatraceMonitorIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DynatraceMonitorPlan {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#billing_cycle DynatraceMonitor#billing_cycle}
    */
    readonly billingCycle?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#plan DynatraceMonitor#plan}
    */
    readonly plan: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#usage_type DynatraceMonitor#usage_type}
    */
    readonly usageType?: string;
}
export declare function dynatraceMonitorPlanToTerraform(struct?: DynatraceMonitorPlanOutputReference | DynatraceMonitorPlan): any;
export declare function dynatraceMonitorPlanToHclTerraform(struct?: DynatraceMonitorPlanOutputReference | DynatraceMonitorPlan): any;
export declare class DynatraceMonitorPlanOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceMonitorPlan | undefined;
    set internalValue(value: DynatraceMonitorPlan | undefined);
    private _billingCycle?;
    get billingCycle(): string;
    set billingCycle(value: string);
    resetBillingCycle(): void;
    get billingCycleInput(): string | undefined;
    get effectiveDate(): string;
    private _plan?;
    get plan(): string;
    set plan(value: string);
    get planInput(): string | undefined;
    private _usageType?;
    get usageType(): string;
    set usageType(value: string);
    resetUsageType(): void;
    get usageTypeInput(): string | undefined;
}
export interface DynatraceMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#create DynatraceMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#delete DynatraceMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#read DynatraceMonitor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#update DynatraceMonitor#update}
    */
    readonly update?: string;
}
export declare function dynatraceMonitorTimeoutsToTerraform(struct?: DynatraceMonitorTimeouts | cdktf.IResolvable): any;
export declare function dynatraceMonitorTimeoutsToHclTerraform(struct?: DynatraceMonitorTimeouts | cdktf.IResolvable): any;
export declare class DynatraceMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DynatraceMonitorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DynatraceMonitorUser {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#country DynatraceMonitor#country}
    */
    readonly country: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#email DynatraceMonitor#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#first_name DynatraceMonitor#first_name}
    */
    readonly firstName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#last_name DynatraceMonitor#last_name}
    */
    readonly lastName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#phone_number DynatraceMonitor#phone_number}
    */
    readonly phoneNumber: string;
}
export declare function dynatraceMonitorUserToTerraform(struct?: DynatraceMonitorUserOutputReference | DynatraceMonitorUser): any;
export declare function dynatraceMonitorUserToHclTerraform(struct?: DynatraceMonitorUserOutputReference | DynatraceMonitorUser): any;
export declare class DynatraceMonitorUserOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynatraceMonitorUser | undefined;
    set internalValue(value: DynatraceMonitorUser | undefined);
    private _country?;
    get country(): string;
    set country(value: string);
    get countryInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _firstName?;
    get firstName(): string;
    set firstName(value: string);
    get firstNameInput(): string | undefined;
    private _lastName?;
    get lastName(): string;
    set lastName(value: string);
    get lastNameInput(): string | undefined;
    private _phoneNumber?;
    get phoneNumber(): string;
    set phoneNumber(value: string);
    get phoneNumberInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor azurerm_dynatrace_monitor}
*/
export declare class DynatraceMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dynatrace_monitor";
    /**
    * Generates CDKTF code for importing a DynatraceMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynatraceMonitor to import
    * @param importFromId The id of the existing DynatraceMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynatraceMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/dynatrace_monitor azurerm_dynatrace_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynatraceMonitorConfig
    */
    constructor(scope: Construct, id: string, config: DynatraceMonitorConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _marketplaceSubscription?;
    get marketplaceSubscription(): string;
    set marketplaceSubscription(value: string);
    get marketplaceSubscriptionInput(): string | undefined;
    private _monitoringEnabled?;
    get monitoringEnabled(): boolean | cdktf.IResolvable;
    set monitoringEnabled(value: boolean | cdktf.IResolvable);
    resetMonitoringEnabled(): void;
    get monitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _identity;
    get identity(): DynatraceMonitorIdentityOutputReference;
    putIdentity(value: DynatraceMonitorIdentity): void;
    get identityInput(): DynatraceMonitorIdentity | undefined;
    private _plan;
    get plan(): DynatraceMonitorPlanOutputReference;
    putPlan(value: DynatraceMonitorPlan): void;
    get planInput(): DynatraceMonitorPlan | undefined;
    private _timeouts;
    get timeouts(): DynatraceMonitorTimeoutsOutputReference;
    putTimeouts(value: DynatraceMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DynatraceMonitorTimeouts | undefined;
    private _user;
    get user(): DynatraceMonitorUserOutputReference;
    putUser(value: DynatraceMonitorUser): void;
    get userInput(): DynatraceMonitorUser | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
