/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesFleetManagerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#id KubernetesFleetManager#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#location KubernetesFleetManager#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#name KubernetesFleetManager#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#resource_group_name KubernetesFleetManager#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#tags KubernetesFleetManager#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * hub_profile block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#hub_profile KubernetesFleetManager#hub_profile}
    */
    readonly hubProfile?: KubernetesFleetManagerHubProfile;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#timeouts KubernetesFleetManager#timeouts}
    */
    readonly timeouts?: KubernetesFleetManagerTimeouts;
}
export interface KubernetesFleetManagerHubProfile {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#dns_prefix KubernetesFleetManager#dns_prefix}
    */
    readonly dnsPrefix: string;
}
export declare function kubernetesFleetManagerHubProfileToTerraform(struct?: KubernetesFleetManagerHubProfileOutputReference | KubernetesFleetManagerHubProfile): any;
export declare function kubernetesFleetManagerHubProfileToHclTerraform(struct?: KubernetesFleetManagerHubProfileOutputReference | KubernetesFleetManagerHubProfile): any;
export declare class KubernetesFleetManagerHubProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetManagerHubProfile | undefined;
    set internalValue(value: KubernetesFleetManagerHubProfile | undefined);
    private _dnsPrefix?;
    get dnsPrefix(): string;
    set dnsPrefix(value: string);
    get dnsPrefixInput(): string | undefined;
    get fqdn(): string;
    get kubernetesVersion(): string;
}
export interface KubernetesFleetManagerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#create KubernetesFleetManager#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#delete KubernetesFleetManager#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#read KubernetesFleetManager#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#update KubernetesFleetManager#update}
    */
    readonly update?: string;
}
export declare function kubernetesFleetManagerTimeoutsToTerraform(struct?: KubernetesFleetManagerTimeouts | cdktf.IResolvable): any;
export declare function kubernetesFleetManagerTimeoutsToHclTerraform(struct?: KubernetesFleetManagerTimeouts | cdktf.IResolvable): any;
export declare class KubernetesFleetManagerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetManagerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetManagerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager azurerm_kubernetes_fleet_manager}
*/
export declare class KubernetesFleetManager extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_fleet_manager";
    /**
    * Generates CDKTF code for importing a KubernetesFleetManager resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesFleetManager to import
    * @param importFromId The id of the existing KubernetesFleetManager that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesFleetManager to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_fleet_manager azurerm_kubernetes_fleet_manager} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesFleetManagerConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesFleetManagerConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _hubProfile;
    get hubProfile(): KubernetesFleetManagerHubProfileOutputReference;
    putHubProfile(value: KubernetesFleetManagerHubProfile): void;
    resetHubProfile(): void;
    get hubProfileInput(): KubernetesFleetManagerHubProfile | undefined;
    private _timeouts;
    get timeouts(): KubernetesFleetManagerTimeoutsOutputReference;
    putTimeouts(value: KubernetesFleetManagerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesFleetManagerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
