/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesFluxConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#cluster_id KubernetesFluxConfiguration#cluster_id}
    */
    readonly clusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#continuous_reconciliation_enabled KubernetesFluxConfiguration#continuous_reconciliation_enabled}
    */
    readonly continuousReconciliationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#id KubernetesFluxConfiguration#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#name KubernetesFluxConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#namespace KubernetesFluxConfiguration#namespace}
    */
    readonly namespace: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#scope KubernetesFluxConfiguration#scope}
    */
    readonly scope?: string;
    /**
    * blob_storage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#blob_storage KubernetesFluxConfiguration#blob_storage}
    */
    readonly blobStorage?: KubernetesFluxConfigurationBlobStorage;
    /**
    * bucket block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#bucket KubernetesFluxConfiguration#bucket}
    */
    readonly bucket?: KubernetesFluxConfigurationBucket;
    /**
    * git_repository block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#git_repository KubernetesFluxConfiguration#git_repository}
    */
    readonly gitRepository?: KubernetesFluxConfigurationGitRepository;
    /**
    * kustomizations block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#kustomizations KubernetesFluxConfiguration#kustomizations}
    */
    readonly kustomizations: KubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#timeouts KubernetesFluxConfiguration#timeouts}
    */
    readonly timeouts?: KubernetesFluxConfigurationTimeouts;
}
export interface KubernetesFluxConfigurationBlobStorageManagedIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_id KubernetesFluxConfiguration#client_id}
    */
    readonly clientId: string;
}
export declare function kubernetesFluxConfigurationBlobStorageManagedIdentityToTerraform(struct?: KubernetesFluxConfigurationBlobStorageManagedIdentityOutputReference | KubernetesFluxConfigurationBlobStorageManagedIdentity): any;
export declare function kubernetesFluxConfigurationBlobStorageManagedIdentityToHclTerraform(struct?: KubernetesFluxConfigurationBlobStorageManagedIdentityOutputReference | KubernetesFluxConfigurationBlobStorageManagedIdentity): any;
export declare class KubernetesFluxConfigurationBlobStorageManagedIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationBlobStorageManagedIdentity | undefined;
    set internalValue(value: KubernetesFluxConfigurationBlobStorageManagedIdentity | undefined);
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
}
export interface KubernetesFluxConfigurationBlobStorageServicePrincipal {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_certificate_base64 KubernetesFluxConfiguration#client_certificate_base64}
    */
    readonly clientCertificateBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_certificate_password KubernetesFluxConfiguration#client_certificate_password}
    */
    readonly clientCertificatePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_certificate_send_chain KubernetesFluxConfiguration#client_certificate_send_chain}
    */
    readonly clientCertificateSendChain?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_id KubernetesFluxConfiguration#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#client_secret KubernetesFluxConfiguration#client_secret}
    */
    readonly clientSecret?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#tenant_id KubernetesFluxConfiguration#tenant_id}
    */
    readonly tenantId: string;
}
export declare function kubernetesFluxConfigurationBlobStorageServicePrincipalToTerraform(struct?: KubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference | KubernetesFluxConfigurationBlobStorageServicePrincipal): any;
export declare function kubernetesFluxConfigurationBlobStorageServicePrincipalToHclTerraform(struct?: KubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference | KubernetesFluxConfigurationBlobStorageServicePrincipal): any;
export declare class KubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationBlobStorageServicePrincipal | undefined;
    set internalValue(value: KubernetesFluxConfigurationBlobStorageServicePrincipal | undefined);
    private _clientCertificateBase64?;
    get clientCertificateBase64(): string;
    set clientCertificateBase64(value: string);
    resetClientCertificateBase64(): void;
    get clientCertificateBase64Input(): string | undefined;
    private _clientCertificatePassword?;
    get clientCertificatePassword(): string;
    set clientCertificatePassword(value: string);
    resetClientCertificatePassword(): void;
    get clientCertificatePasswordInput(): string | undefined;
    private _clientCertificateSendChain?;
    get clientCertificateSendChain(): boolean | cdktf.IResolvable;
    set clientCertificateSendChain(value: boolean | cdktf.IResolvable);
    resetClientCertificateSendChain(): void;
    get clientCertificateSendChainInput(): boolean | cdktf.IResolvable | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    resetClientSecret(): void;
    get clientSecretInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface KubernetesFluxConfigurationBlobStorage {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#account_key KubernetesFluxConfiguration#account_key}
    */
    readonly accountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#container_id KubernetesFluxConfiguration#container_id}
    */
    readonly containerId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#local_auth_reference KubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#sas_token KubernetesFluxConfiguration#sas_token}
    */
    readonly sasToken?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#sync_interval_in_seconds KubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#timeout_in_seconds KubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * managed_identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#managed_identity KubernetesFluxConfiguration#managed_identity}
    */
    readonly managedIdentity?: KubernetesFluxConfigurationBlobStorageManagedIdentity;
    /**
    * service_principal block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#service_principal KubernetesFluxConfiguration#service_principal}
    */
    readonly servicePrincipal?: KubernetesFluxConfigurationBlobStorageServicePrincipal;
}
export declare function kubernetesFluxConfigurationBlobStorageToTerraform(struct?: KubernetesFluxConfigurationBlobStorageOutputReference | KubernetesFluxConfigurationBlobStorage): any;
export declare function kubernetesFluxConfigurationBlobStorageToHclTerraform(struct?: KubernetesFluxConfigurationBlobStorageOutputReference | KubernetesFluxConfigurationBlobStorage): any;
export declare class KubernetesFluxConfigurationBlobStorageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationBlobStorage | undefined;
    set internalValue(value: KubernetesFluxConfigurationBlobStorage | undefined);
    private _accountKey?;
    get accountKey(): string;
    set accountKey(value: string);
    resetAccountKey(): void;
    get accountKeyInput(): string | undefined;
    private _containerId?;
    get containerId(): string;
    set containerId(value: string);
    get containerIdInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    resetSasToken(): void;
    get sasTokenInput(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _managedIdentity;
    get managedIdentity(): KubernetesFluxConfigurationBlobStorageManagedIdentityOutputReference;
    putManagedIdentity(value: KubernetesFluxConfigurationBlobStorageManagedIdentity): void;
    resetManagedIdentity(): void;
    get managedIdentityInput(): KubernetesFluxConfigurationBlobStorageManagedIdentity | undefined;
    private _servicePrincipal;
    get servicePrincipal(): KubernetesFluxConfigurationBlobStorageServicePrincipalOutputReference;
    putServicePrincipal(value: KubernetesFluxConfigurationBlobStorageServicePrincipal): void;
    resetServicePrincipal(): void;
    get servicePrincipalInput(): KubernetesFluxConfigurationBlobStorageServicePrincipal | undefined;
}
export interface KubernetesFluxConfigurationBucket {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#access_key KubernetesFluxConfiguration#access_key}
    */
    readonly accessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#bucket_name KubernetesFluxConfiguration#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#local_auth_reference KubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#secret_key_base64 KubernetesFluxConfiguration#secret_key_base64}
    */
    readonly secretKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#sync_interval_in_seconds KubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#timeout_in_seconds KubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#tls_enabled KubernetesFluxConfiguration#tls_enabled}
    */
    readonly tlsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#url KubernetesFluxConfiguration#url}
    */
    readonly url: string;
}
export declare function kubernetesFluxConfigurationBucketToTerraform(struct?: KubernetesFluxConfigurationBucketOutputReference | KubernetesFluxConfigurationBucket): any;
export declare function kubernetesFluxConfigurationBucketToHclTerraform(struct?: KubernetesFluxConfigurationBucketOutputReference | KubernetesFluxConfigurationBucket): any;
export declare class KubernetesFluxConfigurationBucketOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationBucket | undefined;
    set internalValue(value: KubernetesFluxConfigurationBucket | undefined);
    private _accessKey?;
    get accessKey(): string;
    set accessKey(value: string);
    resetAccessKey(): void;
    get accessKeyInput(): string | undefined;
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _secretKeyBase64?;
    get secretKeyBase64(): string;
    set secretKeyBase64(value: string);
    resetSecretKeyBase64(): void;
    get secretKeyBase64Input(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _tlsEnabled?;
    get tlsEnabled(): boolean | cdktf.IResolvable;
    set tlsEnabled(value: boolean | cdktf.IResolvable);
    resetTlsEnabled(): void;
    get tlsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface KubernetesFluxConfigurationGitRepository {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#https_ca_cert_base64 KubernetesFluxConfiguration#https_ca_cert_base64}
    */
    readonly httpsCaCertBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#https_key_base64 KubernetesFluxConfiguration#https_key_base64}
    */
    readonly httpsKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#https_user KubernetesFluxConfiguration#https_user}
    */
    readonly httpsUser?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#local_auth_reference KubernetesFluxConfiguration#local_auth_reference}
    */
    readonly localAuthReference?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#reference_type KubernetesFluxConfiguration#reference_type}
    */
    readonly referenceType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#reference_value KubernetesFluxConfiguration#reference_value}
    */
    readonly referenceValue: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#ssh_known_hosts_base64 KubernetesFluxConfiguration#ssh_known_hosts_base64}
    */
    readonly sshKnownHostsBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#ssh_private_key_base64 KubernetesFluxConfiguration#ssh_private_key_base64}
    */
    readonly sshPrivateKeyBase64?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#sync_interval_in_seconds KubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#timeout_in_seconds KubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#url KubernetesFluxConfiguration#url}
    */
    readonly url: string;
}
export declare function kubernetesFluxConfigurationGitRepositoryToTerraform(struct?: KubernetesFluxConfigurationGitRepositoryOutputReference | KubernetesFluxConfigurationGitRepository): any;
export declare function kubernetesFluxConfigurationGitRepositoryToHclTerraform(struct?: KubernetesFluxConfigurationGitRepositoryOutputReference | KubernetesFluxConfigurationGitRepository): any;
export declare class KubernetesFluxConfigurationGitRepositoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationGitRepository | undefined;
    set internalValue(value: KubernetesFluxConfigurationGitRepository | undefined);
    private _httpsCaCertBase64?;
    get httpsCaCertBase64(): string;
    set httpsCaCertBase64(value: string);
    resetHttpsCaCertBase64(): void;
    get httpsCaCertBase64Input(): string | undefined;
    private _httpsKeyBase64?;
    get httpsKeyBase64(): string;
    set httpsKeyBase64(value: string);
    resetHttpsKeyBase64(): void;
    get httpsKeyBase64Input(): string | undefined;
    private _httpsUser?;
    get httpsUser(): string;
    set httpsUser(value: string);
    resetHttpsUser(): void;
    get httpsUserInput(): string | undefined;
    private _localAuthReference?;
    get localAuthReference(): string;
    set localAuthReference(value: string);
    resetLocalAuthReference(): void;
    get localAuthReferenceInput(): string | undefined;
    private _referenceType?;
    get referenceType(): string;
    set referenceType(value: string);
    get referenceTypeInput(): string | undefined;
    private _referenceValue?;
    get referenceValue(): string;
    set referenceValue(value: string);
    get referenceValueInput(): string | undefined;
    private _sshKnownHostsBase64?;
    get sshKnownHostsBase64(): string;
    set sshKnownHostsBase64(value: string);
    resetSshKnownHostsBase64(): void;
    get sshKnownHostsBase64Input(): string | undefined;
    private _sshPrivateKeyBase64?;
    get sshPrivateKeyBase64(): string;
    set sshPrivateKeyBase64(value: string);
    resetSshPrivateKeyBase64(): void;
    get sshPrivateKeyBase64Input(): string | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
}
export interface KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#kind KubernetesFluxConfiguration#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#name KubernetesFluxConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#optional KubernetesFluxConfiguration#optional}
    */
    readonly optional?: boolean | cdktf.IResolvable;
}
export declare function kubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromToTerraform(struct?: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom | cdktf.IResolvable): any;
export declare function kubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromToHclTerraform(struct?: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom | cdktf.IResolvable): any;
export declare class KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom | cdktf.IResolvable | undefined);
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _optional?;
    get optional(): boolean | cdktf.IResolvable;
    set optional(value: boolean | cdktf.IResolvable);
    resetOptional(): void;
    get optionalInput(): boolean | cdktf.IResolvable | undefined;
}
export declare class KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromOutputReference;
}
export interface KubernetesFluxConfigurationKustomizationsPostBuild {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#substitute KubernetesFluxConfiguration#substitute}
    */
    readonly substitute?: {
        [key: string]: string;
    };
    /**
    * substitute_from block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#substitute_from KubernetesFluxConfiguration#substitute_from}
    */
    readonly substituteFrom?: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom[] | cdktf.IResolvable;
}
export declare function kubernetesFluxConfigurationKustomizationsPostBuildToTerraform(struct?: KubernetesFluxConfigurationKustomizationsPostBuildOutputReference | KubernetesFluxConfigurationKustomizationsPostBuild): any;
export declare function kubernetesFluxConfigurationKustomizationsPostBuildToHclTerraform(struct?: KubernetesFluxConfigurationKustomizationsPostBuildOutputReference | KubernetesFluxConfigurationKustomizationsPostBuild): any;
export declare class KubernetesFluxConfigurationKustomizationsPostBuildOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationKustomizationsPostBuild | undefined;
    set internalValue(value: KubernetesFluxConfigurationKustomizationsPostBuild | undefined);
    private _substitute?;
    get substitute(): {
        [key: string]: string;
    };
    set substitute(value: {
        [key: string]: string;
    });
    resetSubstitute(): void;
    get substituteInput(): {
        [key: string]: string;
    } | undefined;
    private _substituteFrom;
    get substituteFrom(): KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFromList;
    putSubstituteFrom(value: KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom[] | cdktf.IResolvable): void;
    resetSubstituteFrom(): void;
    get substituteFromInput(): cdktf.IResolvable | KubernetesFluxConfigurationKustomizationsPostBuildSubstituteFrom[] | undefined;
}
export interface KubernetesFluxConfigurationKustomizations {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#depends_on KubernetesFluxConfiguration#depends_on}
    */
    readonly dependsOn?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#garbage_collection_enabled KubernetesFluxConfiguration#garbage_collection_enabled}
    */
    readonly garbageCollectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#name KubernetesFluxConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#path KubernetesFluxConfiguration#path}
    */
    readonly path?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#recreating_enabled KubernetesFluxConfiguration#recreating_enabled}
    */
    readonly recreatingEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#retry_interval_in_seconds KubernetesFluxConfiguration#retry_interval_in_seconds}
    */
    readonly retryIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#sync_interval_in_seconds KubernetesFluxConfiguration#sync_interval_in_seconds}
    */
    readonly syncIntervalInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#timeout_in_seconds KubernetesFluxConfiguration#timeout_in_seconds}
    */
    readonly timeoutInSeconds?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#wait KubernetesFluxConfiguration#wait}
    */
    readonly wait?: boolean | cdktf.IResolvable;
    /**
    * post_build block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#post_build KubernetesFluxConfiguration#post_build}
    */
    readonly postBuild?: KubernetesFluxConfigurationKustomizationsPostBuild;
}
export declare function kubernetesFluxConfigurationKustomizationsToTerraform(struct?: KubernetesFluxConfigurationKustomizations | cdktf.IResolvable): any;
export declare function kubernetesFluxConfigurationKustomizationsToHclTerraform(struct?: KubernetesFluxConfigurationKustomizations | cdktf.IResolvable): any;
export declare class KubernetesFluxConfigurationKustomizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): KubernetesFluxConfigurationKustomizations | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFluxConfigurationKustomizations | cdktf.IResolvable | undefined);
    private _dependsOn?;
    get dependsOn(): string[];
    set dependsOn(value: string[]);
    resetDependsOn(): void;
    get dependsOnInput(): string[] | undefined;
    private _garbageCollectionEnabled?;
    get garbageCollectionEnabled(): boolean | cdktf.IResolvable;
    set garbageCollectionEnabled(value: boolean | cdktf.IResolvable);
    resetGarbageCollectionEnabled(): void;
    get garbageCollectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _recreatingEnabled?;
    get recreatingEnabled(): boolean | cdktf.IResolvable;
    set recreatingEnabled(value: boolean | cdktf.IResolvable);
    resetRecreatingEnabled(): void;
    get recreatingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retryIntervalInSeconds?;
    get retryIntervalInSeconds(): number;
    set retryIntervalInSeconds(value: number);
    resetRetryIntervalInSeconds(): void;
    get retryIntervalInSecondsInput(): number | undefined;
    private _syncIntervalInSeconds?;
    get syncIntervalInSeconds(): number;
    set syncIntervalInSeconds(value: number);
    resetSyncIntervalInSeconds(): void;
    get syncIntervalInSecondsInput(): number | undefined;
    private _timeoutInSeconds?;
    get timeoutInSeconds(): number;
    set timeoutInSeconds(value: number);
    resetTimeoutInSeconds(): void;
    get timeoutInSecondsInput(): number | undefined;
    private _wait?;
    get wait(): boolean | cdktf.IResolvable;
    set wait(value: boolean | cdktf.IResolvable);
    resetWait(): void;
    get waitInput(): boolean | cdktf.IResolvable | undefined;
    private _postBuild;
    get postBuild(): KubernetesFluxConfigurationKustomizationsPostBuildOutputReference;
    putPostBuild(value: KubernetesFluxConfigurationKustomizationsPostBuild): void;
    resetPostBuild(): void;
    get postBuildInput(): KubernetesFluxConfigurationKustomizationsPostBuild | undefined;
}
export declare class KubernetesFluxConfigurationKustomizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: KubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): KubernetesFluxConfigurationKustomizationsOutputReference;
}
export interface KubernetesFluxConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#create KubernetesFluxConfiguration#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#delete KubernetesFluxConfiguration#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#read KubernetesFluxConfiguration#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#update KubernetesFluxConfiguration#update}
    */
    readonly update?: string;
}
export declare function kubernetesFluxConfigurationTimeoutsToTerraform(struct?: KubernetesFluxConfigurationTimeouts | cdktf.IResolvable): any;
export declare function kubernetesFluxConfigurationTimeoutsToHclTerraform(struct?: KubernetesFluxConfigurationTimeouts | cdktf.IResolvable): any;
export declare class KubernetesFluxConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFluxConfigurationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFluxConfigurationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration azurerm_kubernetes_flux_configuration}
*/
export declare class KubernetesFluxConfiguration extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_flux_configuration";
    /**
    * Generates CDKTF code for importing a KubernetesFluxConfiguration resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesFluxConfiguration to import
    * @param importFromId The id of the existing KubernetesFluxConfiguration that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesFluxConfiguration to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/4.19.0/docs/resources/kubernetes_flux_configuration azurerm_kubernetes_flux_configuration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesFluxConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesFluxConfigurationConfig);
    private _clusterId?;
    get clusterId(): string;
    set clusterId(value: string);
    get clusterIdInput(): string | undefined;
    private _continuousReconciliationEnabled?;
    get continuousReconciliationEnabled(): boolean | cdktf.IResolvable;
    set continuousReconciliationEnabled(value: boolean | cdktf.IResolvable);
    resetContinuousReconciliationEnabled(): void;
    get continuousReconciliationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    get namespaceInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _blobStorage;
    get blobStorage(): KubernetesFluxConfigurationBlobStorageOutputReference;
    putBlobStorage(value: KubernetesFluxConfigurationBlobStorage): void;
    resetBlobStorage(): void;
    get blobStorageInput(): KubernetesFluxConfigurationBlobStorage | undefined;
    private _bucket;
    get bucket(): KubernetesFluxConfigurationBucketOutputReference;
    putBucket(value: KubernetesFluxConfigurationBucket): void;
    resetBucket(): void;
    get bucketInput(): KubernetesFluxConfigurationBucket | undefined;
    private _gitRepository;
    get gitRepository(): KubernetesFluxConfigurationGitRepositoryOutputReference;
    putGitRepository(value: KubernetesFluxConfigurationGitRepository): void;
    resetGitRepository(): void;
    get gitRepositoryInput(): KubernetesFluxConfigurationGitRepository | undefined;
    private _kustomizations;
    get kustomizations(): KubernetesFluxConfigurationKustomizationsList;
    putKustomizations(value: KubernetesFluxConfigurationKustomizations[] | cdktf.IResolvable): void;
    get kustomizationsInput(): cdktf.IResolvable | KubernetesFluxConfigurationKustomizations[] | undefined;
    private _timeouts;
    get timeouts(): KubernetesFluxConfigurationTimeoutsOutputReference;
    putTimeouts(value: KubernetesFluxConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesFluxConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
